/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WhiteUtil {
    private static final char[] WS = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202c', '\u202d', '\u202e', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000', '\u180e', '\u200b', '\u200c', '\u200d', '\u2060', '\ufeff'};

    public static boolean isWhite(byte b) {
        return b == 32 || b == 10 || b == 9 || b == 13 || b == -17 || b == -69 || b == -65 || b == -1 || b == -2 || b == 0;
    }

    public static byte firstNonWhite(byte[] bs) {
        if (bs == null) {
            return 0;
        }
        for (byte b : bs) {
            if (WhiteUtil.isWhite(b)) continue;
            return b;
        }
        return 0;
    }

    public static byte lastNonWhite(byte[] bs) {
        if (bs == null) {
            return 0;
        }
        for (int i = bs.length - 1; i >= 0; --i) {
            if (WhiteUtil.isWhite(bs[i])) continue;
            return bs[i];
        }
        return 0;
    }

    public static char firstNonWhite(char[] cs) {
        if (cs == null) {
            return '\u0000';
        }
        for (char c : cs) {
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    public static char lastNonWhite(char[] cs) {
        if (cs == null) {
            return '\u0000';
        }
        for (int i = cs.length - 1; i >= 0; --i) {
            if (!WhiteUtil.notWhiteSpace(cs[i])) continue;
            return cs[i];
        }
        return '\u0000';
    }

    public static char firstNonWhite(CharSequence cs) {
        if (cs == null) {
            return '\u0000';
        }
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    public static char lastNonWhite(CharSequence cs) {
        if (cs == null) {
            return '\u0000';
        }
        for (int i = cs.length() - 1; i >= 0; --i) {
            char c = cs.charAt(i);
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    public static boolean notWhiteSpace(char c) {
        return Arrays.binarySearch(WS, c) < 0;
    }

    public static boolean isWhiteSpace(char c) {
        return Arrays.binarySearch(WS, c) >= 0;
    }

    @NotNull
    public static String trim(CharSequence str) {
        int p1;
        if (str == null) {
            return "";
        }
        int len = str.length();
        int p2 = len;
        for (p1 = 0; p1 < p2 && Arrays.binarySearch(WS, str.charAt(p1)) >= 0; ++p1) {
        }
        while (p2 > p1 && Arrays.binarySearch(WS, str.charAt(p2 - 1)) >= 0) {
            --p2;
        }
        return p1 == 0 && p2 == len ? str.toString() : str.subSequence(p1, p2).toString();
    }

    @NotNull
    public static String trim(CharSequence str, char ... cs) {
        char c;
        int p1;
        if (str == null) {
            return "";
        }
        int len = str.length();
        int p2 = len;
        block0: for (p1 = 0; p1 < p2; ++p1) {
            c = str.charAt(p1);
            for (char c1 : cs) {
                if (c != c1) continue;
                continue block0;
            }
        }
        block2: while (p2 > p1) {
            c = str.charAt(p2 - 1);
            for (char c1 : cs) {
                if (c != c1) continue;
                --p2;
                continue block2;
            }
        }
        return p1 == 0 && p2 == len ? str.toString() : str.subSequence(p1, p2).toString();
    }

    @NotNull
    public static String space(CharSequence str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        boolean ws = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (WhiteUtil.notWhiteSpace(c)) {
                ws = false;
                sb.append(c);
                continue;
            }
            if (!ws) {
                sb.append(' ');
            }
            ws = true;
        }
        if (sb.length() > 0 && sb.charAt(0) == ' ') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @NotNull
    public static String delete(CharSequence str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isAllWhite(CharSequence str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (WhiteUtil.notWhiteSpace(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsWithDeleted(CharSequence str1, CharSequence str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        String s1 = WhiteUtil.delete(str1);
        String s2 = WhiteUtil.delete(str2);
        return s1.equals(s2);
    }

    public static boolean equalsWithSpaced(CharSequence str1, CharSequence str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        String s1 = WhiteUtil.space(str1);
        String s2 = WhiteUtil.space(str2);
        return s1.equals(s2);
    }

    @NotNull
    public static List<String> lines(CharSequence str) {
        int idx;
        String spd = WhiteUtil.space(str);
        int len = spd.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        int cnt = 0;
        for (int i = 0; i < len && (idx = spd.indexOf(32, i)) > 0; ++i) {
            ++cnt;
            i = idx;
        }
        ArrayList<String> result = new ArrayList<String>(cnt + 1);
        for (int i = 0; i < len; ++i) {
            int idx2 = spd.indexOf(32, i);
            if (idx2 <= 0) {
                result.add(spd.substring(i));
                break;
            }
            result.add(spd.substring(i, idx2));
            i = idx2;
        }
        return result;
    }

    static {
        Arrays.sort(WS);
    }
}

