/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.text.HalfCharUtil;
import pro.fessional.mirana.time.ThreadNow;

public class DateFormatter {
    public static final String PTN_DATE_10 = "yyyy-MM-dd";
    public static final String PTN_TIME_08 = "HH:mm:ss";
    public static final String PTN_TIME_12 = "HH:mm:ss.SSS";
    public static final String PTN_FULL_19 = "yyyy-MM-dd HH:mm:ss";
    public static final String PTN_FULL_23 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String PTN_FULL_TZ = "yyyy[-MM][-dd][ ][HH][:mm][:ss][ ][VV]";
    public static final String PTN_FULL_OZ = "yyyy[-MM][-dd][ ][HH][:mm][:ss][ ][xxx]";
    public static final String PTN_TIME_PSE = "H[:m][:s][.SSS]";
    public static final String PTN_DATE_PSE = "[yyyy][yy][-][/][.][M][-][/][.][d]";
    public static final String PTN_FULL_PSE = "[yyyy][yy][-][/][.][M][-][/][.][d][ ]['T'][H][:m][:s][.SSS]";
    public static final String PTN_ZONE_PSE = "[yyyy][yy][-][/][.][M][-][/][.][d][ ]['T'][H][:m][:s][.SSS][ ][XXXXX][XXXX][XXX][XX][X][ ]['['][VV][']']";
    public static final String PTN_DATE_PSE_US = "[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy]";
    public static final String PTN_FULL_PSE_US = "[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy][ ]['T'][H][:m][:s][.SSS]";
    public static final String PTN_ZONE_PSE_US = "[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy][ ]['T'][H][:m][:s][.SSS][ ][XXXXX][XXXX][XXX][XX][X][ ]['['][VV][']']";
    public static final DateTimeFormatter FMT_DATE_10 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter FMT_TIME_08 = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter FMT_TIME_12 = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    public static final DateTimeFormatter FMT_FULL_19 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FMT_FULL_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter FMT_TIME_PSE = DateTimeFormatter.ofPattern("H[:m][:s][.SSS]");
    public static final DateTimeFormatter FMT_DATE_PSE = DateTimeFormatter.ofPattern("[yyyy][yy][-][/][.][M][-][/][.][d]");
    public static final DateTimeFormatter FMT_FULL_PSE = DateTimeFormatter.ofPattern("[yyyy][yy][-][/][.][M][-][/][.][d][ ]['T'][H][:m][:s][.SSS]");
    public static final DateTimeFormatter FMT_ZONE_PSE = DateTimeFormatter.ofPattern("[yyyy][yy][-][/][.][M][-][/][.][d][ ]['T'][H][:m][:s][.SSS][ ][XXXXX][XXXX][XXX][XX][X][ ]['['][VV][']']");
    public static final DateTimeFormatter FMT_DATE_PSE_US = DateTimeFormatter.ofPattern("[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy]");
    public static final DateTimeFormatter FMT_FULL_PSE_US = DateTimeFormatter.ofPattern("[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy][ ]['T'][H][:m][:s][.SSS]");
    public static final DateTimeFormatter FMT_ZONE_PSE_US = DateTimeFormatter.ofPattern("[MMMM][MMM][M][-][/][.][d][-][/][.][yyyy][yy][ ]['T'][H][:m][:s][.SSS][ ][XXXXX][XXXX][XXX][XX][X][ ]['['][VV][']']");
    public static final DateTimeFormatter FMT_FULL_TZ = DateTimeFormatter.ofPattern("yyyy[-MM][-dd][ ][HH][:mm][:ss][ ][VV]");
    public static final DateTimeFormatter FMT_FULL_OZ = DateTimeFormatter.ofPattern("yyyy[-MM][-dd][ ][HH][:mm][:ss][ ][xxx]");
    public static final ThreadLocal<DateFormat> DATE_FORMAT_19 = ThreadLocal.withInitial(() -> new SimpleDateFormat(PTN_FULL_19));
    public static final ThreadLocal<DateFormat> DATE_FORMAT_23 = ThreadLocal.withInitial(() -> new SimpleDateFormat(PTN_FULL_23));

    public static DateFormat full19() {
        return DATE_FORMAT_19.get();
    }

    public static DateFormat full23() {
        return DATE_FORMAT_23.get();
    }

    @NotNull
    public static String fullTz(@Nullable ZonedDateTime date) {
        if (date == null) {
            return "";
        }
        return FMT_FULL_TZ.format(date);
    }

    @NotNull
    public static String fullTz(@Nullable OffsetDateTime date) {
        if (date == null) {
            return "";
        }
        return FMT_FULL_OZ.format(date);
    }

    @NotNull
    public static String date10(@Nullable ZonedDateTime date) {
        return DateFormatter.date10(date, null);
    }

    @NotNull
    public static String full(@Nullable ZonedDateTime date) {
        return DateFormatter.full(date, null);
    }

    @NotNull
    public static String full19(@Nullable ZonedDateTime date) {
        return DateFormatter.full19(date, null);
    }

    @NotNull
    public static String full23(@Nullable ZonedDateTime date) {
        return DateFormatter.full23(date, null);
    }

    @NotNull
    public static String time(@Nullable ZonedDateTime date) {
        if (date == null || date.getNano() > 999999) {
            return DateFormatter.time12(date, null);
        }
        return DateFormatter.time08(date, null);
    }

    @NotNull
    public static String time08(@Nullable ZonedDateTime date) {
        return DateFormatter.time08(date, null);
    }

    @NotNull
    public static String time12(@Nullable ZonedDateTime date) {
        return DateFormatter.time12(date, null);
    }

    @NotNull
    public static String date10(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        return DateFormatter.date10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @NotNull
    public static String full(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        if (date.getNano() > 999999) {
            return DateFormatter.full23(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
        }
        return DateFormatter.full19(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String full19(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        return DateFormatter.full19(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String full23(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        return DateFormatter.full23(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    @NotNull
    public static String time(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        if (date.getNano() > 999999) {
            return DateFormatter.time12(date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
        }
        return DateFormatter.time08(date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String time08(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        return DateFormatter.time08(date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String time12(@Nullable ZonedDateTime date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        if (zoneId != null && !zoneId.equals(date.getZone())) {
            date = date.withZoneSameInstant(zoneId);
        }
        return DateFormatter.time12(date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    @NotNull
    public static String date10(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.date10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @NotNull
    public static String full(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        if (date.getNano() > 999999) {
            return DateFormatter.full23(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
        }
        return DateFormatter.full19(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String full19(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.full19(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String full23(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.full23(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    @NotNull
    public static String time(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        if (date.getNano() > 999999) {
            return DateFormatter.time12(date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
        }
        return DateFormatter.time08(date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String time08(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.time08(date.getHour(), date.getMinute(), date.getSecond());
    }

    @NotNull
    public static String time12(@Nullable LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.time12(date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    @NotNull
    public static String date10(@Nullable LocalDate date) {
        if (date == null) {
            return "";
        }
        return DateFormatter.date10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @NotNull
    public static String time(@Nullable LocalTime time) {
        if (time == null) {
            return "";
        }
        if (time.getNano() > 999999) {
            return DateFormatter.time12(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
        }
        return DateFormatter.time08(time.getHour(), time.getMinute(), time.getSecond());
    }

    @NotNull
    public static String time08(@Nullable LocalTime time) {
        if (time == null) {
            return "";
        }
        return DateFormatter.time08(time.getHour(), time.getMinute(), time.getSecond());
    }

    @NotNull
    public static String time12(@Nullable LocalTime time) {
        if (time == null) {
            return "";
        }
        return DateFormatter.time12(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    @NotNull
    public static String date10(@Nullable Date date) {
        return DateFormatter.full19().format(date).substring(0, 10);
    }

    @NotNull
    public static String full(@Nullable Date date) {
        String ft = DateFormatter.full23().format(date);
        if (ft.endsWith(".000")) {
            return ft.substring(0, 19);
        }
        return ft;
    }

    @NotNull
    public static String full19(@Nullable Date date) {
        return DateFormatter.full19().format(date);
    }

    @NotNull
    public static String full23(@Nullable Date date) {
        return DateFormatter.full23().format(date);
    }

    @NotNull
    public static String time(@Nullable Date date) {
        String ft = DateFormatter.full23().format(date);
        if (ft.endsWith(".000")) {
            return ft.substring(11, 19);
        }
        return ft.substring(11);
    }

    @NotNull
    public static String time08(@Nullable Date date) {
        return DateFormatter.full19().format(date).substring(11);
    }

    @NotNull
    public static String time12(@Nullable Date date) {
        return DateFormatter.full23().format(date).substring(11);
    }

    @NotNull
    public static String date10(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.date10(dateTime, null);
    }

    @NotNull
    public static String full(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        if (dateTime.getNano() > 999999) {
            return DateFormatter.full23(dateTime, null);
        }
        return DateFormatter.full19(dateTime, null);
    }

    @NotNull
    public static String full19(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.full19(dateTime, null);
    }

    @NotNull
    public static String full23(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.full23(dateTime, null);
    }

    @NotNull
    public static String time(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.time(dateTime, null);
    }

    @NotNull
    public static String time08(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.time08(dateTime, null);
    }

    @NotNull
    public static String time12(@Nullable Date date, @Nullable ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        ZonedDateTime dateTime = DateFormatter.zoned(date, zoneId);
        return DateFormatter.time12(dateTime, null);
    }

    @NotNull
    public static ZonedDateTime zoned(@NotNull Date date, @Nullable ZoneId zoneId) {
        if (zoneId == null) {
            return date.toInstant().atZone(ThreadNow.sysZoneId());
        }
        return date.toInstant().atZone(zoneId);
    }

    @NotNull
    public static String fixFull19(@Nullable String date) {
        if (date == null) {
            return "1979-01-01";
        }
        int len = date.length();
        StringBuilder tmp = new StringBuilder(len);
        int seed = 0;
        for (int i = 0; i < len; ++i) {
            char c = HalfCharUtil.half(date.charAt(i));
            if (c >= '0' && c <= '9') {
                tmp.append(c);
                seed = 31 * seed + c;
                continue;
            }
            tmp.append(' ');
        }
        StringBuilder buf = new StringBuilder(19);
        int[] idx = new int[]{0, 0};
        DateFormatter.fillDigit(tmp, 4, idx, buf, 1970, '-');
        DateFormatter.fillDigit(tmp, 2, idx, buf, 1, '-');
        DateFormatter.fillDigit(tmp, 2, idx, buf, 1, ' ');
        if (seed < 0) {
            seed >>>= 1;
        }
        int h = seed % 24;
        int m = seed % 60;
        int s = (seed & 0xFF) % 60;
        DateFormatter.fillDigit(tmp, 2, idx, buf, h, ':');
        DateFormatter.fillDigit(tmp, 2, idx, buf, m, ':');
        DateFormatter.fillDigit(tmp, 2, idx, buf, s, '\u0000');
        return buf.toString();
    }

    private static void fillDigit(CharSequence str, int max, int[] idx, StringBuilder buf, int nil, char end) {
        if (idx[1] >= 0) {
            int cnt = 0;
            int off = idx[1];
            idx[1] = -1;
            int len = str.length();
            for (int i = off; i < len; ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9') {
                    if (cnt == 0) {
                        idx[0] = i;
                    }
                    idx[1] = i;
                    ++cnt;
                } else if (cnt > 0) {
                    cnt = max;
                }
                if (cnt >= max) break;
            }
            if (idx[1] > 0) {
                idx[1] = idx[1] + 1;
            }
        }
        int len = idx[1] - idx[0];
        if (idx[1] > 0 && len > 0) {
            for (int i = len; i < max; ++i) {
                buf.append('0');
            }
            buf.append(str, idx[0], idx[1]);
        } else {
            String s = String.valueOf(nil);
            for (int i = s.length(); i < max; ++i) {
                buf.append('0');
            }
            buf.append(s);
        }
        if (end > '\u0000') {
            buf.append(end);
        }
    }

    private static String full19(int y, int m, int d, int h, int i, int s) {
        StringBuilder sb = new StringBuilder(19);
        DateFormatter.fixDate10(sb, y, m, d);
        sb.append(' ');
        DateFormatter.fixTime08(sb, h, i, s);
        return sb.toString();
    }

    private static String full23(int y, int m, int d, int h, int i, int s, int n) {
        StringBuilder sb = new StringBuilder(19);
        DateFormatter.fixDate10(sb, y, m, d);
        sb.append(' ');
        DateFormatter.fixTime08(sb, h, i, s);
        DateFormatter.fixNano(sb, n);
        return sb.toString();
    }

    private static String date10(int y, int m, int d) {
        StringBuilder sb = new StringBuilder(10);
        DateFormatter.fixDate10(sb, y, m, d);
        return sb.toString();
    }

    private static String time08(int h, int m, int s) {
        StringBuilder sb = new StringBuilder(8);
        DateFormatter.fixTime08(sb, h, m, s);
        return sb.toString();
    }

    private static String time12(int h, int m, int s, int n) {
        StringBuilder sb = new StringBuilder(8);
        DateFormatter.fixTime08(sb, h, m, s);
        DateFormatter.fixNano(sb, n);
        return sb.toString();
    }

    private static void fixDate10(StringBuilder buf, int y, int m, int d) {
        buf.append(y).append('-');
        if (m < 10) {
            buf.append('0');
        }
        buf.append(m).append('-');
        if (d < 10) {
            buf.append('0');
        }
        buf.append(d);
    }

    private static void fixTime08(StringBuilder buf, int h, int m, int s) {
        if (h < 10) {
            buf.append('0');
        }
        buf.append(h).append(':');
        if (m < 10) {
            buf.append('0');
        }
        buf.append(m).append(':');
        if (s < 10) {
            buf.append('0');
        }
        buf.append(s);
    }

    private static void fixNano(StringBuilder buf, int n) {
        buf.append('.');
        int s = n / 1000000;
        if (s < 10) {
            buf.append('0');
        }
        if (s < 100) {
            buf.append('0');
        }
        buf.append(s);
    }
}

