/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SlideDate {
    private final Clock clock;
    private final Duration offset;

    private SlideDate(Duration offset) {
        this.offset = offset;
        this.clock = Clock.offset(Clock.systemDefaultZone(), offset);
    }

    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    @NotNull
    public Duration getOffset() {
        return this.offset;
    }

    public long current(TimeUnit unit) {
        long ms = this.clock.millis();
        return unit.convert(ms, TimeUnit.MILLISECONDS);
    }

    public long currentSeconds() {
        return this.clock.millis() / 1000L;
    }

    public long currentMillis() {
        return this.clock.millis();
    }

    @NotNull
    public Date utilDate() {
        return new Date(this.clock.millis());
    }

    @NotNull
    public LocalDate localDate() {
        return LocalDate.now(this.clock);
    }

    @NotNull
    public LocalTime localTime() {
        return LocalTime.now(this.clock);
    }

    @NotNull
    public LocalDateTime localDateTime() {
        return LocalDateTime.now(this.clock);
    }

    @NotNull
    public static SlideDate of(Duration offset) {
        return new SlideDate(offset);
    }
}

