/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class StopWatch {
    private final ConcurrentLinkedQueue<Watch> watches = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, AtomicInteger> threads = new ConcurrentHashMap();

    public Watch start(String name) {
        Watch task = new Watch(name, this);
        this.watches.add(task);
        return task;
    }

    public void clear() {
        this.watches.clear();
        this.threads.clear();
    }

    public boolean isRunning() {
        for (AtomicInteger cnt : this.threads.values()) {
            if (cnt.get() == 0) continue;
            return true;
        }
        return false;
    }

    public ConcurrentLinkedQueue<Watch> getWatches() {
        return this.watches;
    }

    public long totalElapse() {
        long ns = 0L;
        for (Watch task : this.watches) {
            if (task.level != 0) continue;
            ns += task.elapse;
        }
        return ns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        if (this.watches.isEmpty()) {
            sb.append("No task info kept");
        } else {
            int i;
            long total = 0L;
            int maxt = 0;
            for (Watch task : this.watches) {
                int ln;
                if (task.level == 0) {
                    total += task.elapse;
                }
                if ((ln = task.thread.length()) <= maxt) continue;
                maxt = ln;
            }
            if (maxt < 6) {
                maxt = 6;
            }
            sb.append("+--s--ms------ns-+---%-+-");
            for (i = 0; i < maxt; ++i) {
                sb.append('-');
            }
            sb.append("-+---------------\n|");
            if (total == 0L) {
                sb.append(" running...     | --- | thread");
            } else {
                this.format(sb, total, 15).append(" | 100 | thread");
            }
            for (i = 6; i < maxt; ++i) {
                sb.append(' ');
            }
            sb.append(" | task and timing \n");
            for (Watch task : this.watches) {
                sb.append('|');
                this.format(sb, task.elapse, 15).append(" | ");
                if (total == 0L) {
                    sb.append("--- | ");
                } else {
                    this.format(sb, task.elapse * 100L / total, 3).append(" | ");
                }
                this.format(sb, task.thread, maxt).append(" | ");
                for (int i2 = 0; i2 < task.level; ++i2) {
                    sb.append("\u00a6-");
                }
                sb.append(task.name);
                if (task.mark != null) {
                    sb.append(task.mark);
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private StringBuilder format(StringBuilder sb, String str, int len) {
        sb.append(str);
        for (int i = str.length(); i < len; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private StringBuilder format(StringBuilder sb, long num, int len) {
        int i;
        String str = Long.toString(num);
        int ln = str.length();
        int cnt = (ln - 1) / 3 + ln;
        for (i = len - cnt; i > 0; --i) {
            sb.append(' ');
        }
        for (i = 0; i < ln; ++i) {
            if (i > 0 && (ln - i) % 3 == 0) {
                sb.append(',');
            }
            sb.append(str.charAt(i));
        }
        return sb;
    }

    public static final class Watch
    implements AutoCloseable {
        public final String name;
        public final long start;
        public final StopWatch owner;
        public final String thread;
        public final int level;
        private final AtomicInteger count;
        private long elapse = 0L;
        private String mark = null;

        public Watch(String name, StopWatch owner) {
            this.name = name == null ? "" : name;
            this.start = System.nanoTime();
            this.owner = owner;
            this.thread = Thread.currentThread().getName();
            this.count = owner.threads.computeIfAbsent(this.thread, k -> new AtomicInteger(0));
            this.level = this.count.getAndIncrement();
        }

        @Override
        public void close() {
            this.count.decrementAndGet();
            this.elapse = System.nanoTime() - this.start;
        }

        public boolean isRunning() {
            return this.elapse == 0L;
        }

        public String getMark() {
            return this.mark;
        }

        public void setMark(String mark) {
            this.mark = mark;
        }

        public long getElapse() {
            return this.elapse;
        }

        public long getElapseMs() {
            return this.elapse / 1000000L;
        }
    }
}

