/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cond.PredictVal;
import pro.fessional.mirana.i18n.AssertErrorEnum;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.i18n.I18nName;
import pro.fessional.mirana.pain.BadArgsException;
import pro.fessional.mirana.text.FormatUtil;

public class AssertArgs {
    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull String name, @NotNull String msg) {
        if (!b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="false,_,_,_->fail")
    public static void isTrue(boolean b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (!b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull String name, @NotNull CodeEnum code) {
        if (!b) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="false,_,_,_->fail")
    public static void isTrue(boolean b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (!b) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="false,_->fail")
    public static void isTrue(boolean b, @NotNull String name) {
        AssertArgs.isTrue(b, name, (CodeEnum)AssertErrorEnum.AssertTrue1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.is(bs, true), name, msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.is(bs, true), name, msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.is(bs, true), name, code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.is(bs, true), name, code, args);
    }

    @Contract(value="null,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String name) {
        AssertArgs.isTrue(bs, name, (CodeEnum)AssertErrorEnum.AssertTrue1, I18nName.of(name));
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull String name, @NotNull String msg) {
        if (b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="true,_,_,_->fail")
    public static void isFalse(boolean b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull String name, @NotNull CodeEnum code) {
        if (b) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="true,_,_,_->fail")
    public static void isFalse(boolean b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (b) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="true,_->fail")
    public static void isFalse(boolean b, @NotNull String name) {
        AssertArgs.isFalse(b, name, (CodeEnum)AssertErrorEnum.AssertFalse1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.is(bs, false), name, msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.is(bs, false), name, msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.is(bs, false), name, code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.is(bs, false), name, code, args);
    }

    @Contract(value="null,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String name) {
        AssertArgs.isFalse(bs, name, (CodeEnum)AssertErrorEnum.AssertFalse1, I18nName.of(name));
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String name, @NotNull String msg) {
        if (b != null) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="!null,_,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (b != null) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String name, @NotNull CodeEnum code) {
        if (b != null) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="!null,_,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (b != null) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="!null,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String name) {
        AssertArgs.isNull(b, name, AssertErrorEnum.AssertNull1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String name, @NotNull String msg) {
        if (b == null) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (b == null) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String name, @NotNull CodeEnum code) {
        if (b == null) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (b == null) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String name) {
        AssertArgs.notNull(b, name, AssertErrorEnum.AssertNotNull1, I18nName.of(name));
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull String msg) {
        if (c != null && c.length() > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull CodeEnum code) {
        if (c != null && c.length() > 0) {
            throw new BadArgsException(name, code);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String name) {
        AssertArgs.isEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertEmpty1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull String msg) {
        if (c == null || c.length() == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull CodeEnum code) {
        if (c == null || c.length() == 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String name) {
        AssertArgs.notEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertNotEmpty1, I18nName.of(name));
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new BadArgsException(name, code);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String name) {
        AssertArgs.isEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertEmpty1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String name) {
        AssertArgs.notEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertNotEmpty1, I18nName.of(name));
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new BadArgsException(name, code);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String name) {
        AssertArgs.isEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertEmpty1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String name) {
        AssertArgs.notEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertNotEmpty1, I18nName.of(name));
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String name, @NotNull String msg) {
        if (c != null && c.length > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c != null && c.length > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String name, @NotNull CodeEnum code) {
        if (c != null && c.length > 0) {
            throw new BadArgsException(name, code);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length > 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String name) {
        AssertArgs.isEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertEmpty1, I18nName.of(name));
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String name, @NotNull String msg) {
        if (c == null || c.length == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String name, @NotNull String msg, Object ... args) {
        if (c == null || c.length == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String name, @NotNull CodeEnum code) {
        if (c == null || c.length == 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length == 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String name) {
        AssertArgs.notEmpty(c, name, (CodeEnum)AssertErrorEnum.AssertNotEmpty1, I18nName.of(name));
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull String msg) {
        if (a == null || !a.equals(b)) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || !a.equals(b)) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String name) {
        AssertArgs.isEqual(a, b, name, AssertErrorEnum.AssertEqual2, I18nName.of(name), b);
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull String msg) {
        if (a != null && a.equals(b)) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull CodeEnum code) {
        if (a != null && a.equals(b)) {
            throw new BadArgsException(name, code);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String name) {
        AssertArgs.notEqual(a, b, name, AssertErrorEnum.AssertNotEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) != 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) != 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.eqObj(a, b, name, AssertErrorEnum.AssertEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) == 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.neObj(a, b, name, AssertErrorEnum.AssertNotEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) < 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) < 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.geObj(a, b, name, AssertErrorEnum.AssertGreaterEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.gtObj(a, b, name, AssertErrorEnum.AssertGreater2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) > 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.leObj(a, b, name, AssertErrorEnum.AssertLessEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new BadArgsException(name, code);
        }
    }

    @Contract(value="null,_,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new BadArgsException(name, code, args);
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String name) {
        AssertArgs.ltObj(a, b, name, AssertErrorEnum.AssertLess2, I18nName.of(name), b);
    }

    public static void eqVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a != b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void eqVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void eqVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a != b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void eqVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void eqVal(int a, int b, @NotNull String name) {
        AssertArgs.eqVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertEqual2, new Object[]{I18nName.of(name), b});
    }

    public static void eqVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a != b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void eqVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void eqVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a != b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void eqVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void eqVal(long a, long b, @NotNull String name) {
        AssertArgs.eqVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String name) {
        AssertArgs.eqVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertEqual2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.eq(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String name) {
        AssertArgs.eqVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertEqual2, I18nName.of(name), b);
    }

    public static void neVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a == b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void neVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void neVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void neVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void neVal(int a, int b, @NotNull String name) {
        AssertArgs.neVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertNotEqual2, new Object[]{I18nName.of(name), b});
    }

    public static void neVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a == b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void neVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void neVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a == b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void neVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void neVal(long a, long b, @NotNull String name) {
        AssertArgs.neVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertNotEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String name) {
        AssertArgs.neVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertNotEqual2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.ne(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String name) {
        AssertArgs.neVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertNotEqual2, I18nName.of(name), b);
    }

    public static void geVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a < b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void geVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void geVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a < b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void geVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void geVal(int a, int b, @NotNull String name) {
        AssertArgs.geVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertGreaterEqual2, new Object[]{I18nName.of(name), b});
    }

    public static void geVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a < b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void geVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void geVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a < b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void geVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void geVal(long a, long b, @NotNull String name) {
        AssertArgs.geVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertGreaterEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String name) {
        AssertArgs.geVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertGreaterEqual2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.ge(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String name) {
        AssertArgs.geVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertGreaterEqual2, I18nName.of(name), b);
    }

    public static void gtVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a <= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void gtVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void gtVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void gtVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void gtVal(int a, int b, @NotNull String name) {
        AssertArgs.gtVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertGreater2, new Object[]{I18nName.of(name), b});
    }

    public static void gtVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a <= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void gtVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void gtVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void gtVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void gtVal(long a, long b, @NotNull String name) {
        AssertArgs.gtVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertGreater2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String name) {
        AssertArgs.gtVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertGreater2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.gt(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String name) {
        AssertArgs.gtVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertGreater2, I18nName.of(name), b);
    }

    public static void leVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a > b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void leVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void leVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a > b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void leVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void leVal(int a, int b, @NotNull String name) {
        AssertArgs.leVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertLessEqual2, new Object[]{I18nName.of(name), b});
    }

    public static void leVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a > b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void leVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void leVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a > b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void leVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void leVal(long a, long b, @NotNull String name) {
        AssertArgs.leVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertLessEqual2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String name) {
        AssertArgs.leVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertLessEqual2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.le(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String name) {
        AssertArgs.leVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertLessEqual2, I18nName.of(name), b);
    }

    public static void ltVal(int a, int b, @NotNull String name, @NotNull String msg) {
        if (a >= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void ltVal(int a, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void ltVal(int a, int b, @NotNull String name, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void ltVal(int a, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void ltVal(int a, int b, @NotNull String name) {
        AssertArgs.ltVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertLess2, new Object[]{I18nName.of(name), b});
    }

    public static void ltVal(long a, long b, @NotNull String name, @NotNull String msg) {
        if (a >= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, msg));
        }
    }

    public static void ltVal(long a, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new IllegalArgumentException(FormatUtil.named(name, FormatUtil.logback(msg, args)));
        }
    }

    public static void ltVal(long a, long b, @NotNull String name, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new BadArgsException(name, code);
        }
    }

    public static void ltVal(long a, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new BadArgsException(name, code, args);
        }
    }

    public static void ltVal(long a, long b, @NotNull String name) {
        AssertArgs.ltVal(a, b, name, (CodeEnum)AssertErrorEnum.AssertLess2, I18nName.of(name), b);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String name) {
        AssertArgs.ltVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertLess2, new Object[]{I18nName.of(name), b});
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String name, @NotNull String msg) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, msg);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String name, @NotNull String msg, Object ... args) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, msg, args);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, code);
    }

    @Contract(value="null,_,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String name, @NotNull CodeEnum code, Object ... args) {
        AssertArgs.isTrue(PredictVal.lt(as, b), name, code, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String name) {
        AssertArgs.ltVal(as, b, name, (CodeEnum)AssertErrorEnum.AssertLess2, I18nName.of(name), b);
    }
}

