/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cond.PredictVal;
import pro.fessional.mirana.i18n.AssertErrorEnum;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.pain.MessageException;
import pro.fessional.mirana.text.FormatUtil;

public class AssertMessage {
    @Contract(value="false,_->fail")
    public static void isTrue(boolean b, @NotNull String msg) {
        if (!b) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull String msg, Object ... args) {
        if (!b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="false,_->fail")
    public static void isTrue(boolean b, @NotNull CodeEnum code) {
        if (!b) {
            throw new MessageException(code);
        }
    }

    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (!b) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="false->fail")
    public static void isTrue(boolean b) {
        AssertMessage.isTrue(b, (CodeEnum)AssertErrorEnum.AssertTrue);
    }

    @Contract(value="null,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.is(bs, true), msg);
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.is(bs, true), msg, args);
    }

    @Contract(value="null,_->fail")
    public static void isTrue(boolean[] bs, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.is(bs, true), code);
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.is(bs, true), code, args);
    }

    @Contract(value="null->fail")
    public static void isTrue(boolean[] bs) {
        AssertMessage.isTrue(bs, (CodeEnum)AssertErrorEnum.AssertTrue);
    }

    @Contract(value="true,_->fail")
    public static void isFalse(boolean b, @NotNull String msg) {
        if (b) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull String msg, Object ... args) {
        if (b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="true,_->fail")
    public static void isFalse(boolean b, @NotNull CodeEnum code) {
        if (b) {
            throw new MessageException(code);
        }
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (b) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="true->fail")
    public static void isFalse(boolean b) {
        AssertMessage.isFalse(b, (CodeEnum)AssertErrorEnum.AssertFalse);
    }

    @Contract(value="null,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.is(bs, false), msg);
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.is(bs, false), msg, args);
    }

    @Contract(value="null,_->fail")
    public static void isFalse(boolean[] bs, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.is(bs, false), code);
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.is(bs, false), code, args);
    }

    @Contract(value="null->fail")
    public static void isFalse(boolean[] bs) {
        AssertMessage.isFalse(bs, (CodeEnum)AssertErrorEnum.AssertFalse);
    }

    @Contract(value="!null,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String msg) {
        if (b != null) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String msg, Object ... args) {
        if (b != null) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="!null,_->fail")
    public static void isNull(@Nullable Object b, @NotNull CodeEnum code) {
        if (b != null) {
            throw new MessageException(code);
        }
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull CodeEnum code, Object ... args) {
        if (b != null) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="!null->fail")
    public static void isNull(@Nullable Object b) {
        AssertMessage.isNull(b, AssertErrorEnum.AssertNull);
    }

    @Contract(value="null,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String msg) {
        if (b == null) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String msg, Object ... args) {
        if (b == null) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notNull(@Nullable Object b, @NotNull CodeEnum code) {
        if (b == null) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull CodeEnum code, Object ... args) {
        if (b == null) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notNull(@Nullable Object b) {
        AssertMessage.notNull(b, AssertErrorEnum.AssertNotNull);
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String msg) {
        if (c != null && c.length() > 0) {
            throw new MessageException(msg);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String msg, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull CodeEnum code) {
        if (c != null && c.length() > 0) {
            throw new MessageException(code);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new MessageException(code, args);
        }
    }

    public static void isEmpty(@Nullable CharSequence c) {
        AssertMessage.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String msg) {
        if (c == null || c.length() == 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String msg, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull CodeEnum code) {
        if (c == null || c.length() == 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable CharSequence c) {
        AssertMessage.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(msg);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(code);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(code, args);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c) {
        AssertMessage.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Collection<?> c) {
        AssertMessage.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(msg);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(code);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new MessageException(code, args);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c) {
        AssertMessage.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Map<?, ?> c) {
        AssertMessage.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String msg) {
        if (c != null && c.length > 0) {
            throw new MessageException(msg);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String msg, Object ... args) {
        if (c != null && c.length > 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull CodeEnum code) {
        if (c != null && c.length > 0) {
            throw new MessageException(code);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length > 0) {
            throw new MessageException(code, args);
        }
    }

    public static void isEmpty(@Nullable Object[] c) {
        AssertMessage.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String msg) {
        if (c == null || c.length == 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String msg, Object ... args) {
        if (c == null || c.length == 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull CodeEnum code) {
        if (c == null || c.length == 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length == 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Object[] c) {
        AssertMessage.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    @Contract(value="null,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg) {
        if (a == null || !a.equals(b)) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code) {
        if (a == null || !a.equals(b)) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b) {
        AssertMessage.isEqual(a, b, AssertErrorEnum.AssertEqual1, b);
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg) {
        if (a != null && a.equals(b)) {
            throw new MessageException(msg);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code) {
        if (a != null && a.equals(b)) {
            throw new MessageException(code);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new MessageException(code, args);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b) {
        AssertMessage.notEqual(a, b, AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) != 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) != 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b) {
        AssertMessage.eqObj(a, b, AssertErrorEnum.AssertEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) == 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) == 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b) {
        AssertMessage.neObj(a, b, AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) < 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) < 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b) {
        AssertMessage.geObj(a, b, AssertErrorEnum.AssertGreaterEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b) {
        AssertMessage.gtObj(a, b, AssertErrorEnum.AssertGreater1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) > 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) > 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b) {
        AssertMessage.leObj(a, b, AssertErrorEnum.AssertLessEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new MessageException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new MessageException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new MessageException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b) {
        AssertMessage.ltObj(a, b, AssertErrorEnum.AssertLess1, b);
    }

    public static void eqVal(int a, int b, @NotNull String msg) {
        if (a != b) {
            throw new MessageException(msg);
        }
    }

    public static void eqVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void eqVal(int a, int b, @NotNull CodeEnum code) {
        if (a != b) {
            throw new MessageException(code);
        }
    }

    public static void eqVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new MessageException(code, args);
        }
    }

    public static void eqVal(int a, int b) {
        AssertMessage.eqVal(a, b, (CodeEnum)AssertErrorEnum.AssertEqual1, new Object[]{b});
    }

    public static void eqVal(long a, long b, @NotNull String msg) {
        if (a != b) {
            throw new MessageException(msg);
        }
    }

    public static void eqVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void eqVal(long a, long b, @NotNull CodeEnum code) {
        if (a != b) {
            throw new MessageException(code);
        }
    }

    public static void eqVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new MessageException(code, args);
        }
    }

    public static void eqVal(long a, long b) {
        AssertMessage.eqVal(a, b, (CodeEnum)AssertErrorEnum.AssertEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.eq(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.eq(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.eq(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.eq(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void eqVal(int[] as, int b) {
        AssertMessage.eqVal(as, b, (CodeEnum)AssertErrorEnum.AssertEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.eq(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.eq(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.eq(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.eq(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void eqVal(long[] as, long b) {
        AssertMessage.eqVal(as, b, (CodeEnum)AssertErrorEnum.AssertEqual1, b);
    }

    public static void neVal(int a, int b, @NotNull String msg) {
        if (a == b) {
            throw new MessageException(msg);
        }
    }

    public static void neVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void neVal(int a, int b, @NotNull CodeEnum code) {
        if (a == b) {
            throw new MessageException(code);
        }
    }

    public static void neVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new MessageException(code, args);
        }
    }

    public static void neVal(int a, int b) {
        AssertMessage.neVal(a, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, new Object[]{b});
    }

    public static void neVal(long a, long b, @NotNull String msg) {
        if (a == b) {
            throw new MessageException(msg);
        }
    }

    public static void neVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void neVal(long a, long b, @NotNull CodeEnum code) {
        if (a == b) {
            throw new MessageException(code);
        }
    }

    public static void neVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new MessageException(code, args);
        }
    }

    public static void neVal(long a, long b) {
        AssertMessage.neVal(a, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.ne(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.ne(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.ne(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.ne(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void neVal(int[] as, int b) {
        AssertMessage.neVal(as, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.ne(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.ne(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.ne(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.ne(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void neVal(long[] as, long b) {
        AssertMessage.neVal(as, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, b);
    }

    public static void geVal(int a, int b, @NotNull String msg) {
        if (a < b) {
            throw new MessageException(msg);
        }
    }

    public static void geVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void geVal(int a, int b, @NotNull CodeEnum code) {
        if (a < b) {
            throw new MessageException(code);
        }
    }

    public static void geVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new MessageException(code, args);
        }
    }

    public static void geVal(int a, int b) {
        AssertMessage.geVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, new Object[]{b});
    }

    public static void geVal(long a, long b, @NotNull String msg) {
        if (a < b) {
            throw new MessageException(msg);
        }
    }

    public static void geVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void geVal(long a, long b, @NotNull CodeEnum code) {
        if (a < b) {
            throw new MessageException(code);
        }
    }

    public static void geVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new MessageException(code, args);
        }
    }

    public static void geVal(long a, long b) {
        AssertMessage.geVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.ge(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.ge(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.ge(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.ge(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void geVal(int[] as, int b) {
        AssertMessage.geVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.ge(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.ge(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.ge(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.ge(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void geVal(long[] as, long b) {
        AssertMessage.geVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, b);
    }

    public static void gtVal(int a, int b, @NotNull String msg) {
        if (a <= b) {
            throw new MessageException(msg);
        }
    }

    public static void gtVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void gtVal(int a, int b, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new MessageException(code);
        }
    }

    public static void gtVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new MessageException(code, args);
        }
    }

    public static void gtVal(int a, int b) {
        AssertMessage.gtVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreater1, new Object[]{b});
    }

    public static void gtVal(long a, long b, @NotNull String msg) {
        if (a <= b) {
            throw new MessageException(msg);
        }
    }

    public static void gtVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void gtVal(long a, long b, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new MessageException(code);
        }
    }

    public static void gtVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new MessageException(code, args);
        }
    }

    public static void gtVal(long a, long b) {
        AssertMessage.gtVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreater1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.gt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.gt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.gt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.gt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void gtVal(int[] as, int b) {
        AssertMessage.gtVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreater1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.gt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.gt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.gt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.gt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void gtVal(long[] as, long b) {
        AssertMessage.gtVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreater1, b);
    }

    public static void leVal(int a, int b, @NotNull String msg) {
        if (a > b) {
            throw new MessageException(msg);
        }
    }

    public static void leVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void leVal(int a, int b, @NotNull CodeEnum code) {
        if (a > b) {
            throw new MessageException(code);
        }
    }

    public static void leVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new MessageException(code, args);
        }
    }

    public static void leVal(int a, int b) {
        AssertMessage.leVal(a, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, new Object[]{b});
    }

    public static void leVal(long a, long b, @NotNull String msg) {
        if (a > b) {
            throw new MessageException(msg);
        }
    }

    public static void leVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void leVal(long a, long b, @NotNull CodeEnum code) {
        if (a > b) {
            throw new MessageException(code);
        }
    }

    public static void leVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new MessageException(code, args);
        }
    }

    public static void leVal(long a, long b) {
        AssertMessage.leVal(a, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.le(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.le(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.le(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.le(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void leVal(int[] as, int b) {
        AssertMessage.leVal(as, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.le(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.le(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.le(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.le(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void leVal(long[] as, long b) {
        AssertMessage.leVal(as, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, b);
    }

    public static void ltVal(int a, int b, @NotNull String msg) {
        if (a >= b) {
            throw new MessageException(msg);
        }
    }

    public static void ltVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void ltVal(int a, int b, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new MessageException(code);
        }
    }

    public static void ltVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new MessageException(code, args);
        }
    }

    public static void ltVal(int a, int b) {
        AssertMessage.ltVal(a, b, (CodeEnum)AssertErrorEnum.AssertLess1, new Object[]{b});
    }

    public static void ltVal(long a, long b, @NotNull String msg) {
        if (a >= b) {
            throw new MessageException(msg);
        }
    }

    public static void ltVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new MessageException(FormatUtil.logback(msg, args));
        }
    }

    public static void ltVal(long a, long b, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new MessageException(code);
        }
    }

    public static void ltVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new MessageException(code, args);
        }
    }

    public static void ltVal(long a, long b) {
        AssertMessage.ltVal(a, b, (CodeEnum)AssertErrorEnum.AssertLess1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.lt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.lt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.lt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.lt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void ltVal(int[] as, int b) {
        AssertMessage.ltVal(as, b, (CodeEnum)AssertErrorEnum.AssertLess1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String msg) {
        AssertMessage.isTrue(PredictVal.lt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertMessage.isTrue(PredictVal.lt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertMessage.isTrue(PredictVal.lt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertMessage.isTrue(PredictVal.lt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void ltVal(long[] as, long b) {
        AssertMessage.ltVal(as, b, (CodeEnum)AssertErrorEnum.AssertLess1, b);
    }
}

