/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cond.PredictVal;
import pro.fessional.mirana.i18n.AssertErrorEnum;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.pain.BadStateException;
import pro.fessional.mirana.text.FormatUtil;

public class AssertState {
    @Contract(value="false,_->fail")
    public static void isTrue(boolean b, @NotNull String msg) {
        if (!b) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull String msg, Object ... args) {
        if (!b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="false,_->fail")
    public static void isTrue(boolean b, @NotNull CodeEnum code) {
        if (!b) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="false,_,_->fail")
    public static void isTrue(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (!b) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="false->fail")
    public static void isTrue(boolean b) {
        AssertState.isTrue(b, (CodeEnum)AssertErrorEnum.AssertTrue);
    }

    @Contract(value="null,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String msg) {
        AssertState.isTrue(PredictVal.is(bs, true), msg);
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.is(bs, true), msg, args);
    }

    @Contract(value="null,_->fail")
    public static void isTrue(boolean[] bs, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.is(bs, true), code);
    }

    @Contract(value="null,_,_->fail")
    public static void isTrue(boolean[] bs, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.is(bs, true), code, args);
    }

    @Contract(value="null->fail")
    public static void isTrue(boolean[] bs) {
        AssertState.isTrue(bs, (CodeEnum)AssertErrorEnum.AssertTrue);
    }

    @Contract(value="true,_->fail")
    public static void isFalse(boolean b, @NotNull String msg) {
        if (b) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull String msg, Object ... args) {
        if (b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="true,_->fail")
    public static void isFalse(boolean b, @NotNull CodeEnum code) {
        if (b) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="true,_,_->fail")
    public static void isFalse(boolean b, @NotNull CodeEnum code, Object ... args) {
        if (b) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="true->fail")
    public static void isFalse(boolean b) {
        AssertState.isFalse(b, (CodeEnum)AssertErrorEnum.AssertFalse);
    }

    @Contract(value="null,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String msg) {
        AssertState.isTrue(PredictVal.is(bs, false), msg);
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.is(bs, false), msg, args);
    }

    @Contract(value="null,_->fail")
    public static void isFalse(boolean[] bs, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.is(bs, false), code);
    }

    @Contract(value="null,_,_->fail")
    public static void isFalse(boolean[] bs, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.is(bs, false), code, args);
    }

    @Contract(value="null->fail")
    public static void isFalse(boolean[] bs) {
        AssertState.isFalse(bs, (CodeEnum)AssertErrorEnum.AssertFalse);
    }

    @Contract(value="!null,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String msg) {
        if (b != null) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull String msg, Object ... args) {
        if (b != null) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="!null,_->fail")
    public static void isNull(@Nullable Object b, @NotNull CodeEnum code) {
        if (b != null) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="!null,_,_->fail")
    public static void isNull(@Nullable Object b, @NotNull CodeEnum code, Object ... args) {
        if (b != null) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="!null->fail")
    public static void isNull(@Nullable Object b) {
        AssertState.isNull(b, AssertErrorEnum.AssertNull);
    }

    @Contract(value="null,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String msg) {
        if (b == null) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull String msg, Object ... args) {
        if (b == null) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notNull(@Nullable Object b, @NotNull CodeEnum code) {
        if (b == null) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notNull(@Nullable Object b, @NotNull CodeEnum code, Object ... args) {
        if (b == null) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notNull(@Nullable Object b) {
        AssertState.notNull(b, AssertErrorEnum.AssertNotNull);
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String msg) {
        if (c != null && c.length() > 0) {
            throw new IllegalStateException(msg);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull String msg, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull CodeEnum code) {
        if (c != null && c.length() > 0) {
            throw new BadStateException(code);
        }
    }

    public static void isEmpty(@Nullable CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length() > 0) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(@Nullable CharSequence c) {
        AssertState.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String msg) {
        if (c == null || c.length() == 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull String msg, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull CodeEnum code) {
        if (c == null || c.length() == 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable CharSequence c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length() == 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable CharSequence c) {
        AssertState.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(msg);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(@Nullable Collection<?> c) {
        AssertState.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Collection<?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Collection<?> c) {
        AssertState.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String msg) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(msg);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && !c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(@Nullable Map<?, ?> c) {
        AssertState.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String msg) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull String msg, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Map<?, ?> c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.isEmpty()) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Map<?, ?> c) {
        AssertState.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String msg) {
        if (c != null && c.length > 0) {
            throw new IllegalStateException(msg);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull String msg, Object ... args) {
        if (c != null && c.length > 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull CodeEnum code) {
        if (c != null && c.length > 0) {
            throw new BadStateException(code);
        }
    }

    public static void isEmpty(@Nullable Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c != null && c.length > 0) {
            throw new BadStateException(code, args);
        }
    }

    public static void isEmpty(@Nullable Object[] c) {
        AssertState.isEmpty(c, (CodeEnum)AssertErrorEnum.AssertEmpty);
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String msg) {
        if (c == null || c.length == 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull String msg, Object ... args) {
        if (c == null || c.length == 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull CodeEnum code) {
        if (c == null || c.length == 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_->fail")
    public static void notEmpty(@Nullable Object[] c, @NotNull CodeEnum code, Object ... args) {
        if (c == null || c.length == 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null->fail")
    public static void notEmpty(@Nullable Object[] c) {
        AssertState.notEmpty(c, (CodeEnum)AssertErrorEnum.AssertNotEmpty);
    }

    @Contract(value="null,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg) {
        if (a == null || !a.equals(b)) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code) {
        if (a == null || !a.equals(b)) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || !a.equals(b)) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static void isEqual(@Nullable Object a, @NotNull Object b) {
        AssertState.isEqual(a, b, AssertErrorEnum.AssertEqual1, b);
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg) {
        if (a != null && a.equals(b)) {
            throw new IllegalStateException(msg);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull String msg, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code) {
        if (a != null && a.equals(b)) {
            throw new BadStateException(code);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b, @NotNull CodeEnum code, Object ... args) {
        if (a != null && a.equals(b)) {
            throw new BadStateException(code, args);
        }
    }

    public static void notEqual(@Nullable Object a, @NotNull Object b) {
        AssertState.notEqual(a, b, AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) != 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) != 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) != 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void eqObj(@Nullable T a, @NotNull T b) {
        AssertState.eqObj(a, b, AssertErrorEnum.AssertEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) == 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) == 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) == 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void neObj(@Nullable T a, @NotNull T b) {
        AssertState.neObj(a, b, AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) < 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) < 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) < 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void geObj(@Nullable T a, @NotNull T b) {
        AssertState.geObj(a, b, AssertErrorEnum.AssertGreaterEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) <= 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void gtObj(@Nullable T a, @NotNull T b) {
        AssertState.gtObj(a, b, AssertErrorEnum.AssertGreater1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) > 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) > 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) > 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void leObj(@Nullable T a, @NotNull T b) {
        AssertState.leObj(a, b, AssertErrorEnum.AssertLessEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String msg) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new IllegalStateException(msg);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull String msg, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    @Contract(value="null,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new BadStateException(code);
        }
    }

    @Contract(value="null,_,_,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b, @NotNull CodeEnum code, Object ... args) {
        if (a == null || a.compareTo(b) >= 0) {
            throw new BadStateException(code, args);
        }
    }

    @Contract(value="null,_->fail")
    public static <T extends Comparable<T>> void ltObj(@Nullable T a, @NotNull T b) {
        AssertState.ltObj(a, b, AssertErrorEnum.AssertLess1, b);
    }

    public static void eqVal(int a, int b, @NotNull String msg) {
        if (a != b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void eqVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void eqVal(int a, int b, @NotNull CodeEnum code) {
        if (a != b) {
            throw new BadStateException(code);
        }
    }

    public static void eqVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new BadStateException(code, args);
        }
    }

    public static void eqVal(int a, int b) {
        AssertState.eqVal(a, b, (CodeEnum)AssertErrorEnum.AssertEqual1, new Object[]{b});
    }

    public static void eqVal(long a, long b, @NotNull String msg) {
        if (a != b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void eqVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a != b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void eqVal(long a, long b, @NotNull CodeEnum code) {
        if (a != b) {
            throw new BadStateException(code);
        }
    }

    public static void eqVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a != b) {
            throw new BadStateException(code, args);
        }
    }

    public static void eqVal(long a, long b) {
        AssertState.eqVal(a, b, (CodeEnum)AssertErrorEnum.AssertEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.eq(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.eq(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.eq(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.eq(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void eqVal(int[] as, int b) {
        AssertState.eqVal(as, b, (CodeEnum)AssertErrorEnum.AssertEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.eq(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.eq(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.eq(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void eqVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.eq(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void eqVal(long[] as, long b) {
        AssertState.eqVal(as, b, (CodeEnum)AssertErrorEnum.AssertEqual1, b);
    }

    public static void neVal(int a, int b, @NotNull String msg) {
        if (a == b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void neVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void neVal(int a, int b, @NotNull CodeEnum code) {
        if (a == b) {
            throw new BadStateException(code);
        }
    }

    public static void neVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new BadStateException(code, args);
        }
    }

    public static void neVal(int a, int b) {
        AssertState.neVal(a, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, new Object[]{b});
    }

    public static void neVal(long a, long b, @NotNull String msg) {
        if (a == b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void neVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a == b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void neVal(long a, long b, @NotNull CodeEnum code) {
        if (a == b) {
            throw new BadStateException(code);
        }
    }

    public static void neVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a == b) {
            throw new BadStateException(code, args);
        }
    }

    public static void neVal(long a, long b) {
        AssertState.neVal(a, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.ne(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.ne(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.ne(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.ne(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void neVal(int[] as, int b) {
        AssertState.neVal(as, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.ne(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.ne(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.ne(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void neVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.ne(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void neVal(long[] as, long b) {
        AssertState.neVal(as, b, (CodeEnum)AssertErrorEnum.AssertNotEqual1, b);
    }

    public static void geVal(int a, int b, @NotNull String msg) {
        if (a < b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void geVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void geVal(int a, int b, @NotNull CodeEnum code) {
        if (a < b) {
            throw new BadStateException(code);
        }
    }

    public static void geVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new BadStateException(code, args);
        }
    }

    public static void geVal(int a, int b) {
        AssertState.geVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, new Object[]{b});
    }

    public static void geVal(long a, long b, @NotNull String msg) {
        if (a < b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void geVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a < b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void geVal(long a, long b, @NotNull CodeEnum code) {
        if (a < b) {
            throw new BadStateException(code);
        }
    }

    public static void geVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a < b) {
            throw new BadStateException(code, args);
        }
    }

    public static void geVal(long a, long b) {
        AssertState.geVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.ge(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.ge(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.ge(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.ge(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void geVal(int[] as, int b) {
        AssertState.geVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.ge(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.ge(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.ge(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void geVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.ge(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void geVal(long[] as, long b) {
        AssertState.geVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreaterEqual1, b);
    }

    public static void gtVal(int a, int b, @NotNull String msg) {
        if (a <= b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void gtVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void gtVal(int a, int b, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new BadStateException(code);
        }
    }

    public static void gtVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new BadStateException(code, args);
        }
    }

    public static void gtVal(int a, int b) {
        AssertState.gtVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreater1, new Object[]{b});
    }

    public static void gtVal(long a, long b, @NotNull String msg) {
        if (a <= b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void gtVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a <= b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void gtVal(long a, long b, @NotNull CodeEnum code) {
        if (a <= b) {
            throw new BadStateException(code);
        }
    }

    public static void gtVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a <= b) {
            throw new BadStateException(code, args);
        }
    }

    public static void gtVal(long a, long b) {
        AssertState.gtVal(a, b, (CodeEnum)AssertErrorEnum.AssertGreater1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.gt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.gt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.gt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.gt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void gtVal(int[] as, int b) {
        AssertState.gtVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreater1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.gt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.gt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.gt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void gtVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.gt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void gtVal(long[] as, long b) {
        AssertState.gtVal(as, b, (CodeEnum)AssertErrorEnum.AssertGreater1, b);
    }

    public static void leVal(int a, int b, @NotNull String msg) {
        if (a > b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void leVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void leVal(int a, int b, @NotNull CodeEnum code) {
        if (a > b) {
            throw new BadStateException(code);
        }
    }

    public static void leVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new BadStateException(code, args);
        }
    }

    public static void leVal(int a, int b) {
        AssertState.leVal(a, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, new Object[]{b});
    }

    public static void leVal(long a, long b, @NotNull String msg) {
        if (a > b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void leVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a > b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void leVal(long a, long b, @NotNull CodeEnum code) {
        if (a > b) {
            throw new BadStateException(code);
        }
    }

    public static void leVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a > b) {
            throw new BadStateException(code, args);
        }
    }

    public static void leVal(long a, long b) {
        AssertState.leVal(a, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.le(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.le(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.le(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.le(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void leVal(int[] as, int b) {
        AssertState.leVal(as, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.le(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.le(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.le(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void leVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.le(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void leVal(long[] as, long b) {
        AssertState.leVal(as, b, (CodeEnum)AssertErrorEnum.AssertLessEqual1, b);
    }

    public static void ltVal(int a, int b, @NotNull String msg) {
        if (a >= b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void ltVal(int a, int b, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void ltVal(int a, int b, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new BadStateException(code);
        }
    }

    public static void ltVal(int a, int b, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new BadStateException(code, args);
        }
    }

    public static void ltVal(int a, int b) {
        AssertState.ltVal(a, b, (CodeEnum)AssertErrorEnum.AssertLess1, new Object[]{b});
    }

    public static void ltVal(long a, long b, @NotNull String msg) {
        if (a >= b) {
            throw new IllegalStateException(msg);
        }
    }

    public static void ltVal(long a, long b, @NotNull String msg, Object ... args) {
        if (a >= b) {
            throw new IllegalStateException(FormatUtil.logback(msg, args));
        }
    }

    public static void ltVal(long a, long b, @NotNull CodeEnum code) {
        if (a >= b) {
            throw new BadStateException(code);
        }
    }

    public static void ltVal(long a, long b, @NotNull CodeEnum code, Object ... args) {
        if (a >= b) {
            throw new BadStateException(code, args);
        }
    }

    public static void ltVal(long a, long b) {
        AssertState.ltVal(a, b, (CodeEnum)AssertErrorEnum.AssertLess1, b);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.lt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.lt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.lt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(int[] as, int b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.lt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void ltVal(int[] as, int b) {
        AssertState.ltVal(as, b, (CodeEnum)AssertErrorEnum.AssertLess1, new Object[]{b});
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String msg) {
        AssertState.isTrue(PredictVal.lt(as, b), msg);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull String msg, Object ... args) {
        AssertState.isTrue(PredictVal.lt(as, b), msg, args);
    }

    @Contract(value="null,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull CodeEnum code) {
        AssertState.isTrue(PredictVal.lt(as, b), code);
    }

    @Contract(value="null,_,_,_->fail")
    public static void ltVal(long[] as, long b, @NotNull CodeEnum code, Object ... args) {
        AssertState.isTrue(PredictVal.lt(as, b), code, args);
    }

    @Contract(value="null,_->fail")
    public static void ltVal(long[] as, long b) {
        AssertState.ltVal(as, b, (CodeEnum)AssertErrorEnum.AssertLess1, b);
    }
}

