/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.best.TypedReg;

public abstract class TypedKey<V> {
    private static final Map<String, TypedKey<?>> INSTANCE = new HashMap();
    @NotNull
    public final Class<? extends TypedKey<V>> regType;
    @NotNull
    public final Type valType;

    protected TypedKey() {
        Class<?> clz = this.getClass();
        Type[] tps = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        this.regType = clz;
        this.valType = tps[0];
        INSTANCE.put(clz.getName(), this);
    }

    public void set(@NotNull BiConsumer<TypedKey<V>, V> fun, V value) {
        fun.accept(this, value);
    }

    public void set(@NotNull Map<TypedKey<V>, ? super V> map, V value) {
        map.put(this, value);
    }

    @Contract(value="_,true->!null")
    public V get(@NotNull Function<TypedKey<V>, V> fun, boolean nonnull) {
        V obj = fun.apply(this);
        if (obj == null && nonnull) {
            throw new NullPointerException("cannot be null, regType=" + this.regType);
        }
        return obj;
    }

    @Contract(value="_,true->!null")
    public V get(@NotNull Map<TypedKey<V>, ? extends V> map, boolean nonnull) {
        V obj = map.get(this);
        if (obj == null && nonnull) {
            throw new NullPointerException("cannot be null, regType=" + this.regType);
        }
        return obj;
    }

    @Contract(value="_,!null ->!null")
    public V getOr(@NotNull Function<TypedKey<V>, V> fun, V elze) {
        V obj = fun.apply(this);
        return obj != null ? obj : elze;
    }

    @Contract(value="_,!null ->!null")
    public V getOr(@NotNull Map<TypedKey<V>, ? extends V> map, V elze) {
        V obj = map.get(this);
        return obj != null ? obj : elze;
    }

    @Contract(value="_,!null ->!null")
    public V tryOr(@NotNull Function<TypedKey<V>, ?> fun, V elze) throws ClassCastException {
        Object obj = fun.apply(this);
        return (V)(obj != null ? obj : elze);
    }

    @Contract(value="_,!null ->!null")
    public V tryOr(@NotNull Map<?, ?> map, V elze) throws ClassCastException {
        Object obj = map.get(this);
        return (V)(obj != null ? obj : elze);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedReg)) {
            return false;
        }
        TypedReg reg = (TypedReg)o;
        return Objects.equals(this.regType, reg.regType);
    }

    public int hashCode() {
        return Objects.hash(this.regType);
    }

    public String toString() {
        return "TypedKey{regType=" + this.regType + ", valType=" + this.valType + '}';
    }

    @NotNull
    public String serialize() {
        return this.regType.getName();
    }

    @NotNull
    public static <K> TypedKey<K> deserialize(@NotNull String clz) {
        return TypedKey.deserialize(clz, true);
    }

    @Contract(value="_,true->!null")
    public static <K> TypedKey<K> deserialize(@NotNull String clz, boolean nonnull) {
        TypedKey<?> ins = INSTANCE.get(clz);
        if (ins == null && nonnull) {
            throw new NullPointerException("instance not found, class=" + clz);
        }
        return ins;
    }
}

