/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TypedRef<V, R> {
    @NotNull
    public final V value;

    public TypedRef(@NotNull V value) {
        this.value = value;
    }

    public void set(@NotNull BiConsumer<V, R> fun, R refer) {
        fun.accept(this.value, refer);
    }

    public void set(@NotNull Map<V, ? super R> map, R refer) {
        map.put(this.value, refer);
    }

    @Contract(value="_,true->!null")
    public R get(@NotNull Function<V, R> fun, boolean nonnull) {
        R obj = fun.apply(this.value);
        if (obj == null && nonnull) {
            throw new NullPointerException("cannot be null, value=" + this.value);
        }
        return obj;
    }

    @Contract(value="_,true->!null")
    public R get(@NotNull Map<V, ? extends R> map, boolean nonnull) {
        R obj = map.get(this.value);
        if (obj == null && nonnull) {
            throw new NullPointerException("cannot be null, value=" + this.value);
        }
        return obj;
    }

    @Contract(value="_,!null ->!null")
    public R getOr(@NotNull Function<V, R> fun, R elze) {
        R obj = fun.apply(this.value);
        return obj != null ? obj : elze;
    }

    @Contract(value="_,!null ->!null")
    public R getOr(@NotNull Map<V, ? extends R> map, R elze) {
        R obj = map.get(this.value);
        return obj != null ? obj : elze;
    }

    @Contract(value="_,!null ->!null")
    public R tryOr(@NotNull Function<V, ?> fun, R elze) throws ClassCastException {
        Object obj = fun.apply(this.value);
        return (R)(obj != null ? obj : elze);
    }

    @Contract(value="_,!null ->!null")
    public R tryOr(@NotNull Map<?, ?> map, R elze) throws ClassCastException {
        Object obj = map.get(this.value);
        return (R)(obj != null ? obj : elze);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedRef typedRef = (TypedRef)o;
        return Objects.equals(this.value, typedRef.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

