/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.best;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedReg<K, V> {
    private static final Map<String, TypedReg<?, ?>> INSTANCE = new HashMap();
    @NotNull
    public final Class<? extends TypedReg<K, V>> regType;
    @NotNull
    public final Type keyType;
    @NotNull
    public final Type valType;

    protected TypedReg() {
        Class<?> clz = this.getClass();
        Type[] tps = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        this.regType = clz;
        this.keyType = tps[0];
        this.valType = tps[1];
        INSTANCE.put(clz.getName(), this);
    }

    public Key<K, V> key(K key) {
        return new Key(this, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedReg)) {
            return false;
        }
        TypedReg reg = (TypedReg)o;
        return Objects.equals(this.regType, reg.regType);
    }

    public int hashCode() {
        return Objects.hash(this.regType);
    }

    public String toString() {
        return "TypedReg{regType=" + this.regType + ", keyType=" + this.keyType + ", valType=" + this.valType + '}';
    }

    @NotNull
    public String serialize() {
        return this.regType.getName();
    }

    @NotNull
    public static <K, V> TypedReg<K, V> deserialize(@NotNull String clz) {
        return TypedReg.deserialize(clz, true);
    }

    @Contract(value="_,true->!null")
    public static <K, V> TypedReg<K, V> deserialize(@NotNull String clz, boolean nonnull) {
        TypedReg<?, ?> ins = INSTANCE.get(clz);
        if (ins == null && nonnull) {
            throw new NullPointerException("instance not found, class=" + clz);
        }
        return ins;
    }

    public static class Key<K, V> {
        @NotNull
        public final TypedReg<K, V> reg;
        public final K key;

        public Key(@NotNull TypedReg<K, V> reg, K key) {
            this.reg = reg;
            this.key = key;
        }

        public void set(@NotNull BiConsumer<Key<K, V>, V> fun, V value) {
            fun.accept(this, value);
        }

        public void set(@NotNull Map<Key<K, V>, ? super V> map, V value) {
            map.put(this, value);
        }

        @Nullable
        public V get(@NotNull Function<Key<K, V>, V> fun, boolean nonnull) {
            V obj = fun.apply(this);
            if (obj == null && nonnull) {
                throw new NullPointerException("cannot be null, key=" + this.key + ", reg=" + this.reg);
            }
            return obj;
        }

        @Nullable
        public V get(@NotNull Map<Key<K, V>, ? extends V> map, boolean nonnull) {
            V obj = map.get(this);
            if (obj == null && nonnull) {
                throw new NullPointerException("cannot be null, key=" + this.key + ", reg=" + this.reg);
            }
            return obj;
        }

        @Contract(value="_,!null ->!null")
        public V getOr(@NotNull Function<Key<K, V>, V> fun, V elze) {
            V obj = fun.apply(this);
            return obj != null ? obj : elze;
        }

        @Contract(value="_,!null ->!null")
        public V getOr(@NotNull Map<Key<K, V>, ? extends V> map, V elze) {
            V obj = map.get(this);
            return obj != null ? obj : elze;
        }

        @Contract(value="_,!null ->!null")
        public V tryOr(@NotNull Function<Key<K, V>, ?> fun, V elze) throws ClassCastException {
            Object obj = fun.apply(this);
            return (V)(obj != null ? obj : elze);
        }

        @Contract(value="_,!null ->!null")
        public V tryOr(@NotNull Map<?, ?> map, V elze) throws ClassCastException {
            Object obj = map.get(this);
            return (V)(obj != null ? obj : elze);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key1 = (Key)o;
            return this.reg.equals(key1.reg) && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.reg, this.key);
        }

        public String toString() {
            return "TypedReg.Key{reg=" + this.reg + ", key=" + this.key + '}';
        }
    }
}

