/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import java.lang.reflect.Method;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cast.BiConvertor;

public class MethodConvertor
implements BiConvertor<String, Method> {
    @Override
    @NotNull
    public Class<String> sourceType() {
        return String.class;
    }

    @Override
    @NotNull
    public Class<Method> targetType() {
        return Method.class;
    }

    @Override
    @Nullable
    public Method toTarget(String s) {
        return MethodConvertor.str2Method(s, true);
    }

    @Override
    @Nullable
    public String toSource(Method m) {
        return MethodConvertor.method2Str(m);
    }

    @Contract(value="!null->!null")
    public static String method2Str(Method mth) {
        if (mth == null) {
            return null;
        }
        Class<?> clz = mth.getDeclaringClass();
        StringBuilder buff = new StringBuilder(100);
        buff.append(clz.getName()).append('#');
        buff.append(mth.getName()).append('(');
        Class<?>[] pms = mth.getParameterTypes();
        for (int i = 0; i < pms.length; ++i) {
            if (i > 0) {
                buff.append(',');
            }
            buff.append(pms[i].getSimpleName());
        }
        buff.append(')');
        return buff.toString();
    }

    @Contract(value="!null->!null")
    public static Method str2Method(String str) {
        return MethodConvertor.str2Method(str, false);
    }

    @Contract(value="null,_->null;!null,false->!null")
    public static Method str2Method(String str, boolean nullIfError) {
        int ps3;
        if (str == null) {
            return null;
        }
        int ps1 = str.indexOf(35);
        if (ps1 <= 0) {
            if (nullIfError) {
                return null;
            }
            throw new IllegalArgumentException("no `#` found, format=a.b.MyClass#method(p1,p2), str=" + str);
        }
        int ps2 = str.indexOf(40, ps1 + 1);
        if (ps2 <= ps1) {
            if (nullIfError) {
                return null;
            }
            throw new IllegalArgumentException("no `(` found, format=a.b.MyClass#method(p1,p2), str=" + str);
        }
        int bgn = ps2 + 1;
        int end = str.length() - 1;
        int off = bgn;
        int idx = 0;
        int[] cms = new int[end - bgn];
        for (int i = 0; i < cms.length && (ps3 = str.indexOf(44, off)) >= 0; ++i) {
            if (ps3 <= off) {
                if (nullIfError) {
                    return null;
                }
                throw new IllegalArgumentException("bad `,,` found, format=a.b.MyClass#method(p1,p2), str=" + str);
            }
            cms[idx++] = ps3;
            off = ps3 + 1;
        }
        int cnt = end > bgn ? idx + 1 : 0;
        String clz = str.substring(0, ps1);
        String mth = str.substring(ps1 + 1, ps2);
        try {
            block3: for (Method md : Class.forName(clz).getDeclaredMethods()) {
                Class<?>[] ps;
                if (!mth.equals(md.getName()) || (ps = md.getParameterTypes()).length != cnt) continue;
                if (cnt == 0) {
                    return md;
                }
                int b = bgn;
                for (int i = 0; i < idx; ++i) {
                    if (!str.regionMatches(b, ps[i].getSimpleName(), 0, cms[i] - b)) continue block3;
                    b = cms[i] + 1;
                }
                if (!str.regionMatches(b, ps[cnt - 1].getSimpleName(), 0, end - b)) continue;
                return md;
            }
        }
        catch (Exception e) {
            if (nullIfError) {
                return null;
            }
            throw new IllegalArgumentException("bad format, str=" + str, e);
        }
        return null;
    }
}

