/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.nio.CharBuffer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Null;

@ThreadSafe
public abstract class RandCode {
    public static final Seed Num = Seed.range('0', '9');
    public static final Seed Low = Seed.range('a', 'z');
    public static final Seed Upr = Seed.range('A', 'Z');
    public static final Seed Sym = Seed.chars("~!@#$%^&*()_+{}:<>?-=[];,.".toCharArray());
    public static final Seed B32 = Seed.chars("0123456789ABCDEFGHJKMNPQRSTVWXYZ".toCharArray());
    public static final Seed Hex = Seed.chars("0123456789ABCDEF".toCharArray());
    public static final Seed Cjk = Seed.chars("\u4e00\u4e03\u4e09\u4e0a\u4e0b\u4e0d\u4e16\u4e2d\u4e3b\u4e45\u4e58\u4e5d\u4e8b\u4e8c\u4e94\u4e95\u4ea1\u4ea4\u4eac\u4eba\u4ec1\u4eca\u4ed6\u4ed9\u4ee3\u4ee4\u4ee5\u4ef0\u4f0f\u4f10\u4f11\u4f4d\u4f4e\u4f4f\u4f55\u4f5b\u4f5c\u4f7f\u6765\u4f8b\u4f9d\u4fbf\u4fd7\u4fdd\u4fe1\u4fee\u4e2a\u501f\u5047\u4f1f\u505c\u5907\u4f20\u4f24\u4ef7\u4ebf\u5143\u5144\u5145\u5146\u5148\u5149\u514d\u513f\u5165\u5185\u5168\u4e24\u516b\u516c\u516d\u5171\u5175\u5178\u518c\u518d\u51ac\u51b0\u51b7\u51fa\u5200\u5206\u5211\u5217\u521d\u5224\u522b\u5229\u5230\u5219\u524d\u529b\u529f\u52a0\u52a9\u52c7\u52c9\u52a8\u52a1\u80dc\u52b3\u52bf\u52e4\u529d\u5316\u5317\u533a\u5341\u5343\u5348\u534a\u5352\u534f\u5357\u5370\u5371\u5377\u539a\u539f\u53bb\u53c2\u53c8\u53ca\u53cb\u53cd\u53d6\u53d7\u53e3\u53e4\u53e5\u53ef\u53f2\u53f3\u5404\u5408\u5409\u540c\u540d\u5411\u541b\u5426\u5439\u544a\u5473\u547c\u547d\u548c\u54c0\u54c1\u5531\u5546\u95ee\u5584\u559c\u4e27\u5355\u4e25\u56db\u56de\u56e0\u56f0\u56fa\u56fd\u56ed\u5706\u56fe\u56e2\u571f\u5728\u5730\u5747\u57ce\u6267\u57fa\u5802\u575a\u62a5\u573a\u589e\u58eb\u58ee\u5bff\u590f\u5915\u5916\u591a\u591c\u5927\u5929\u592a\u592b\u592e\u5931\u5949\u5973\u597d\u5982\u5999\u59b9\u59bb\u59ca\u59cb\u59d3\u5a01\u5a5a\u5987\u5b50\u5b57\u5b58\u5b5d\u5b63\u5b59\u5b66\u5b85\u5b87\u5b88\u5b89\u5b8c\u5b97\u5b98\u5b99\u5b9a\u5ba2\u5ba4\u5bb3\u5bb6\u5bb9\u5bbf\u5bc6\u5bcc\u5bd2\u5bdf\u5b9e\u5199\u5bf8\u5bfa\u5c04\u5c06\u5c0a\u5bf9\u5c0f\u5c11\u5c31\u5c3a\u5c3e\u5c40\u5c45\u5c4b\u5c55\u5c71\u5c9b\u5d07\u5ddd\u5de5\u5de6\u5de8\u5df1\u5df2\u5e02\u5e03\u5e0c\u5e08\u5e2d\u5e38\u5e73\u5e74\u5e78\u5e7c\u5e8f\u5e97\u5ea6\u5ead\u5e7f\u5efa\u5f0f\u5f13\u5f15\u5f1f\u5f31\u5f3a\u5f62\u5f7c\u5f80\u5f85\u5f8b\u5f8c\u5f92\u5f97\u4ece\u5fb7\u5fc3\u5fc5\u5fcd\u5fd7\u5fd8\u5fd9\u5fe0\u5feb\u5ff5\u6012\u601d\u6025\u6027\u6028\u6068\u6069\u609f\u60a3\u60b2\u60c5\u60dc\u60e0\u6076\u60f3\u6101\u610f\u7231\u611f\u6148\u5e86\u5fe7\u5fc6\u5e94\u6210\u6211\u6218\u6237\u6240\u624b\u624d\u6253\u6276\u627f\u6280\u6295\u62b1\u62db\u62dc\u62fe\u6301\u6307\u6388\u91c7\u63a2\u63a5\u63a8\u626c\u652f\u6536\u6539\u653e\u653f\u6545\u6548\u6551\u8d25\u6559\u6562\u6563\u656c\u654c\u6570\u6587\u6599\u65b0\u65b9\u65bd\u65c5\u65cf\u65e5\u65e9\u660e\u6613\u6614\u661f\u6625\u6628\u662f\u65f6\u665a\u663c\u666f\u6674\u6691\u6696\u6697\u66ae\u66b4\u66f2\u66f4\u4e66\u6700\u4f1a\u6708\u6709\u670d\u671b\u671d\u671f\u6728\u672a\u672b\u672c\u6731\u6750\u6751\u4e1c\u677e\u6797\u679c\u679d\u67d4\u6821\u6839\u683d\u6848\u690d\u4e1a\u6781\u8363\u4e50\u6811\u6865\u6743\u6b21\u6b32\u6b4c\u6b22\u6b62\u6b63\u6b65\u6b66\u5c81\u5386\u5f52\u6b7b\u6740\u6bcd\u6bcf\u6bd4\u6bdb\u6c0f\u6c11\u6c14\u6c34\u6c38\u6c5f\u51b3\u6cb3\u6cb9\u6cbb\u6cc9\u6cd5\u6ce2\u6ce3\u6ce8\u6cf0\u6d0b\u6d17\u6d3b\u6d41\u6d6a\u6d6e\u6d74\u6d77\u6d88\u51c9\u51c0\u6df1\u6df7\u6d45\u6e05\u51cf\u6e56\u6e29\u6ee1\u6e14\u6c49\u6d01\u706b\u70c8\u65e0\u7136\u70df\u70ed\u706f\u4e89\u7236\u7247\u725b\u7269\u7279\u72ac\u72ec\u7389\u738b\u73b0\u7403\u7406\u7518\u751f\u4ea7\u7528\u7530\u7531\u7533\u7537\u754c\u7559\u756a\u753b\u5f02\u5f53\u75c5\u767b\u53d1\u767d\u767e\u7684\u7686\u7687\u76ae\u76ca\u76db\u5c3d\u76ee\u76f4\u76f8\u7701\u770b\u771f\u7720\u773c\u7740\u77e5\u77ed\u77f3\u7834\u784f\u793a\u7956\u795d\u795e\u796d\u7981\u798f\u793c\u79c0\u79c1\u79cb\u79d1\u79fb\u7a0e\u79cd\u8c37\u7a76\u7a7a\u7a97\u7acb\u7ae0\u7ae5\u7aef\u7ade\u7af9\u7b11\u7b2c\u7b14\u7b49\u7b54\u7b97\u8282\u7c73\u7cbe\u7ea6\u7ea2\u7eaf\u7eb8\u7d20\u7ec6\u7ec8\u7ed3\u7edd\u7ed9\u7edf\u7ecf\u7eff\u7ebf\u7ec3\u7eed\u7f6a\u7f8a\u7f8e\u4e49\u4e60\u8001\u8003\u8005\u8015\u8033\u5723\u95fb\u58f0\u542c\u8089\u80b2\u80f8\u80fd\u8131\u81e3\u81ea\u81f3\u81f4\u4e0e\u5174\u4e3e\u65e7\u820c\u820d\u821e\u8239\u826f\u8272\u82b1\u82e5\u82e6\u82f1\u8336\u8349\u83dc\u534e\u4e07\u843d\u53f6\u8457\u827a\u836f\u864e\u5904\u865a\u53f7\u866b\u8840\u4f17\u884c\u8857\u8863\u8868\u5236\u897f\u8981\u89c1\u89c6\u4eb2\u89c2\u89d2\u89e3\u8a00\u8ba1\u8bad\u8bb0\u8bbf\u8bbe\u8bb8\u8bd5\u8bd7\u8bdd\u8ba4\u8bed\u8bda\u8bef\u8bf4\u8c01\u8bfe\u8c03\u8c08\u8bf7\u8bba\u8bf8\u8bb2\u8c22\u8bc1\u8bc6\u8bae\u8bfb\u53d8\u8ba9\u8c46\u4e30\u8d1d\u8d22\u8d2b\u8d27\u8d23\u8d2e\u8d35\u4e70\u8d3a\u8d4f\u8d24\u5356\u8d28\u8d64\u8d70\u8d77\u8db3\u8def\u8eab\u8f66\u519b\u8f7b\u8f9b\u519c\u8fce\u8fd1\u8ffd\u9000\u9001\u9006\u901a\u901f\u9020\u8fde\u8fdb\u9047\u6e38\u8fd0\u8fc7\u9053\u8fbe\u8fdc\u9002\u9009\u9057\u90e8\u90fd\u4e61\u9152\u533b\u91cc\u91cd\u91ce\u91cf\u91d1\u9488\u94f6\u94b1\u949f\u94c1\u957f\u95e8\u95ed\u5f00\u95f2\u95f4\u5173\u9632\u964d\u9650\u9664\u9634\u9646\u9633\u96c4\u96c6\u96be\u96e8\u96ea\u4e91\u7535\u9732\u9752\u9759\u975e\u9762\u9769\u97e9\u97f3\u9876\u987a\u987b\u9886\u5934\u9898\u613f\u98ce\u98de\u98df\u996d\u996e\u517b\u9980\u9996\u9999\u9a6c\u60ca\u9aa8\u4f53\u9ad8\u9c7c\u9c9c\u9e1f\u9e23\u9ea6\u9ec4\u9ed1\u70b9\u9f3b\u9f7f".toCharArray());
    public static final Seed Sur = Seed.chars("\u674e\u738b\u5f20\u5218\u9648\u6768\u8d75\u9ec4\u5468\u5434\u5f90\u5b59\u80e1\u6731\u9ad8\u6797\u4f55\u90ed\u9a6c\u7f57\u6881\u5b8b\u90d1\u8c22\u97e9\u5510\u51af\u4e8e\u8463\u8427\u7a0b\u66f9\u8881\u9093\u8bb8\u5085\u6c88\u66fe\u5f6d\u5415\u82cf\u5362\u848b\u8521\u8d3e\u4e01\u9b4f\u859b\u53f6\u960e\n\u4f59\u6f58\u675c\u6234\u590f\u949f\u6c6a\u7530\u4efb\u59dc\u8303\u65b9\u77f3\u59da\u8c2d\u5ed6\u90b9\u718a\u91d1\u9646\u90dd\u5b54\u767d\u5d14\u5eb7\u6bdb\u90b1\u79e6\u6c5f\u53f2\u987e\u4faf\u90b5\u5b5f\u9f99\u4e07\u6bb5\u6f15\u94b1\u6c64\u5c39\u9ece\u6613\u5e38\u6b66\u4e54\u8d3a\u8d56\u9f9a\u6587\n\u5e9e\u6a0a\u5170\u6bb7\u65bd\u9676\u6d2a\u7fdf\u5b89\u989c\u502a\u4e25\u725b\u6e29\u82a6\u5b63\u4fde\u7ae0\u9c81\u845b\u4f0d\u97e6\u7533\u5c24\u6bd5\u8042\u4e1b\u7126\u5411\u67f3\u90a2\u8def\u5cb3\u9f50\u6cbf\u6885\u83ab\u5e84\u8f9b\u7ba1\u795d\u5de6\u6d82\u8c37\u7941\u65f6\u8212\u803f\u725f\u535c\n\u8def\u8a79\u5173\u82d7\u51cc\u8d39\u7eaa\u9773\u76db\u7ae5\u6b27\u7504\u9879\u66f2\u6210\u6e38\u9633\u88f4\u5e2d\u536b\u67e5\u5c48\u9c8d\u4f4d\u8983\u970d\u7fc1\u968b\u690d\u7518\u666f\u8584\u5355\u5305\u53f8\u67cf\u5b81\u67ef\u962e\u6842\u95f5\u89e3\u5f3a\u67f4\u534e\u8f66\u5189\u623f\u8fb9\n\u8f9c\u5409\u9976\u5201\u77bf\u621a\u4e18\u53e4\u7c73\u6c60\u6ed5\u664b\u82d1\u90ac\u81e7\u7545\u5bab\u6765\u5d7a\u82df\u5168\u891a\u5ec9\u7b80\u5a04\u76d6\u7b26\u595a\u6728\u7a46\u515a\u71d5\u90ce\u90b8\u5180\u8c08\u59ec\u5c60\u8fde\u90dc\u664f\u683e\u90c1\u5546\u8499\u8ba1\u55bb\u63ed\u7aa6\u8fdf\n\u5b87\u6556\u7cdc\u9122\u51b7\u5353\u82b1\u4ec7\u827e\u84dd\u90fd\u5de9\u7a3d\u4e95\u7ec3\u4ef2\u4e50\u865e\u535e\u5c01\u7afa\u51bc\u539f\u5b98\u8863\u695a\u4f5f\u6817\u5321\u5b97\u5e94\u53f0\u5deb\u97a0\u50e7\u6851\u8346\u8c0c\u94f6\u626c\u660e\u6c99\u8584\u4f0f\u5c91\u4e60\u80e5\u4fdd\u548c\u853a".toCharArray());
    private static final Seed[] Man = new Seed[]{Seed.chars("23456789".toCharArray()), Seed.chars("abdefghqrt".toCharArray()), Seed.chars("ABDEFGHIJLQRTY".toCharArray())};
    private static final Seed[] Mix = new Seed[]{Seed.chars("23456789".toCharArray()), Seed.chars("abdefghqrt".toCharArray()), Seed.chars("ABDEFGHIJLQRTY".toCharArray()), Cjk};

    @NotNull
    public static String hex(int len) {
        return RandCode.next(len, Hex);
    }

    @NotNull
    public static String oil(int len) {
        return RandCode.next(len, B32);
    }

    public static String number(int len) {
        return RandCode.next(len, Num);
    }

    public static String lower(int len) {
        return RandCode.next(len, Low);
    }

    public static String upper(int len) {
        return RandCode.next(len, Upr);
    }

    public static String letter(int len) {
        return RandCode.next(len, Low, Upr);
    }

    public static String numlet(int len) {
        return RandCode.next(len, Num, Low, Upr);
    }

    public static String strong(int len) {
        return RandCode.next(len, Num, Low, Upr, Sym);
    }

    public static String human(int len) {
        return RandCode.next(len, Man);
    }

    public static String cjk(int len) {
        return RandCode.next(len, Cjk);
    }

    public static String mix(int len) {
        return RandCode.next(len, Mix);
    }

    public static String sur() {
        return RandCode.next(1, Sur);
    }

    public static String sur(int len) {
        return RandCode.next(len, Sur);
    }

    public static String next(int len, Seed ... seeds) {
        return RandCode.next(len, ThreadLocalRandom.current(), seeds);
    }

    public static String next(int len, Random random, Seed ... seeds) {
        StringBuilder sb = new StringBuilder();
        int sln = seeds.length;
        if (sln == 1) {
            seeds[0].rand(random, sb, len);
        } else {
            int i;
            int[] seed = new int[len];
            for (i = 0; i < len; ++i) {
                seed[i] = i % sln;
            }
            for (i = len - 1; i > 0; --i) {
                int j = random.nextInt(i + 1);
                int a = seed[j];
                seed[j] = seed[i];
                seed[i] = a;
            }
            for (int i2 : seed) {
                seeds[i2].rand(random, sb, 1);
            }
        }
        return sb.toString();
    }

    public static class Seed {
        private final char[] range;
        private final char[] chars;

        public static Seed range(char ... minmax) {
            return new Seed(minmax, Null.Chars);
        }

        public static Seed chars(char ... chars) {
            return new Seed(Null.Chars, chars);
        }

        public static Seed seeds(Seed ... seeds) {
            int rlen = 0;
            int clen = 0;
            for (Seed seed : seeds) {
                rlen += seed.range.length;
                clen += seed.chars.length;
            }
            CharBuffer range = CharBuffer.allocate(rlen);
            CharBuffer chars = CharBuffer.allocate(clen);
            for (Seed seed : seeds) {
                range.put(seed.range);
                chars.put(seed.chars);
            }
            return new Seed(range.array(), chars.array());
        }

        public Seed(char[] range, char[] chars) {
            int rlen;
            if (range == null) {
                range = Null.Chars;
            }
            if (chars == null) {
                chars = Null.Chars;
            }
            AssertArgs.isTrue((rlen = range.length) % 2 == 0, "range", "range must be [min,max]*");
            LinkedHashMap<String, char[]> rangeUniq = new LinkedHashMap<String, char[]>(rlen);
            for (int i = 0; i < rlen; i += 2) {
                char max = range[i + 1];
                char min = range[i];
                AssertArgs.isTrue(max >= min, "max", "need max >= min in range");
                rangeUniq.put(min + ":" + max, new char[]{min, max});
            }
            int rsiz = rangeUniq.size() * 2;
            if (rsiz == rlen) {
                this.range = range;
            } else {
                CharBuffer cb = CharBuffer.allocate(rsiz);
                for (char[] cs : rangeUniq.values()) {
                    cb.put(cs);
                }
                this.range = cb.array();
            }
            LinkedHashSet<Character> charsUniq = new LinkedHashSet<Character>(BoxedCastUtil.list(chars));
            int csiz = charsUniq.size();
            if (csiz == chars.length) {
                this.chars = chars;
            } else {
                this.chars = new char[csiz];
                int idx = 0;
                for (Character c : charsUniq) {
                    this.chars[idx++] = c.charValue();
                }
            }
        }

        public String rand(Random rnd, int len) {
            StringBuilder sb = new StringBuilder(len);
            this.rand(rnd, sb, len);
            return sb.toString();
        }

        public void rand(Random rnd, StringBuilder buf, int len) {
            for (int i = 0; i < len; ++i) {
                buf.append(this.next(rnd.nextInt()));
            }
        }

        public char next(int rnd) {
            boolean useRange;
            if (rnd < 0) {
                rnd >>>= 1;
            }
            if (this.range.length != 0 && this.chars.length != 0) {
                useRange = rnd % 2 == 0;
            } else {
                boolean bl = useRange = this.range.length != 0;
            }
            if (useRange) {
                int prt = rnd % this.range.length >>> 1 << 1;
                int len = this.range[prt + 1] - this.range[prt];
                if (len == 0) {
                    return this.range[prt];
                }
                return (char)(this.range[prt] + rnd % len);
            }
            int idx = rnd % this.chars.length;
            return this.chars[idx];
        }
    }
}

