/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cond;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IfSetter<S, T> {
    @Contract(value="_,_,_,_->param1")
    public T set(@NotNull T var1, @Nullable S var2, @NotNull Absent var3, @NotNull Present var4);

    @Contract(value="_,_->param1")
    default public T toAny(@NotNull T target, @Nullable S source) {
        return this.set(target, source, Absent.Any, Present.Any);
    }

    @Contract(value="_,_->param1")
    default public T toNull(@NotNull T target, @Nullable S source) {
        return this.set(target, source, Absent.Null, Present.Any);
    }

    @Contract(value="_,_->param1")
    default public T toInvalid(@NotNull T target, @Nullable S source) {
        return this.set(target, source, Absent.Invalid, Present.Any);
    }

    @Contract(value="_,_->param1")
    default public T ofNonnull(@NotNull T target, @Nullable S source) {
        return this.set(target, source, Absent.Any, Present.Nonnull);
    }

    @Contract(value="_,_->param1")
    default public T ofValid(@NotNull T target, @Nullable S source) {
        return this.set(target, source, Absent.Any, Present.Valid);
    }

    public static <T> void nonnull(@NotNull Consumer<T> setter, @Nullable T value) {
        if (value != null) {
            setter.accept(value);
        }
    }

    public static <T> void valid(@NotNull Consumer<T> setter, @Nullable T value, boolean valid) {
        if (valid) {
            setter.accept(value);
        }
    }

    public static <T> void valid(@NotNull Consumer<T> setter, @Nullable T value, @NotNull Predicate<T> validate) {
        if (validate.test(value)) {
            setter.accept(value);
        }
    }

    public static <T> void invalid(@NotNull Consumer<T> setter, @Nullable T value, boolean valid) {
        if (!valid) {
            setter.accept(value);
        }
    }

    public static <T> void invalid(@NotNull Consumer<T> setter, @Nullable T value, @NotNull Predicate<T> validate) {
        if (!validate.test(value)) {
            setter.accept(value);
        }
    }

    public static enum Present {
        Any,
        Nonnull,
        Valid;

    }

    public static enum Absent {
        Any,
        Null,
        Invalid;

    }
}

