/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface DataAware<T> {
    @Nullable
    public T getData();

    @Contract(value="true->!null")
    default public T getDataIf(boolean nonnull) {
        T data = this.getData();
        if (nonnull && data == null) {
            throw new NullPointerException("data must be nonnull");
        }
        return data;
    }

    @Contract(value="!null->!null")
    default public T getDataOr(T elze) {
        T data = this.getData();
        return data == null ? elze : data;
    }
}

