/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import pro.fessional.mirana.best.ReadOnly;
import pro.fessional.mirana.data.CodeAware;
import pro.fessional.mirana.data.DataAware;
import pro.fessional.mirana.data.DataResult;
import pro.fessional.mirana.data.ErrorResult;
import pro.fessional.mirana.data.NameAware;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nMessage;
import pro.fessional.mirana.i18n.I18nNotice;

public class R<T>
extends I18nMessage
implements DataResult<T>,
ErrorResult,
I18nAware {
    private static final long serialVersionUID = 19791023L;
    protected boolean success = false;
    protected Object data;
    protected String code;
    protected List<I18nNotice> errors;
    protected Object cause = null;

    public R() {
    }

    public R(boolean success) {
        this(success, null, (String)null);
    }

    public R(boolean success, T data) {
        this(success, data, (String)null);
    }

    public R(boolean success, T data, String code) {
        this.success = success;
        this.data = data;
        this.code = code;
    }

    public R(boolean success, T data, String code, String message) {
        this(success, data, code);
        this.setMessage(message);
    }

    public R(boolean success, T data, String code, String message, String i18nCode) {
        this(success, data, code);
        this.setMessageBy(message, i18nCode);
    }

    public R(boolean success, T data, String code, String message, String i18nCode, Object ... i18nArgs) {
        this(success, data, code);
        this.setMessageBy(message, i18nCode, i18nArgs);
    }

    public R(boolean success, T data, String code, I18nAware message) {
        this(success, data, code);
        this.setMessageBy(message);
    }

    public R(boolean success, T data, I18nAware message) {
        this(success, data);
        this.setMessageBy(message);
    }

    public R(boolean success, T data, CodeEnum code) {
        this(success, data);
        this.setCodeMessage(code);
    }

    public R(I18nNotice err) {
        this(false);
        if (err != null) {
            this.errors = Collections.singletonList(err);
        }
    }

    public R(List<I18nNotice> errs) {
        this(false);
        this.errors = errs;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Contract(value="_->this")
    public R<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    @Override
    public T getData() {
        return (T)this.data;
    }

    @Contract(value="_->this")
    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Contract(value="_->this")
    public R<T> setCode(String code) {
        this.code = code;
        return this;
    }

    @Override
    @Nullable
    public List<I18nNotice> getErrors() {
        return this.errors;
    }

    @Contract(value="_->this")
    public R<T> setErrors(List<I18nNotice> errors) {
        this.errors = errors;
        return this;
    }

    @Override
    public void applyLocale(Locale locale, @NotNull I18nAware.I18nSource source) {
        super.applyLocale(locale, source);
        if (this.errors != null) {
            for (I18nNotice er : this.errors) {
                er.applyLocale(locale, source);
            }
        }
    }

    @Transient
    @Nullable
    public Object getCause() {
        return this.cause;
    }

    @Transient
    @Nullable
    public <E> E getCause(Class<E> type) {
        if (type != null && type.isInstance(this.cause)) {
            return (E)this.cause;
        }
        return null;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCause(Object cause) {
        this.cause = cause;
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfOk(T data) {
        return this.success ? this.setData(data) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfNg(T data) {
        return this.success ? this : this.setData(data);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfOk(@NotNull Supplier<T> data) {
        return this.success ? this.setData(data.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfNg(@NotNull Supplier<T> data) {
        return this.success ? this : this.setData(data.get());
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfOk(String code) {
        return this.success ? this.setCode(code) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfNg(String code) {
        return this.success ? this : this.setCode(code);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfOk(@NotNull Supplier<String> code) {
        return this.success ? this.setCode(code.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfNg(@NotNull Supplier<String> code) {
        return this.success ? this : this.setCode(code.get());
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfOk(String message) {
        return this.success ? (R)this.setMessage(message) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfNg(String message) {
        return this.success ? this : (R)this.setMessage(message);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfOk(@NotNull Supplier<String> message) {
        return this.success ? (R)this.setMessage(message.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfNg(@NotNull Supplier<String> message) {
        return this.success ? this : (R)this.setMessage(message.get());
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeMessage(CodeEnum code) {
        if (code != null) {
            this.setCode(code.getCode());
            this.setMessageBy(code);
        }
        return this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setCodeMessage(String code, String message) {
        this.setCode(code);
        this.setMessage(message);
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeMessageIfOk(CodeEnum code) {
        return this.success ? this.setCodeMessage(code) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeMessageIfNg(CodeEnum code) {
        return this.success ? this : this.setCodeMessage(code);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeMessageIfOk(@NotNull Supplier<CodeEnum> code) {
        return this.success ? this.setCodeMessage(code.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeMessageIfNg(@NotNull Supplier<CodeEnum> code) {
        return this.success ? this : this.setCodeMessage(code.get());
    }

    @Contract(value="_->this")
    public <S extends R<D>, D> S castData(D data) {
        this.data = data;
        return (S)this;
    }

    @Contract(value="_->this")
    public <S extends R<D>, D> S castData(Function<T, D> fun) {
        return this.castData(fun.apply(this.data));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        R r = (R)o;
        return this.success == r.success && Objects.equals(this.data, r.data) && Objects.equals(this.code, r.code) && Objects.equals(this.errors, r.errors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.success, this.data, this.code, this.errors);
    }

    @Override
    public String toString() {
        return "R{success=" + this.success + ", data=" + this.data + ", code='" + this.code + '\'' + ", errors=" + this.errors + ", cause=" + this.cause + ", message='" + this.message + '\'' + ", i18nCode='" + this.i18nCode + '\'' + ", i18nArgs=" + Arrays.toString(this.i18nArgs) + "} ";
    }

    public static <T> R<T> orData(boolean success, T okData, T ngData) {
        T data = success ? okData : ngData;
        return new R<T>(success, data, null, (String)null);
    }

    public static <T> R<T> orCode(boolean success, String okCode, String ngCode) {
        String code = success ? okCode : ngCode;
        return new R<Object>(success, null, code, (String)null);
    }

    public static <T> R<T> orCode(boolean success, CodeEnum okCode, CodeEnum ngCode) {
        CodeEnum code = success ? okCode : ngCode;
        return new R<Object>(success, null, code == null ? null : code.getCode(), (String)null);
    }

    public static <T> R<T> orMessage(boolean success, String okMessage, String ngMessage) {
        String message = success ? okMessage : ngMessage;
        return new R<Object>(success, null, null, message);
    }

    public static <T> R<T> orCodeMessage(boolean success, CodeEnum okCode, CodeEnum ngCode) {
        CodeEnum code = success ? okCode : ngCode;
        return new R<Object>(success, null, code);
    }

    public static <T> R<T> of(boolean success) {
        return new R<Object>(success, null, null, (String)null);
    }

    public static <T> R<T> of(boolean success, T data) {
        return new R<T>(success, data, null, (String)null);
    }

    public static <T> R<T> of(boolean success, T data, String code) {
        return new R<T>(success, data, code, (String)null);
    }

    public static <T> R<T> of(boolean success, T data, String code, String message) {
        return new R<T>(success, data, code, message);
    }

    public static <T> R<T> of(boolean success, T data, String code, I18nAware message) {
        return new R<T>(success, data, code, message);
    }

    public static <T> R<T> of(boolean success, T data, I18nAware message) {
        return new R<T>(success, data, message);
    }

    public static <T> R<T> of(boolean success, T data, CodeEnum code) {
        return new R<T>(success, data, code);
    }

    public static <T> R<T> ofCode(boolean success, String code) {
        return new R<Object>(success, null, code, (String)null);
    }

    public static <T> R<T> ofCode(boolean success, CodeEnum code) {
        return new R<Object>(success, null, code == null ? null : code.getCode(), (String)null);
    }

    public static <T> R<T> ofMessage(boolean success, String message) {
        return new R<Object>(success, null, null, message);
    }

    public static <T> R<T> ofMessage(boolean success, I18nAware message) {
        return new R<Object>(success, null, message);
    }

    public static <T> R<T> ofCodeMessage(boolean success, CodeEnum code) {
        return new R<Object>(success, null, code);
    }

    public static <T> R<T> OK() {
        return Immutable.OK;
    }

    public static <T> R<T> ok() {
        return R.of(true);
    }

    public static <T> R<T> ok(T data) {
        return R.of(true, data);
    }

    public static <T> R<T> ok(T data, String code) {
        return R.of(true, data, code);
    }

    public static <T> R<T> ok(T data, String code, String message) {
        return R.of(true, data, code, message);
    }

    public static <T> R<T> ok(T data, String code, I18nAware message) {
        return R.of(true, data, code, message);
    }

    public static <T> R<T> ok(T data, I18nAware code) {
        return R.of(true, data, code);
    }

    public static <T> R<T> ok(T data, CodeEnum code) {
        return R.of(true, data, code);
    }

    public static <T> R<T> okCode(String code) {
        return R.ofCode(true, code);
    }

    public static <T> R<T> okCode(CodeEnum code) {
        return R.ofCode(true, code);
    }

    public static <T> R<T> okMessage(String message) {
        return R.ofMessage(true, message);
    }

    public static <T> R<T> okMessage(I18nAware message) {
        return R.ofMessage(true, message);
    }

    public static <T> R<T> okCodeMessage(CodeEnum code) {
        return new R<Object>(true, null, code);
    }

    public static <T> R<T> NG() {
        return Immutable.NG;
    }

    public static <T> R<T> ng() {
        return R.of(false);
    }

    public static <T> R<T> ng(T data) {
        return R.of(false, data);
    }

    public static <T> R<T> ng(T data, String code) {
        return R.of(false, data, code);
    }

    public static <T> R<T> ng(T data, String code, String message) {
        return R.of(false, data, code, message);
    }

    public static <T> R<T> ng(T data, String code, I18nAware message) {
        return R.of(false, data, code, message);
    }

    public static <T> R<T> ng(T data, I18nAware code) {
        return R.of(false, data, code);
    }

    public static <T> R<T> ng(T data, CodeEnum code) {
        return R.of(false, data, code);
    }

    public static <T> R<T> ngCode(String code) {
        return R.ofCode(false, code);
    }

    public static <T> R<T> ngCode(CodeEnum code) {
        return R.ofCode(false, code);
    }

    public static <T> R<T> ngMessage(String message) {
        return R.ofMessage(false, message);
    }

    public static <T> R<T> ngMessage(I18nAware message) {
        return R.ofMessage(false, message);
    }

    public static <T> R<T> ngCodeMessage(CodeEnum code) {
        return new R<Object>(false, null, code);
    }

    public static <T> R<T> ngError(I18nNotice error) {
        return new R<T>(error);
    }

    public static <T> R<T> ngError(I18nNotice error, String code) {
        R<T> r = R.ngError(error);
        r.setCode(code);
        return r;
    }

    public static <T> R<T> ngError(List<I18nNotice> errors) {
        return new R<T>(errors);
    }

    public static <T> R<T> ngError(List<I18nNotice> errors, String code) {
        R<T> r = R.ngError(errors);
        r.setCode(code);
        return r;
    }

    public static <T> R<T> ngError(Throwable t, String type) {
        R r = new R(false);
        I18nNotice ntc = new I18nNotice();
        ntc.setType(type);
        if (t instanceof I18nAware) {
            ntc.setMessageBy((I18nAware)((Object)t));
        } else if (t != null) {
            ntc.setMessage(t.getMessage());
        }
        if (t instanceof NameAware) {
            ntc.setTarget(((NameAware)((Object)t)).getName());
        }
        if (t instanceof CodeAware) {
            r.setCode(((CodeAware)((Object)t)).getCode());
        }
        if (t instanceof DataAware) {
            Object dt = ((DataAware)((Object)t)).getData();
            r.setData(dt);
        }
        r.setErrors(Collections.singletonList(ntc));
        return r;
    }

    public static <T> R<T> ngCause(Throwable t) {
        R<T> r = new R<T>(false);
        r.setCause(t);
        if (t instanceof I18nAware) {
            r.setMessageBy((I18nAware)((Object)t));
        } else if (t != null) {
            r.setMessage(t.getMessage());
        }
        return r;
    }

    public static <T> R<T> ngCause(Throwable t, String code) {
        R<T> r = R.ngCause(t);
        r.setCode(code);
        return r;
    }

    public static <T> R<T> ngCause(Throwable t, String code, String message) {
        R<T> r = R.ngCause(t);
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static <T> R<T> ngCause(Throwable t, String code, I18nAware message) {
        R<T> r = R.ngCause(t);
        r.setMessageBy(message);
        r.setCode(code);
        return r;
    }

    public static <T> R<T> ngCause(Throwable t, I18nAware message) {
        R<T> r = R.ngCause(t);
        r.setMessageBy(message);
        return r;
    }

    public static <T> R<T> ngCause(Throwable t, CodeEnum code) {
        R<T> r = R.ngCause(t);
        r.setCodeMessage(code);
        return r;
    }

    @Unmodifiable
    public static class Immutable<T>
    extends R<T>
    implements ReadOnly {
        public static final R<Void> OK = new Immutable<Void>(true);
        public static final R<Void> NG = new Immutable<Void>(false);

        public Immutable(boolean success) {
            super(success);
        }

        @Override
        public <S extends R<D>, D> S castData(D data) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setCause(Object cause) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setCode(String code) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setData(T data) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setErrors(List<I18nNotice> errors) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setSuccess(boolean success) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setI18nArgs(Object ... i18nArgs) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setI18nCode(String i18nCode) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setMessage(String message) {
            throw new UnsupportedOperationException("Immutable");
        }
    }
}

