/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.DummyBlock;

public interface Z {
    @SafeVarargs
    @NotNull
    public static <T> List<T> uniq(Collection<? extends T> ts, Function<? super T, ?> ... fn) {
        if (ts == null) {
            return Collections.emptyList();
        }
        if (fn == null || fn.length == 0) {
            if (ts instanceof List) {
                return (List)ts;
            }
            return new ArrayList<T>(ts);
        }
        HashMap map = new HashMap();
        ArrayList<T> result = new ArrayList<T>(ts.size());
        for (T t : ts) {
            ArrayList ks = new ArrayList(fn.length);
            for (Function<T, ?> function : fn) {
                ks.add(function.apply(t));
            }
            Boolean o = map.putIfAbsent(ks, Boolean.TRUE);
            if (o != null) continue;
            result.add(t);
        }
        return result;
    }

    @Nullable
    public static <T> T find(Predicate<T> p, Iterable<? extends T> ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || !p.test(t)) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T> T find(Predicate<T> p, T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || !p.test(t)) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="!null,_,_ ->!null")
    public static <T> T findSure(T d, Predicate<T> p, T ... ts) {
        T t = Z.find(p, ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_,_ ->!null")
    public static <T> T findSure(T d, Predicate<T> p, Iterable<? extends T> ts) {
        T t = Z.find(p, ts);
        return t == null ? d : t;
    }

    @SafeVarargs
    @Contract(value="!null,_,_ ->!null")
    public static <T> T findSafe(Supplier<T> d, Predicate<T> p, T ... ts) {
        T t = Z.find(p, ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_,_ ->!null")
    public static <T> T findSafe(Supplier<T> d, Predicate<T> p, Iterable<? extends T> ts) {
        T t = Z.find(p, ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static <T, R> R make(Function<T, R> f, Iterable<? extends T> ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            try {
                R r = f.apply(t);
                if (r == null) continue;
                return r;
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T, R> R make(Function<T, R> f, T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            try {
                R r = f.apply(t);
                if (r == null) continue;
                return r;
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSure(R d, Function<T, R> f, T ... ts) {
        R t = Z.make(f, ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSure(R d, Function<T, R> f, Iterable<? extends T> ts) {
        R t = Z.make(f, ts);
        return t == null ? d : t;
    }

    @SafeVarargs
    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSafe(Supplier<R> d, Function<T, R> f, T ... ts) {
        R t = Z.make(f, ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSafe(Supplier<R> d, Function<T, R> f, Iterable<? extends T> ts) {
        R t = Z.make(f, ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static BigDecimal decimal(Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).isEmpty()) continue;
            try {
                return new BigDecimal(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Nullable
    public static BigDecimal decimal(CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).isEmpty()) continue;
            try {
                return new BigDecimal(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSure(BigDecimal d, CharSequence ... ts) {
        BigDecimal t = Z.decimal(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSure(BigDecimal d, Iterable<? extends CharSequence> ts) {
        BigDecimal t = Z.decimal(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSafe(Supplier<BigDecimal> d, CharSequence ... ts) {
        BigDecimal t = Z.decimal(ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSafe(Supplier<BigDecimal> d, Iterable<? extends CharSequence> ts) {
        BigDecimal t = Z.decimal(ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static Long int64(Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).isEmpty()) continue;
            try {
                return Long.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Nullable
    public static Long int64(CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).isEmpty()) continue;
            try {
                return Long.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Sure(Long d, CharSequence ... ts) {
        Long t = Z.int64(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Sure(Long d, Iterable<? extends CharSequence> ts) {
        Long t = Z.int64(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Safe(Supplier<Long> d, CharSequence ... ts) {
        Long t = Z.int64(ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Safe(Supplier<Long> d, Iterable<? extends CharSequence> ts) {
        Long t = Z.int64(ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static Integer int32(Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).isEmpty()) continue;
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Nullable
    public static Integer int32(CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).isEmpty()) continue;
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return null;
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Sure(Integer d, CharSequence ... ts) {
        Integer t = Z.int32(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Sure(Integer d, Iterable<? extends CharSequence> ts) {
        Integer t = Z.int32(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Safe(Supplier<Integer> d, CharSequence ... ts) {
        Integer t = Z.int32(ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Safe(Supplier<Integer> d, Iterable<? extends CharSequence> ts) {
        Integer t = Z.int32(ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static <T> T notNull(Iterable<? extends T> ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T> T notNull(T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSure(T d, T ... ts) {
        T t = Z.notNull(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSure(T d, Iterable<? extends T> ts) {
        T t = Z.notNull(ts);
        return t == null ? d : t;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(Supplier<T> d, T ... ts) {
        T t = Z.notNull(ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(Supplier<T> d, Iterable<? extends T> ts) {
        T t = Z.notNull(ts);
        return t == null ? d.get() : t;
    }

    @Nullable
    public static <T extends CharSequence> T notEmpty(Iterable<? extends T> ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            if (t == null || t.length() <= 0) continue;
            return (T)t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T extends CharSequence> T notEmpty(T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || t.length() <= 0) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySure(T d, T ... ts) {
        CharSequence t = Z.notEmpty(ts);
        return (T)(t == null ? d : t);
    }

    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySure(T d, Iterable<? extends T> ts) {
        T t = Z.notEmpty(ts);
        return t == null ? d : t;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySafe(Supplier<T> d, T ... ts) {
        CharSequence t = Z.notEmpty(ts);
        return (T)(t == null ? (CharSequence)d.get() : t);
    }

    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySafe(Supplier<T> d, Iterable<? extends T> ts) {
        T t = Z.notEmpty(ts);
        return (T)(t == null ? (CharSequence)d.get() : t);
    }

    @Nullable
    public static String notBlank(Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).isEmpty()) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static String notBlank(CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).isEmpty()) continue;
            return s;
        }
        return null;
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSure(String d, CharSequence ... ts) {
        String t = Z.notBlank(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSure(String d, Iterable<? extends CharSequence> ts) {
        String t = Z.notBlank(ts);
        return t == null ? d : t;
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSafe(Supplier<String> d, CharSequence ... ts) {
        String t = Z.notBlank(ts);
        return t == null ? d.get() : t;
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSafe(Supplier<String> d, Iterable<? extends CharSequence> ts) {
        String t = Z.notBlank(ts);
        return t == null ? d.get() : t;
    }
}

