/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.dync;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collections;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Java {
    public static <T> T create(Class<T> clz, Object ... arg) {
        try {
            int len = arg == null ? 0 : arg.length;
            Class[] pc = new Class[len];
            for (int i = 0; i < len; ++i) {
                pc[i] = arg[i].getClass();
            }
            Constructor<T> con = clz.getConstructor(pc);
            return con.newInstance(arg);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to new instance of " + clz, e);
        }
    }

    public static <T> Class<T> compile(String javaFile, String javaCode) {
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            if (javaFile.endsWith(".java")) {
                javaFile = javaFile.substring(0, javaFile.length() - 5);
            }
            String fullPath = javaFile.replace('.', '/');
            final JavaByte byteObject = new JavaByte(fullPath);
            ForwardingJavaFileManager<StandardJavaFileManager> fileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(null, null, null)){

                @Override
                public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                    return byteObject;
                }
            };
            JavaCode stringObject = new JavaCode(fullPath, javaCode);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, null, null, Collections.singletonList(stringObject));
            task.call();
            fileManager.close();
            ClassLoader classLoader = new ClassLoader(){

                @Override
                public Class<?> findClass(String name) {
                    byte[] bytes = byteObject.getBytes();
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
            };
            Class<?> test = classLoader.loadClass(javaFile);
            return test;
        }
        catch (Throwable e) {
            throw new IllegalStateException("\njava-file=" + javaFile + "\njava-code=\n" + javaCode, e);
        }
    }

    public static class JavaCode
    extends SimpleJavaFileObject {
        private final String code;

        protected JavaCode(String path, String code) {
            super(URI.create("string:///" + path + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    public static class JavaByte
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

        protected JavaByte(String path) {
            super(URI.create("bytes:///" + path), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() {
            return this.bos;
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }
    }
}

