/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.flow;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.flow.FlowBreakException;

public class FlowReturnException
extends FlowBreakException {
    private final Object value;

    public FlowReturnException() {
        this.value = null;
    }

    public FlowReturnException(Object value) {
        this.value = value;
    }

    public FlowReturnException(Object value, Enum<?> label) {
        super(label);
        this.value = value;
    }

    @Nullable
    public <T> T getValue() {
        return (T)this.value;
    }

    @Contract(value="!null -> !null")
    public <T> T getOrElse(@Nullable T elze) {
        return (T)(this.value == null ? elze : this.value);
    }

    @Contract(value="!null,_ -> !null")
    public <T, S extends T> T getOrElse(@Nullable S elze, @NotNull Class<T> type) {
        return (T)(type.isInstance(this.value) ? this.value : elze);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

