/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.I18nString;

public interface I18nAware
extends Serializable {
    @Nullable
    public String getI18nCode();

    @Contract(value="true->!null")
    default public String getI18nCodeIf(boolean nonnull) {
        String code = this.getI18nCode();
        if (nonnull && code == null) {
            throw new NullPointerException("code must be nonnull");
        }
        return code;
    }

    @Contract(value="!null->!null")
    default public String getI18nCodeOr(String elze) {
        String code = this.getI18nCode();
        return code == null ? elze : code;
    }

    @Nullable
    public String getI18nHint();

    @Contract(value="true->!null")
    default public String getI18nHintIf(boolean nonnull) {
        String hint = this.getI18nHint();
        if (nonnull && hint == null) {
            throw new NullPointerException("hint must be nonnull");
        }
        return hint;
    }

    @Contract(value="!null->!null")
    default public String getI18nHintOr(String elze) {
        String hint = this.getI18nHint();
        return hint == null ? elze : hint;
    }

    @Nullable
    public Object[] getI18nArgs();

    @Contract(value="true->!null")
    default public Object[] getI18nArgsIf(boolean nonnull) {
        Object[] args = this.getI18nArgs();
        if (nonnull && args == null) {
            throw new NullPointerException("args must be nonnull");
        }
        return args;
    }

    @Contract(value="!null->!null")
    default public Object[] getI18nArgsOr(Object ... elze) {
        Object[] args = this.getI18nArgs();
        return args == null ? elze : args;
    }

    @NotNull
    default public I18nString toI18nString() {
        return this.toI18nString(null, null);
    }

    @NotNull
    default public I18nString toI18nString(String hint) {
        return this.toI18nString(hint, null);
    }

    @NotNull
    default public I18nString toI18nString(String hint, Object ... args) {
        hint = hint == null ? this.getI18nHint() : hint;
        args = args == null ? this.getI18nArgs() : args;
        return new I18nString(this.getI18nCode(), hint, args);
    }

    default public String toString(Locale locale) {
        return I18nAware.toString(locale, I18nSource.Default, this.getI18nCode(), this.getI18nHint(), this.getI18nArgs());
    }

    default public String toString(Locale locale, @NotNull I18nSource source) {
        return I18nAware.toString(locale, source, this.getI18nCode(), this.getI18nHint(), this.getI18nArgs());
    }

    default public void applyLocale(Locale locale, @NotNull I18nSource source) {
    }

    @Contract(value="_,_,!null,_,_->!null")
    public static String toString(Locale locale, @NotNull I18nSource source, String code, String hint, Object ... args) {
        String msg;
        if (code == null || code.isEmpty()) {
            return hint;
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof I18nAware)) continue;
                args[i] = ((I18nAware)args[i]).toString(locale, source);
            }
        }
        return (msg = source.getMessage(code, args, hint, locale)) == null || msg.isEmpty() ? code : msg;
    }

    @FunctionalInterface
    public static interface I18nSource {
        public static final I18nSource Default = (ignoreCode, args, hint, lang) -> {
            if (hint == null || hint.isEmpty()) {
                return null;
            }
            if (args == null || args.length == 0) {
                return hint;
            }
            if (lang == null) {
                lang = Locale.getDefault();
            }
            return new MessageFormat(hint, lang).format(args);
        };

        public String getMessage(String var1, Object[] var2, String var3, Locale var4);

        default public String getMessage(Locale lang, String code, String hint, Object ... args) {
            return this.getMessage(code, args, hint, lang);
        }
    }
}

