/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.cast.ChainingCast;
import pro.fessional.mirana.i18n.I18nAware;

public class I18nMessage
implements ChainingCast,
I18nAware {
    private static final long serialVersionUID = 19791023L;
    protected String message;
    protected String i18nCode;
    protected Object[] i18nArgs;

    public String getMessage() {
        return this.message;
    }

    @Contract(value="_->this")
    public I18nMessage setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String getI18nCode() {
        return this.i18nCode;
    }

    @Contract(value="_->this")
    public I18nMessage setI18nCode(String i18nCode) {
        this.i18nCode = i18nCode;
        return this;
    }

    @Override
    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    @Contract(value="_->this")
    public I18nMessage setI18nArgs(Object ... i18nArgs) {
        this.i18nArgs = i18nArgs;
        return this;
    }

    @Override
    @Transient
    public String getI18nHint() {
        return this.message;
    }

    @Transient
    @Contract(value="_->this")
    public I18nMessage setMessageBy(I18nAware ia) {
        if (ia != null) {
            this.setMessage(ia.getI18nHint());
            this.setI18nCode(ia.getI18nCode());
            this.setI18nArgs(ia.getI18nArgs());
        }
        return this;
    }

    @Transient
    @Contract(value="_,_->this")
    public I18nMessage setMessageBy(String message, I18nAware ia) {
        this.setMessageBy(ia);
        this.setMessage(message);
        return this;
    }

    @Transient
    @Contract(value="_,_->this")
    public I18nMessage setMessageBy(String message, String i18nCode) {
        this.setMessage(message);
        this.setI18nCode(i18nCode);
        return this;
    }

    @Transient
    @Contract(value="_,_,_->this")
    public I18nMessage setMessageBy(String message, String i18nCode, Object ... i18nArgs) {
        this.setMessage(message);
        this.setI18nCode(i18nCode);
        this.setI18nArgs(i18nArgs);
        return this;
    }

    @Override
    public void applyLocale(Locale locale, @NotNull I18nAware.I18nSource source) {
        this.setMessage(this.toString(locale, source));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I18nMessage that = (I18nMessage)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.i18nCode, that.i18nCode) && Objects.deepEquals(this.i18nArgs, that.i18nArgs);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.i18nCode, Arrays.hashCode(this.i18nArgs));
    }

    public String toString() {
        return "I18nMessage{message='" + this.message + '\'' + ", i18nCode='" + this.i18nCode + '\'' + ", i18nArgs=" + Arrays.toString(this.i18nArgs) + '}';
    }

    public static I18nMessage of(@NotNull I18nAware i18n) {
        I18nMessage msg = new I18nMessage();
        msg.setMessage(i18n.getI18nHint());
        msg.setI18nCode(i18n.getI18nCode());
        msg.setI18nArgs(i18n.getI18nArgs());
        return msg;
    }
}

