/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nMessage;

public class I18nNotice
extends I18nMessage {
    protected String type;
    protected String target;

    public String getType() {
        return this.type;
    }

    @Contract(value="_->this")
    public I18nNotice setType(String type) {
        this.type = type;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    @Contract(value="_->this")
    public I18nNotice setTarget(String target) {
        this.target = target;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        I18nNotice that = (I18nNotice)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.target);
    }

    @Override
    public String toString() {
        return "I18nNotice{type='" + this.type + '\'' + ", target='" + this.target + '\'' + ", message='" + this.message + '\'' + ", i18nCode='" + this.i18nCode + '\'' + ", i18nArgs=" + Arrays.toString(this.i18nArgs) + "} ";
    }

    @NotNull
    public static I18nNotice of(@NotNull I18nAware i18n) {
        I18nNotice ntc = new I18nNotice();
        ntc.setMessage(i18n.getI18nHint());
        ntc.setI18nCode(i18n.getI18nCode());
        ntc.setI18nArgs(i18n.getI18nArgs());
        return ntc;
    }

    @NotNull
    public static I18nNotice of(@NotNull I18nNotice i18n) {
        I18nNotice ntc = I18nNotice.of((I18nAware)i18n);
        ntc.setType(i18n.getType());
        ntc.setTarget(i18n.getTarget());
        return ntc;
    }

    public static enum Type {
        Validation,
        IllegalArgument,
        IllegalState;

    }
}

