/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.I18nAware;

public class I18nString
implements I18nAware {
    private static final long serialVersionUID = 19791023L;
    private static final Object[] EMPTY_ARGS = new Object[0];
    @NotNull
    private final String i18nCode;
    @NotNull
    private final Object[] i18nArgs;
    @NotNull
    private String i18nHint;
    private transient String i18nCache = null;

    public I18nString(String i18nCode) {
        this(i18nCode, "", EMPTY_ARGS);
    }

    public I18nString(String i18nCode, String i18nHint) {
        this(i18nCode, i18nHint, EMPTY_ARGS);
    }

    public I18nString(String i18nCode, String i18nHint, Object ... args) {
        this.i18nCode = i18nCode == null ? "" : i18nCode;
        this.i18nArgs = args == null ? EMPTY_ARGS : args;
        this.i18nHint = i18nHint == null ? "" : i18nHint;
    }

    @Override
    @NotNull
    public String getI18nCode() {
        return this.i18nCode;
    }

    @Override
    @NotNull
    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    @Override
    @NotNull
    public String getI18nHint() {
        return this.i18nHint;
    }

    @Contract(value="_ -> this")
    public I18nString setI18nHint(String i18nHint) {
        this.i18nHint = i18nHint == null ? "" : i18nHint;
        return this;
    }

    @Transient
    @Nullable
    public String getI18nCache() {
        return this.i18nCache;
    }

    @Transient
    @Contract(value="_->this")
    public I18nString setI18nCache(String i18nCache) {
        this.i18nCache = i18nCache;
        return this;
    }

    @Transient
    public boolean isEmpty() {
        return this.i18nCode.isEmpty();
    }

    @Override
    public void applyLocale(Locale locale, @NotNull I18nAware.I18nSource source) {
        this.i18nCache = this.toString(locale, source);
    }

    public String toString() {
        if (this.i18nCache != null) {
            return this.i18nCache;
        }
        return this.toString(Locale.getDefault());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof I18nString)) {
            return false;
        }
        I18nString that = (I18nString)o;
        return Objects.equals(this.i18nCode, that.i18nCode) && Arrays.equals(this.i18nArgs, that.i18nArgs);
    }

    public int hashCode() {
        int result = Objects.hash(this.i18nCode);
        result = 31 * result + Arrays.hashCode(this.i18nArgs);
        return result;
    }

    public static I18nString of(String str) {
        return new I18nString(str);
    }

    public static I18nString of(@NotNull I18nAware i18n) {
        return new I18nString(i18n.getI18nCode(), i18n.getI18nHint(), i18n.getI18nArgs());
    }
}

