/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.time.ThreadNow;

public class ZoneIdResolver {
    private static final Map<String, String> ZONE_IDS = new HashMap<String, String>();

    protected ZoneIdResolver() {
    }

    @NotNull
    public static ZoneId zoneId(@NotNull String tag) {
        try {
            return ZoneId.of(ZoneIdResolver.standard(tag));
        }
        catch (Exception e) {
            return ThreadNow.sysZoneId();
        }
    }

    @NotNull
    public static TimeZone timeZone(@NotNull String tag) {
        try {
            return TimeZone.getTimeZone(ZoneIdResolver.standard(tag));
        }
        catch (Exception e) {
            return TimeZone.getTimeZone(ThreadNow.sysZoneId());
        }
    }

    private static String standard(String tag) {
        String s = ZONE_IDS.get(tag);
        if (s != null) {
            return tag;
        }
        String up = tag.toUpperCase();
        for (Map.Entry<String, String> entry : ZONE_IDS.entrySet()) {
            if (!entry.getValue().contains(up)) continue;
            return entry.getKey();
        }
        return tag;
    }

    static {
        for (String id : TimeZone.getAvailableIDs()) {
            ZONE_IDS.put(id, id.toUpperCase());
        }
    }
}

