/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.id;

import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.id.LightIdUtil;

public class LightId {
    public static final LightId NONE = new LightId(-1, -1L);
    public static final LightId ZERO = new LightId(0, 0L);
    public static final int BIT_LIGHT = 55;
    public static final int BIT_BLOCK = 9;
    public static final int MIN_BLOCK = 0;
    public static final int MAX_BLOCK = 512;
    public static final int BIT_SEQ_WHOLE = 54;
    public static final int BIT_SEQ_BLOCK = 45;
    public static final long MIN_SEQ = 0L;
    public static final long MAX_SEQ_WHOLE = 0x3FFFFFFFFFFFFFL;
    public static final long MAX_SEQ_BLOCK = 0x1FFFFFFFFFFFL;
    public static final long TKN_LAYOUT = 0x40000000000000L;
    private final int block;
    private final long sequence;

    public LightId(int block, long sequence) {
        this.block = block;
        this.sequence = sequence;
    }

    public int getBlock() {
        return this.block;
    }

    public long getSequence() {
        return this.sequence;
    }

    public final int component1() {
        return this.block;
    }

    public final long component2() {
        return this.sequence;
    }

    public long toLong() {
        return LightIdUtil.toId(this.block, this.sequence);
    }

    @NotNull
    public String toString() {
        return "LightId(block=" + this.block + ", sequence=" + this.sequence + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightId)) {
            return false;
        }
        LightId lightId = (LightId)o;
        if (!(this.block >= 0 && this.sequence >= 0L || lightId.block >= 0 && lightId.sequence >= 0L)) {
            return true;
        }
        if (this.block != lightId.block) {
            return false;
        }
        return this.sequence == lightId.sequence;
    }

    public int hashCode() {
        if (this.block < 0 || this.sequence < 0L) {
            return -1;
        }
        int result = this.block;
        result = 31 * result + Long.hashCode(this.sequence);
        return result;
    }
}

