/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BalanceDecimal
implements Iterable<BigDecimal> {
    private final int size;
    private final int scale;
    private final BigDecimal total;
    private final BigDecimal precision;
    private final BigDecimal[] resultVal;

    public static BalanceDecimal of(BigDecimal total, List<BigDecimal> items) {
        return new BalanceDecimal(total, items, 2);
    }

    public static BalanceDecimal of(BigDecimal total, List<BigDecimal> items, int scale) {
        return new BalanceDecimal(total, items, scale);
    }

    private BalanceDecimal(BigDecimal total, List<BigDecimal> items, int scale) {
        this.size = items.size();
        this.scale = scale;
        this.total = total;
        this.precision = BigDecimal.ONE.divide(BigDecimal.TEN.pow(scale), scale, RoundingMode.FLOOR);
        this.resultVal = new BigDecimal[this.size];
        this.calcResultVal(items);
    }

    private void calcResultVal(List<BigDecimal> items) {
        Tuple2 t;
        BigDecimal percent;
        int cnt;
        BigDecimal sumOri = BigDecimal.ZERO;
        int idx = 0;
        for (BigDecimal v : items) {
            sumOri = sumOri.add(v);
            this.resultVal[idx++] = v;
        }
        int newScale = this.scale + 3;
        BigDecimal unit = this.total.divide(sumOri, newScale, RoundingMode.FLOOR);
        BigDecimal sumBal = BigDecimal.ZERO;
        for (int j = 0; j < this.size; ++j) {
            BigDecimal v = this.resultVal[j].multiply(unit).setScale(this.scale, RoundingMode.FLOOR);
            sumBal = sumBal.add(v);
            this.resultVal[j] = v;
        }
        BigDecimal remaining = this.total.subtract(sumBal);
        if (remaining.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal fixCount = remaining.divide(this.precision, RoundingMode.FLOOR);
        ArrayList<Tuple2<Integer, BigDecimal>> lhm = new ArrayList<Tuple2<Integer, BigDecimal>>(this.size);
        idx = 0;
        for (BigDecimal v : items) {
            lhm.add(new Tuple2<Integer, BigDecimal>(idx++, v));
        }
        lhm.sort((o1, o2) -> ((BigDecimal)((Tuple2)o2).t2).compareTo((BigDecimal)((Tuple2)o1).t2));
        int useCount = fixCount.intValue();
        int lastIndex = this.size - 1;
        for (int j = 0; j < this.size && (cnt = (percent = ((BigDecimal)(t = (Tuple2)lhm.get(j)).t2).divide(this.total, newScale, RoundingMode.CEILING)).multiply(fixCount).setScale(0, RoundingMode.CEILING).intValue()) != 0; ++j) {
            int i = (Integer)t.t1;
            if ((useCount -= cnt) <= 0 || j == lastIndex) {
                this.resultVal[i] = this.resultVal[i].add(this.precision.multiply(new BigDecimal(useCount + cnt)));
                break;
            }
            this.resultVal[i] = this.resultVal[i].add(this.precision.multiply(new BigDecimal(cnt)));
        }
    }

    @Override
    @NotNull
    public Iterator<BigDecimal> iterator() {
        return new Iterator<BigDecimal>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BalanceDecimal.this.resultVal.length;
            }

            @Override
            public BigDecimal next() {
                return BalanceDecimal.this.resultVal[this.index++];
            }
        };
    }

    public BigDecimal get(int i) {
        return this.resultVal[i];
    }

    public int size() {
        return this.size;
    }

    public BigDecimal total() {
        return this.total;
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal getPrecision() {
        return this.precision;
    }

    static class Tuple2<T1, T2> {
        private final T1 t1;
        private final T2 t2;

        public Tuple2(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }
    }
}

