/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

public class ComparableUtil {
    public static <T extends Comparable> T min(T a, T b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) < 0 ? a : b;
    }

    public static <T extends Comparable> T min(T a, T b, T ... c) {
        T r = ComparableUtil.min(a, b);
        if (c == null) {
            return r;
        }
        for (T t : c) {
            if (t == null || r != null && t.compareTo(r) >= 0) continue;
            r = t;
        }
        return r;
    }

    public static <T extends Comparable> T max(T a, T b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? a : b;
    }

    public static <T extends Comparable> T max(T a, T b, T ... c) {
        T r = ComparableUtil.max(a, b);
        if (c == null) {
            return r;
        }
        for (T t : c) {
            if (t == null || r != null && t.compareTo(r) <= 0) continue;
            r = t;
        }
        return r;
    }
}

