/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.best.AssertArgs;

public class RatioNumber {
    private final int oneKeep;
    private final int useKeep;
    public static final Ratio RateOneOne = new Ratio(1, 1);
    public static final RatioNumber NumberZero = new RatioNumber(0, 0);

    public static Ratio ratio(int oneRate, int useRate) {
        return new Ratio(oneRate, useRate);
    }

    public static RatioNumber number(int oneKeep, int useKeep) {
        return new RatioNumber(oneKeep, useKeep);
    }

    public RatioNumber(int oneKeep, int useKeep) {
        this.oneKeep = oneKeep;
        this.useKeep = useKeep;
    }

    public int getOneKeep() {
        return this.oneKeep;
    }

    public int getUseKeep() {
        return this.useKeep;
    }

    @Contract(value="_,_,_->new")
    public RatioNumber add(@NotNull RatioNumber num, Ratio ovu, Grade grd) {
        int oneNum = this.oneKeep + num.oneKeep;
        int useNum = this.useKeep + num.useKeep;
        return RatioNumber.grade(oneNum, useNum, ovu, grd);
    }

    @Contract(value="_,_,_->new")
    public RatioNumber sub(RatioNumber num, Ratio ovu, Grade grd) {
        int oneNum = this.oneKeep - num.oneKeep;
        int useNum = this.useKeep - num.useKeep;
        return RatioNumber.grade(oneNum, useNum, ovu, grd);
    }

    @Contract(value="_,_,_->new")
    public RatioNumber add(int dosage, Ratio ovu, Grade grd) {
        return RatioNumber.grade(this.oneKeep, this.useKeep + dosage, ovu, grd);
    }

    @Contract(value="_,_,_->new")
    public RatioNumber sub(int dosage, Ratio ovu, Grade grd) {
        return this.add(-dosage, ovu, grd);
    }

    @Contract(value="_->new")
    public RatioNumber grade(Ratio ovu) {
        return this.grade(ovu, Grade.Upgraded);
    }

    @Contract(value="_,_->new")
    public RatioNumber grade(Ratio ovu, Grade grd) {
        return RatioNumber.grade(this.oneKeep, this.useKeep, ovu, grd);
    }

    @Contract(value="_,_,_,_->new")
    public static RatioNumber grade(int oneNum, int useNum, Ratio ovu, Grade grd) {
        if (grd == null || grd == Grade.Isolated) {
            return RatioNumber.number(oneNum, useNum);
        }
        if (grd == Grade.Positive && oneNum > 0 && useNum > 0) {
            return RatioNumber.number(oneNum, useNum);
        }
        int oneRate = ovu.oneRate;
        int useRate = ovu.useRate;
        while (useNum <= 0) {
            oneNum -= oneRate;
            useNum += useRate;
        }
        if (grd == Grade.Upgraded && useNum > useRate) {
            int d = (useNum - 1) / useRate;
            oneNum += d * oneRate;
            useNum -= d * useRate;
        }
        return RatioNumber.number(oneNum, useNum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RatioNumber)) {
            return false;
        }
        RatioNumber that = (RatioNumber)o;
        return this.oneKeep == that.oneKeep && this.useKeep == that.useKeep;
    }

    public int hashCode() {
        return Objects.hash(this.oneKeep, this.useKeep);
    }

    public String toString() {
        return "RatioNumber(" + this.oneKeep + "." + this.useKeep + ")";
    }

    public static enum Grade {
        Isolated,
        Positive,
        Upgraded;

    }

    public static class Ratio {
        private final int oneRate;
        private final int useRate;

        public Ratio(int oneRate, int useRate) {
            AssertArgs.isTrue(oneRate > 0, "oneRate", "must > 0");
            AssertArgs.isTrue(useRate > 0, "useRate", "must > 0");
            this.oneRate = oneRate;
            this.useRate = useRate;
        }

        public int getOneRate() {
            return this.oneRate;
        }

        public int getUseRate() {
            return this.useRate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ratio)) {
                return false;
            }
            Ratio ratio = (Ratio)o;
            return this.oneRate == ratio.oneRate && this.useRate == ratio.useRate;
        }

        public int hashCode() {
            return Objects.hash(this.oneRate, this.useRate);
        }

        public String toString() {
            return "Ratio(" + this.oneRate + "/" + this.useRate + ")";
        }
    }
}

