/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.pain;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.CodeAware;
import pro.fessional.mirana.evil.TweakingContext;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.i18n.I18nAware;

public class CodeException
extends RuntimeException
implements I18nAware,
CodeAware {
    private static final long serialVersionUID = 19791023L;
    public static final boolean DefaultStack = false;
    public static final TweakingCodeException TweakStack = new TweakingCodeException(false);
    @NotNull
    private final String code;
    private final String i18nCode;
    private final Object[] i18nArgs;
    private String localizedMessage;

    public CodeException(boolean stack, @NotNull String code, String message, Object ... args) {
        super(message == null ? code : message, null, true, stack);
        this.code = code;
        this.i18nCode = code;
        this.i18nArgs = args;
    }

    public CodeException(@NotNull String code) {
        this(TweakStack.current(code, null, null), code, null, (Object[])null);
    }

    public CodeException(boolean stack, @NotNull String code) {
        this(stack, code, null, (Object[])null);
    }

    public CodeException(@NotNull String code, String message) {
        this(TweakStack.current(code, null, null), code, message, (Object[])null);
    }

    public CodeException(boolean stack, @NotNull String code, String message) {
        this(stack, code, message, (Object[])null);
    }

    public CodeException(@NotNull String code, String message, Object ... args) {
        this(TweakStack.current(code, null, null), code, message, args);
    }

    public CodeException(@NotNull CodeEnum code) {
        this(TweakStack.current(code, null, null), code.getCode(), code.getHint(), (Object[])null);
    }

    public CodeException(boolean stack, @NotNull CodeEnum code) {
        this(stack, code.getCode(), code.getHint(), (Object[])null);
    }

    public CodeException(@NotNull CodeEnum code, Object ... args) {
        this(TweakStack.current(code, null, null), code.getCode(), code.getHint(), args);
    }

    public CodeException(boolean stack, @NotNull CodeEnum code, Object ... args) {
        this(stack, code.getCode(), code.getHint(), args);
    }

    public CodeException(@NotNull Throwable cause, @NotNull String code, String message, Object ... args) {
        super(message, cause);
        this.code = code;
        this.i18nCode = code;
        this.i18nArgs = args;
    }

    public CodeException(@NotNull Throwable cause, @NotNull String code) {
        this(cause, code, null, (Object[])null);
    }

    public CodeException(@NotNull Throwable cause, @NotNull String code, String message) {
        this(cause, code, message, (Object[])null);
    }

    public CodeException(@NotNull Throwable cause, @NotNull CodeEnum code) {
        this(cause, code.getCode(), code.getHint(), (Object[])null);
    }

    public CodeException(@NotNull Throwable cause, @NotNull CodeEnum code, Object ... args) {
        this(cause, code.getCode(), code.getHint(), args);
    }

    @Override
    public String getMessage() {
        return this.localizedMessage != null ? this.localizedMessage : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage != null ? this.localizedMessage : super.getLocalizedMessage();
    }

    @Override
    public void applyLocale(Locale locale, @NotNull I18nAware.I18nSource source) {
        this.localizedMessage = this.toString(locale, source);
    }

    @Override
    @NotNull
    public String getCode() {
        return this.code;
    }

    @Override
    public String getI18nHint() {
        return this.getMessage();
    }

    @Override
    public String getI18nCode() {
        return this.i18nCode;
    }

    @Override
    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    public static class TweakingCodeException
    extends TweakingContext<Boolean> {
        public final ConcurrentHashMap<String, Boolean> tweakCode = new ConcurrentHashMap();
        public final ConcurrentHashMap<Class<? extends CodeException>, Boolean> tweakClass = new ConcurrentHashMap();

        public TweakingCodeException(boolean initDefault) {
            super(initDefault);
        }

        public boolean current(@Nullable String code, Class<? extends CodeException> claz, Boolean elze) {
            Boolean boolClaz;
            Boolean boolCode;
            Boolean bl = boolCode = code == null || code.isEmpty() ? null : this.tweakCode.get(code);
            if (boolCode != null) {
                return boolCode;
            }
            Boolean bl2 = boolClaz = claz == null ? null : this.tweakClass.get(claz);
            if (boolClaz != null) {
                return boolClaz;
            }
            return elze != null ? elze.booleanValue() : ((Boolean)TweakStack.current(true)).booleanValue();
        }

        public boolean current(@Nullable CodeEnum code, Class<? extends CodeException> claz, Boolean elze) {
            return this.current(code == null ? null : code.getCode(), claz, elze);
        }

        public void tweakCode(@NotNull String code, boolean stack) {
            this.tweakCode.put(code, stack);
        }

        public void tweakCode(@NotNull CodeEnum code, boolean stack) {
            this.tweakCode.put(code.getCode(), stack);
        }

        public void resetCode(@NotNull String code) {
            this.tweakCode.remove(code);
        }

        public void resetCode(@NotNull CodeEnum code) {
            this.tweakCode.remove(code.getCode());
        }

        public void tweakClass(@NotNull Class<? extends CodeException> claz, boolean stack) {
            this.tweakClass.put(claz, stack);
        }

        public void resetClass(@NotNull Class<? extends CodeException> claz) {
            this.tweakClass.remove(claz);
        }
    }
}

