/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.stat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LogStat {
    public static final String Suffix = ".scanned.tmp";
    public static final String SectionHead = "######### #";
    public static final String SectionWord = " KEYWORD: ";
    public static final String SectionFoot = " #########";
    public static final int Preview = 5;
    public static final int Section = 30;

    @NotNull
    public static Stat stat(String log, long from, String ... keys) {
        return LogStat.stat(log, from, 5, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, String ... keys) {
        return LogStat.stat(log, from, preview, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, int section, String ... keys) {
        Word[] words = new Word[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Word wd = new Word();
            wd.bytes = keys[i].getBytes(StandardCharsets.UTF_8);
            words[i] = wd;
        }
        return LogStat.stat(log, from, preview, section, words);
    }

    @NotNull
    public static Stat stat(String log, long from, byte[] ... keys) {
        return LogStat.stat(log, from, 5, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, byte[] ... keys) {
        return LogStat.stat(log, from, preview, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, int section, byte[] ... keys) {
        Word[] words = new Word[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Word wd = new Word();
            wd.bytes = keys[i];
            words[i] = wd;
        }
        return LogStat.stat(log, from, preview, section, words);
    }

    @NotNull
    public static Stat stat(String log, long from, Word ... keys) {
        return LogStat.stat(log, from, 5, 30, Arrays.asList(keys));
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, Word ... keys) {
        return LogStat.stat(log, from, preview, 30, Arrays.asList(keys));
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, int section, Word ... keys) {
        return LogStat.stat(log, from, preview, section, Arrays.asList(keys));
    }

    @NotNull
    public static Stat stat(String log, long from, Collection<? extends Word> keys) {
        return LogStat.stat(log, from, 5, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, Collection<? extends Word> keys) {
        return LogStat.stat(log, from, preview, 30, keys);
    }

    @NotNull
    public static Stat stat(String log, long from, int preview, int section, Collection<? extends Word> keys) {
        Stat stat;
        try {
            stat = LogStat.buildStat(log, from, keys, Suffix, preview, section);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stat;
    }

    public static List<String> clean(String log, int days) {
        return LogStat.clean(log, days, Suffix);
    }

    public static List<String> clean(String log, int days, String suffix) {
        long min;
        File file = new File(log);
        File dir = file.getParentFile();
        String pre = file.getName();
        if (dir == null) {
            return Collections.emptyList();
        }
        String suf = suffix == null || suffix.isEmpty() ? Suffix : suffix;
        File[] tmp = dir.listFiles(arg_0 -> LogStat.lambda$clean$0(pre, suf, min = days <= 0 ? System.currentTimeMillis() : System.currentTimeMillis() - (long)(days * 24 * 3600) * 1000L, arg_0));
        if (tmp == null || tmp.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> rst = new ArrayList<String>(tmp.length);
        for (File t : tmp) {
            if (!t.delete()) continue;
            rst.add(t.getAbsolutePath());
        }
        return rst;
    }

    public static Stat buildStat(String log, long from, Collection<? extends Word> keys) throws IOException {
        return LogStat.buildStat(log, from, keys, Suffix, 5, 30);
    }

    public static Stat buildStat(String log, long from, Collection<? extends Word> keys, String suffix) throws IOException {
        return LogStat.buildStat(log, from, keys, suffix, 5, 30);
    }

    public static Stat buildStat(String log, long from, Collection<? extends Word> keys, String suffix, int preview) throws IOException {
        return LogStat.buildStat(log, from, keys, suffix, preview, 30);
    }

    public static Stat buildStat(String log, long from, Collection<? extends Word> keys, String suffix, int preview, int section) throws IOException {
        long bgn = System.currentTimeMillis();
        Stat stat = new Stat();
        File ins = new File(log);
        long fln = ins.length();
        stat.logMtime = ins.lastModified();
        if (from < 0L) {
            from = fln + from;
        }
        if (from > fln || from < 0L) {
            from = 0L;
        }
        stat.pathLog = ins.getAbsolutePath();
        stat.byteFrom = from;
        if (fln == 0L || keys == null || keys.isEmpty()) {
            stat.byteDone = fln;
            stat.pathOut = null;
            stat.timeDone = bgn;
            stat.timeCost = 0L;
            return stat;
        }
        int keyMax = 0;
        for (Word word : keys) {
            if (word.bytes.length <= keyMax) continue;
            keyMax = word.bytes.length;
        }
        long done = from;
        if (suffix == null || suffix.isEmpty()) {
            suffix = Suffix;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
        String dts = df.format(LocalDateTime.now());
        File out = new File(stat.pathLog + "." + dts + suffix);
        int cap = 65536;
        int min = 16384;
        try (FileOutputStream fos = new FileOutputStream(out);
             RandomAccessFile raf = new RandomAccessFile(log, "r");){
            int readLen;
            raf.seek(from);
            byte[] buff = new byte[65536];
            int readOff = 0;
            int findLen = -1;
            int viewLen = 0;
            int sectLen = 0;
            int kwc = 1;
            Word lwd = null;
            byte[] kwh = SectionHead.getBytes();
            byte[] kwb = SectionWord.getBytes();
            byte[] kwt = SectionFoot.getBytes();
            while ((readLen = raf.read(buff, readOff, 65536 - readOff)) >= 0) {
                int left;
                int i;
                int readEnd = readOff + readLen;
                int lineEnd = 0;
                int n = i = findLen == -1 ? 0 : readOff;
                while (i < readEnd) {
                    block51: {
                        block50: {
                            if (buff[i] != 10) break block50;
                            int lb = lineEnd;
                            lineEnd = i + 1;
                            if (findLen <= 0) break block51;
                            int le = lineEnd - lb;
                            if (section > 0) {
                                if (buff[lb] == 32 || buff[lb] == 9) {
                                    if (--sectLen >= 0) {
                                        fos.write(buff, lb, le);
                                    } else {
                                        fos.write(46);
                                        fos.write(46);
                                        fos.write(46);
                                    }
                                } else {
                                    if (sectLen < 0) {
                                        fos.write(10);
                                    }
                                    sectLen = section;
                                    fos.write(buff, lb, le);
                                }
                            } else {
                                fos.write(buff, lb, le);
                            }
                            int n2 = ++viewLen;
                            --viewLen;
                            if (n2 > 0) break block51;
                            findLen = 0;
                            break block51;
                        }
                        int len = buff.length - i;
                        if (len >= keyMax) {
                            Word m = LogStat.find(buff, i, lineEnd, keys);
                            if (m != null) {
                                if (lwd == null || viewLen < 0 || !Arrays.equals(lwd.bytes, m.bytes)) {
                                    fos.write(kwh);
                                    fos.write(String.valueOf(kwc++).getBytes());
                                    fos.write(kwb);
                                    fos.write(m.bytes);
                                    fos.write(kwt);
                                    fos.write(10);
                                }
                                lwd = m;
                                findLen = m.bytes.length;
                                viewLen = preview;
                                i = i + findLen - 1;
                            }
                        } else if (findLen <= 0) {
                            findLen = -1;
                            break;
                        }
                    }
                    ++i;
                }
                if ((left = readEnd - lineEnd) == 0) {
                    readOff = 0;
                    done += (long)lineEnd;
                    continue;
                }
                if (left > 0) {
                    if (left > 16384) {
                        if (findLen >= 0) {
                            fos.write(buff, lineEnd, left);
                        }
                        readOff = 0;
                        done += (long)readEnd;
                        continue;
                    }
                    System.arraycopy(buff, 0, buff, lineEnd, left);
                    readOff = left;
                    done += (long)lineEnd;
                    continue;
                }
                throw new IllegalStateException("never here");
            }
        }
        if (out.length() > 0L) {
            stat.pathOut = out.getAbsolutePath();
        } else {
            stat.pathOut = null;
            out.delete();
        }
        stat.byteDone = done;
        stat.timeDone = System.currentTimeMillis();
        stat.timeCost = stat.timeDone - bgn;
        return stat;
    }

    private static Word find(byte[] buff, int pos, int pcr, Collection<? extends Word> keys) {
        int idx = pos - pcr;
        block0: for (Word word : keys) {
            if (word.range1 > idx || idx > word.range2) continue;
            byte[] bytes = word.bytes;
            for (int j = 0; j < bytes.length; ++j) {
                if (buff[pos + j] != bytes[j]) continue block0;
            }
            return word;
        }
        return null;
    }

    public static void main(String[] args) {
        Word[] wd;
        long from;
        if (args.length == 1 && "clean".equalsIgnoreCase(args[0])) {
            LogStat.clean("target/test-classes/log-stat.txt", -1);
            System.exit(0);
        }
        System.out.println("usage: log-file:File [byte-from:Long] [Word:String,rang1:int,rang2:int]");
        int aln = args.length;
        String log = aln > 0 ? args[0] : "target/test-classes/log-stat.txt";
        long l = from = aln > 1 ? Long.parseLong(args[1]) : 0L;
        if (aln > 2) {
            wd = new Word[aln - 2];
            for (int i = 2; i < aln; ++i) {
                Word w = new Word();
                String[] pt = args[i].split(",");
                if (pt.length == 3) {
                    w.bytes = pt[0].getBytes(StandardCharsets.UTF_8);
                    w.range1 = Integer.parseInt(pt[1]);
                    w.range2 = Integer.parseInt(pt[2]);
                } else {
                    w.bytes = args[i].getBytes(StandardCharsets.UTF_8);
                }
                wd[i - 2] = w;
            }
        } else {
            wd = new Word[2];
            wd[0] = new Word();
            wd[0].range2 = 60;
            wd[0].bytes = "WARN".getBytes(StandardCharsets.UTF_8);
            wd[1] = new Word();
            wd[1].range2 = 60;
            wd[1].bytes = "ERROR".getBytes(StandardCharsets.UTF_8);
        }
        long len = new File(log).length();
        Stat stat = LogStat.stat(log, from, wd);
        System.out.println("file=" + len + ", stat=" + stat.byteDone + ", eq=" + (len == stat.byteDone));
        System.out.println(stat);
    }

    private static /* synthetic */ boolean lambda$clean$0(String pre, String suf, long min, File fl) {
        String fn = fl.getName();
        return fn.startsWith(pre) && fn.endsWith(suf) && fl.lastModified() < min;
    }

    public static class Word {
        public int range1 = 0;
        public int range2 = Integer.MAX_VALUE;
        public byte[] bytes;
    }

    public static class Stat {
        private long timeDone = -1L;
        private long timeCost = -1L;
        private long logMtime = -1L;
        private long byteFrom = -1L;
        private long byteDone = -1L;
        private String pathLog = null;
        private String pathOut = null;

        public long getTimeDone() {
            return this.timeDone;
        }

        public long getTimeCost() {
            return this.timeCost;
        }

        public long getLogMtime() {
            return this.logMtime;
        }

        public long getByteFrom() {
            return this.byteFrom;
        }

        public long getByteDone() {
            return this.byteDone;
        }

        public String getPathLog() {
            return this.pathLog;
        }

        public String getPathOut() {
            return this.pathOut;
        }

        public long getByteGrow() {
            return this.byteDone - this.byteFrom;
        }

        public String toString() {
            return "Stat{timeDone=" + this.timeDone + ", timeCost=" + this.timeCost + ", logMtime=" + this.logMtime + ", byteFrom=" + this.byteFrom + ", byteDone=" + this.byteDone + ", pathLog='" + this.pathLog + '\'' + ", pathOut='" + this.pathOut + '\'' + '}';
        }
    }
}

