/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.text.BuilderHelper;
import pro.fessional.mirana.text.BuilderHolder;
import pro.fessional.mirana.text.FormatHolder;

public class FormatUtil {
    private static final BuilderHolder Holder;
    private static final ConcurrentHashMap<String, ArrayList<String>> Logback;
    private static final ConcurrentHashMap<String, FormatHolder> Formats;
    private static final ConcurrentHashMap<String, Integer> Printf;

    @NotNull
    public static String join(boolean skipNull, String joiner, Iterable<?> objs) {
        StringBuilder builder = (StringBuilder)Holder.use();
        BuilderHelper.join(builder, skipNull, joiner, objs);
        return builder.toString();
    }

    @NotNull
    public static String sortParam(@NotNull Map<?, ?> params) {
        return FormatUtil.sortParam(params, "&", "=");
    }

    @NotNull
    public static String sortParam(@NotNull Map<?, ?> param, @NotNull String join1, @NotNull String join2) {
        TreeMap sorted = param instanceof SortedMap ? (TreeMap)param : new TreeMap(param);
        StringBuilder builder = (StringBuilder)Holder.use();
        for (Map.Entry en : sorted.entrySet()) {
            Object value = en.getValue();
            if (value == null) continue;
            builder.append(join1);
            builder.append(en.getKey()).append(join2).append(value);
        }
        return builder.length() > 0 ? builder.substring(join1.length()) : "";
    }

    @NotNull
    public static String logback(CharSequence fmt, Object ... args) {
        if (fmt == null || fmt.length() == 0) {
            return "";
        }
        StringBuilder builder = (StringBuilder)Holder.use();
        ArrayList tmpl = Logback.computeIfAbsent(fmt.toString(), FormatUtil::parseLogback);
        int i = 0;
        for (String s : tmpl) {
            if (s == null) {
                Object arg = null;
                if (args != null && i < args.length) {
                    arg = args[i++];
                }
                builder.append(arg);
                continue;
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private static ArrayList<String> parseLogback(String fmt) {
        ArrayList<String> arr = new ArrayList<String>();
        boolean start = false;
        StringBuilder builder = new StringBuilder(fmt.length());
        int n = fmt.length();
        block5: for (int j = 0; j < n; ++j) {
            char c = fmt.charAt(j);
            switch (c) {
                case '{': {
                    if (start) {
                        builder.append('{');
                        continue block5;
                    }
                    start = true;
                    continue block5;
                }
                case '}': {
                    if (!start) {
                        builder.append('}');
                        continue block5;
                    }
                    start = false;
                    arr.add(builder.toString());
                    arr.add(null);
                    builder.setLength(0);
                    continue block5;
                }
                case '\\': {
                    char x;
                    if (start) {
                        start = false;
                        builder.append('{');
                    }
                    if (j + 1 >= n) {
                        builder.append(c);
                        continue block5;
                    }
                    if ((x = fmt.charAt(++j)) != '\\' && x != '{' && x != '}') {
                        builder.append(c);
                    }
                    builder.append(x);
                    continue block5;
                }
                default: {
                    if (start) {
                        start = false;
                        builder.append('{');
                    }
                    builder.append(c);
                }
            }
        }
        if (start) {
            builder.append('{');
        }
        if (builder.length() > 0) {
            arr.add(builder.toString());
        }
        return arr;
    }

    public static String message(CharSequence fmt, Object ... args) {
        if (fmt == null) {
            return "";
        }
        FormatHolder f = Formats.computeIfAbsent(fmt.toString(), p -> {
            try {
                return new FormatHolder((String)p);
            }
            catch (ThreadLocalAttention e) {
                throw new IllegalStateException(e);
            }
        });
        int size = f.argumentLength();
        MessageFormat format = (MessageFormat)f.use();
        return format.format(FormatUtil.fixArgs(size, args));
    }

    @NotNull
    public static String format(@PrintFormat String fmt, Object ... args) {
        if (fmt == null) {
            return "";
        }
        int size = Printf.computeIfAbsent(fmt, k -> {
            int[] count = FormatUtil.count((CharSequence)k, "%", "%%");
            return count[0] - count[1] * 2;
        });
        return String.format(fmt, FormatUtil.fixArgs(size, args));
    }

    public static String named(@NotNull String name, Object value) {
        return value == null ? name + ":" : name + ": " + value;
    }

    @NotNull
    public static Object[] fixArgs(int size, Object ... args) {
        if (size <= 0) {
            return Null.Objects;
        }
        if (args != null && args.length == size) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "";
            }
            return args;
        }
        Object[] tmp = new Object[size];
        if (args == null) {
            Arrays.fill(tmp, "");
        } else if (args.length > tmp.length) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = args[i] == null ? "" : args[i];
            }
        } else {
            int i;
            for (i = 0; i < args.length; ++i) {
                tmp[i] = args[i] == null ? "" : args[i];
            }
            for (i = args.length; i < tmp.length; ++i) {
                tmp[i] = "";
            }
        }
        return tmp;
    }

    @NotNull
    public static String leftFix(@Nullable Object obj, int fix, char pad) {
        String str = obj == null ? "" : obj.toString();
        int len = str.length();
        if (len == fix) {
            return str;
        }
        if (len > fix) {
            return str.substring(len - fix);
        }
        StringBuilder sb = new StringBuilder(fix);
        for (int i = fix - len; i > 0; --i) {
            sb.append(pad);
        }
        sb.append(str);
        return sb.toString();
    }

    @NotNull
    public static String rightFix(@Nullable Object obj, int fix, char pad) {
        String str = obj == null ? "" : obj.toString();
        int len = str.length();
        if (len == fix) {
            return str;
        }
        if (len > fix) {
            return str.substring(0, fix);
        }
        StringBuilder sb = new StringBuilder(fix);
        sb.append(str);
        for (int i = fix - len; i > 0; --i) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static int count(CharSequence src, String sub) {
        if (src == null || sub == null) {
            return 0;
        }
        return FormatUtil.count(null, src, sub)[0];
    }

    public static int[] count(CharSequence src, String ... sub) {
        return FormatUtil.count(null, src, sub);
    }

    public static int[] count(V viz, CharSequence src, String ... sub) {
        int len;
        if (sub == null) {
            return Null.Ints;
        }
        int[] ct = new int[sub.length];
        int n = len = src == null ? 0 : src.length();
        if (len == 0) {
            return ct;
        }
        int[] ix = new int[sub.length];
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            for (int j = 0; j < sub.length; ++j) {
                String s = sub[j];
                if (s == null || ix[j] < 0) continue;
                char r = s.charAt(ix[j]);
                if (c == r) {
                    ix[j] = ix[j] + 1;
                    int ln = s.length();
                    if (ln != ix[j]) continue;
                    ix[j] = 0;
                    ct[j] = ct[j] + 1;
                    if (viz == null || viz.visit(src, i - ln + 1, s, j)) continue;
                    ix[j] = -1;
                    continue;
                }
                if (ix[j] <= 0) continue;
                ix[j] = 0;
            }
        }
        return ct;
    }

    @NotNull
    public static String toString(boolean[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, boolean[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    @NotNull
    public static String toString(short[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, short[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    @NotNull
    public static String toString(int[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, int[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    @NotNull
    public static String toString(long[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, long[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    @NotNull
    public static String toString(float[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, float[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    @NotNull
    public static String toString(double[] arr) {
        StringBuilder buff = (StringBuilder)Holder.use();
        FormatUtil.toString(buff, arr);
        return buff.toString();
    }

    public static void toString(StringBuilder buff, double[] arr) {
        if (arr == null) {
            return;
        }
        buff.append('[');
        if (arr.length > 0) {
            buff.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                buff.append(',').append(arr[i]);
            }
        }
        buff.append(']');
    }

    static {
        try {
            Holder = new BuilderHolder();
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
        Logback = new ConcurrentHashMap();
        Formats = new ConcurrentHashMap();
        Printf = new ConcurrentHashMap();
    }

    public static interface V {
        public boolean visit(CharSequence var1, int var2, String var3, int var4);
    }
}

