/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.text.BuilderHolder;
import pro.fessional.mirana.text.FormatUtil;

public class JsonTemplate {
    private static final BuilderHolder Buffs;

    public static String obj(Consumer<Obj> fun) {
        return JsonTemplate.obj((StringBuilder)Buffs.use(), fun);
    }

    public static String obj(int capacity, Consumer<Obj> fun) {
        return JsonTemplate.obj(new StringBuilder(capacity), fun);
    }

    public static String obj(StringBuilder buff, Consumer<Obj> fun) {
        Obj obj = new Obj(buff);
        fun.accept(obj);
        obj.close();
        return buff.toString();
    }

    public static String arr(Consumer<Arr> fun) {
        return JsonTemplate.arr((StringBuilder)Buffs.use(), fun);
    }

    public static String arr(int capacity, Consumer<Arr> fun) {
        return JsonTemplate.arr(new StringBuilder(capacity), fun);
    }

    public static String arr(StringBuilder buff, Consumer<Arr> fun) {
        Arr arr = new Arr(buff);
        fun.accept(arr);
        arr.close();
        return buff.toString();
    }

    static {
        try {
            Buffs = new BuilderHolder();
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Arr
    extends Nod {
        private Arr(StringBuilder sb) {
            super(sb);
        }

        @Override
        protected void start() {
            this.buff.append('[');
        }

        @Override
        protected void close() {
            this.buff.append(']');
        }

        @Contract(value="_ -> this")
        public Arr addObj(Consumer<Obj> sub) {
            if (sub == null) {
                return this;
            }
            this.autoComma();
            Obj obj = new Obj(this.buff);
            sub.accept(obj);
            obj.close();
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addArr(Consumer<Arr> sub) {
            if (sub == null) {
                return this;
            }
            this.autoComma();
            Arr arr = new Arr(this.buff);
            sub.accept(arr);
            arr.close();
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addObj(Map<?, ?> kvs) {
            if (kvs == null) {
                return this;
            }
            this.autoComma();
            Obj obj = new Obj(this.buff);
            for (Map.Entry<?, ?> en : kvs.entrySet()) {
                Object k = en.getKey();
                Object v = en.getValue();
                if (k == null || v == null) continue;
                obj.putVal(k.toString(), v);
            }
            obj.close();
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addArr(Iterable<?> vs) {
            if (vs == null) {
                return this;
            }
            this.autoComma();
            Arr arr = new Arr(this.buff);
            arr.addVal(vs);
            arr.close();
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addVal(Iterable<?> vs) {
            if (vs == null) {
                return this;
            }
            for (Object v : vs) {
                this.addVal(v);
            }
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addVal(Object[] vs) {
            if (vs == null) {
                return this;
            }
            for (Object v : vs) {
                this.addVal(v);
            }
            return this;
        }

        @Contract(value="_ -> this")
        public Arr addVal(Object obj) {
            if (obj == null) {
                return this;
            }
            if (obj instanceof Map) {
                return this.addObj((Map)obj);
            }
            if (obj instanceof Collection) {
                return this.addArr((Iterable)obj);
            }
            if (obj instanceof Object[]) {
                return this.addArr(Arrays.asList((Object[])obj));
            }
            this.autoComma();
            this.autoValue(obj);
            return this;
        }
    }

    public static class Obj
    extends Nod {
        private Obj(StringBuilder sb) {
            super(sb);
        }

        @Override
        protected void start() {
            this.buff.append('{');
        }

        @Override
        protected void close() {
            this.buff.append('}');
        }

        @Contract(value="_, _ -> this")
        public Obj putObj(@NotNull String key, Consumer<Obj> sub) {
            if (sub == null) {
                return this;
            }
            this.autoComma();
            this.autoValue(key);
            this.autoColon();
            Obj obj = new Obj(this.buff);
            sub.accept(obj);
            obj.close();
            return this;
        }

        @Contract(value="_, _ -> this")
        public Obj putArr(@NotNull String key, Consumer<Arr> sub) {
            if (sub == null) {
                return this;
            }
            this.autoComma();
            this.autoValue(key);
            this.autoColon();
            Arr arr = new Arr(this.buff);
            sub.accept(arr);
            arr.close();
            return this;
        }

        @Contract(value="_ -> this")
        public Obj putObj(Map<?, ?> kvs) {
            if (kvs == null || kvs.isEmpty()) {
                return this;
            }
            for (Map.Entry<?, ?> en : kvs.entrySet()) {
                Object k = en.getKey();
                Object v = en.getValue();
                if (k == null || v == null) continue;
                this.putVal(k.toString(), v);
            }
            return this;
        }

        @Contract(value="_, _ -> this")
        public Obj putObj(@NotNull String key, Map<?, ?> kvs) {
            if (kvs == null) {
                return this;
            }
            this.autoComma();
            this.autoValue(key);
            this.autoColon();
            Obj obj = new Obj(this.buff);
            obj.putObj(kvs);
            obj.close();
            return this;
        }

        @Contract(value="_, _ -> this")
        public Obj putArr(@NotNull String key, Iterable<?> vs) {
            if (vs == null) {
                return this;
            }
            this.autoComma();
            this.autoValue(key);
            this.autoColon();
            Arr arr = new Arr(this.buff);
            for (Object v : vs) {
                arr.addVal(v);
            }
            arr.close();
            return this;
        }

        @Contract(value="_, _ -> this")
        public Obj putArr(@NotNull String key, Object[] vs) {
            if (vs == null) {
                return this;
            }
            return this.putArr(key, Arrays.asList(vs));
        }

        @Contract(value="_, _ -> this")
        public Obj putVal(@NotNull String key, Object obj) {
            if (obj == null) {
                return this;
            }
            if (obj instanceof Iterable) {
                return this.putArr(key, (Iterable)obj);
            }
            if (obj instanceof Map) {
                return this.putObj(key, (Map)obj);
            }
            if (obj instanceof Object[]) {
                return this.putArr(key, Arrays.asList((Object[])obj));
            }
            this.autoComma();
            this.autoValue(key);
            this.autoColon();
            this.autoValue(obj);
            return this;
        }
    }

    private static abstract class Nod {
        protected final StringBuilder buff;
        private boolean filled = false;

        protected Nod(StringBuilder sb) {
            this.buff = sb;
            this.start();
        }

        protected void autoValue(Object obj) {
            if (obj instanceof CharSequence) {
                this.buff.append('\"');
                CharSequence cs = (CharSequence)obj;
                int len = cs.length();
                for (int i = 0; i < len; ++i) {
                    char c = cs.charAt(i);
                    this.appendChar(c);
                }
                this.buff.append('\"');
            } else if (obj instanceof char[]) {
                this.buff.append('\"');
                for (char c : (char[])obj) {
                    this.appendChar(c);
                }
                this.buff.append('\"');
            } else if (obj instanceof byte[]) {
                this.buff.append('\"');
                this.buff.append(Base64.encode((byte[])obj));
                this.buff.append('\"');
            } else if (obj instanceof boolean[]) {
                FormatUtil.toString(this.buff, (boolean[])obj);
            } else if (obj instanceof short[]) {
                FormatUtil.toString(this.buff, (short[])obj);
            } else if (obj instanceof int[]) {
                FormatUtil.toString(this.buff, (int[])obj);
            } else if (obj instanceof long[]) {
                FormatUtil.toString(this.buff, (long[])obj);
            } else if (obj instanceof float[]) {
                FormatUtil.toString(this.buff, (float[])obj);
            } else if (obj instanceof double[]) {
                FormatUtil.toString(this.buff, (double[])obj);
            } else {
                this.buff.append(obj);
            }
        }

        private void appendChar(char c) {
            if (c == '\"' || c == '\\') {
                this.buff.append('\\').append(c);
            } else {
                this.buff.append(c);
            }
        }

        protected void autoComma() {
            if (this.filled) {
                this.buff.append(',');
            }
            this.filled = true;
        }

        protected void autoColon() {
            this.buff.append(':');
        }

        protected abstract void start();

        protected abstract void close();

        public String toString() {
            return this.buff.toString();
        }
    }
}

