/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.text.HalfCharUtil;
import pro.fessional.mirana.time.ThreadNow;

public class DateParser {
    public static final TemporalQuery<LocalTime> QueryTime = temporal -> {
        if (temporal instanceof LocalTime) {
            return (LocalTime)temporal;
        }
        if (temporal.isSupported(ChronoField.NANO_OF_DAY)) {
            return LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY));
        }
        if (temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
            int m = 0;
            if (temporal.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                m = temporal.get(ChronoField.MINUTE_OF_HOUR);
            }
            int s = 0;
            if (temporal.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                s = temporal.get(ChronoField.SECOND_OF_MINUTE);
            }
            int n = 0;
            if (temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                n = temporal.get(ChronoField.NANO_OF_SECOND);
            } else if (temporal.isSupported(ChronoField.MILLI_OF_SECOND)) {
                n = temporal.get(ChronoField.MILLI_OF_SECOND) * 1000000;
            }
            return LocalTime.of(temporal.get(ChronoField.HOUR_OF_DAY), m, s, n);
        }
        return null;
    };
    public static final TemporalQuery<LocalDate> QueryDate = temporal -> {
        if (temporal instanceof LocalDate) {
            return (LocalDate)temporal;
        }
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            return LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
        }
        if (temporal.isSupported(ChronoField.YEAR)) {
            int m = 1;
            if (temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
                m = temporal.get(ChronoField.MONTH_OF_YEAR);
            }
            int d = 1;
            if (temporal.isSupported(ChronoField.DAY_OF_MONTH)) {
                d = temporal.get(ChronoField.DAY_OF_MONTH);
            }
            return LocalDate.of(temporal.get(ChronoField.YEAR), m, d);
        }
        return null;
    };
    public static final TemporalQuery<LocalDateTime> QueryDateTime = temporal -> {
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDateTime();
        }
        LocalDate date = QueryDate.queryFrom(temporal);
        if (date == null) {
            return null;
        }
        LocalTime time = QueryTime.queryFrom(temporal);
        if (time == null) {
            time = LocalTime.of(0, 0);
        }
        return LocalDateTime.of(date, time);
    };

    @NotNull
    public static LocalTime parseTime(@NotNull CharSequence num) {
        return DateParser.parseTime(num, 0);
    }

    @NotNull
    public static LocalDate parseDate(@NotNull CharSequence num) {
        return DateParser.parseDate(num, 0);
    }

    @NotNull
    public static Date parseUtilDate(@NotNull CharSequence num) {
        return DateParser.parseUtilDate(num, 0);
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull CharSequence num) {
        return DateParser.parseDateTime(num, 0);
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull CharSequence str) {
        return DateParser.parseZoned(str, null, 0);
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull CharSequence str, ZoneId zid) {
        return DateParser.parseZoned(str, zid, 0);
    }

    @NotNull
    public static LocalTime parseTime(@NotNull CharSequence str, Iterable<DateTimeFormatter> dtf) {
        TemporalAccessor ta = DateParser.parseTemporal(str, dtf, false);
        LocalTime dt = ta.query(QueryTime);
        if (dt == null) {
            throw new DateTimeException("Unable to obtain LocalTime " + ta + " of type " + ta.getClass().getName());
        }
        return dt;
    }

    @NotNull
    public static LocalDate parseDate(@NotNull CharSequence str, Iterable<DateTimeFormatter> dtf) {
        TemporalAccessor ta = DateParser.parseTemporal(str, dtf, false);
        LocalDate dt = ta.query(QueryDate);
        if (dt == null) {
            throw new DateTimeException("Unable to obtain LocalDate " + ta + " of type " + ta.getClass().getName());
        }
        return dt;
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull CharSequence str, Iterable<DateTimeFormatter> dtf) {
        TemporalAccessor ta = DateParser.parseTemporal(str, dtf, false);
        LocalDateTime dt = ta.query(QueryDateTime);
        if (dt == null) {
            throw new DateTimeException("Unable to obtain LocalDateTime " + ta + " of type " + ta.getClass().getName());
        }
        return dt;
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull TemporalAccessor ta, ZoneId zid) {
        if (ta instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)ta;
            return zid == null ? zdt : zdt.withZoneSameInstant(zid);
        }
        if (ta instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)ta;
            return zid == null ? odt.toZonedDateTime() : odt.atZoneSameInstant(zid);
        }
        LocalDateTime ldt = ta.query(QueryDateTime);
        ZoneId z = ta.query(TemporalQueries.zone());
        return DateParser.concatZoned(ldt, z, zid);
    }

    @NotNull
    private static ZonedDateTime concatZoned(LocalDateTime ldt, ZoneId may, ZoneId zid) {
        if (may == null) {
            if (zid == null) {
                return ZonedDateTime.of(ldt, ThreadNow.sysZoneId());
            }
            return ZonedDateTime.of(ldt, zid);
        }
        if (zid == null) {
            return ZonedDateTime.of(ldt, may);
        }
        return ZonedDateTime.of(ldt, may).withZoneSameInstant(zid);
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull CharSequence str, ZoneId zid, Iterable<DateTimeFormatter> dtf) {
        TemporalAccessor ta = DateParser.parseTemporal(str, dtf, false);
        return DateParser.parseZoned(ta, zid);
    }

    @NotNull
    public static OffsetDateTime parseOffset(@NotNull TemporalAccessor ta, ZoneId zid) {
        if (ta instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)ta;
            if (zid == null) {
                return zdt.toOffsetDateTime();
            }
            return zdt.withZoneSameInstant(zid).toOffsetDateTime();
        }
        if (ta instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)ta;
            if (zid == null) {
                return odt;
            }
            return odt.atZoneSameInstant(zid).toOffsetDateTime();
        }
        LocalDateTime ldt = ta.query(QueryDateTime);
        ZoneOffset zof = ta.query(TemporalQueries.offset());
        if (zof != null) {
            OffsetDateTime odt = OffsetDateTime.of(ldt, zof);
            if (zid == null) {
                return odt;
            }
            return odt.atZoneSameInstant(zid).toOffsetDateTime();
        }
        ZoneId z = ta.query(TemporalQueries.zone());
        return DateParser.concatZoned(ldt, z, zid).toOffsetDateTime();
    }

    @NotNull
    public static OffsetDateTime parseOffset(@NotNull CharSequence str, ZoneId zid, Iterable<DateTimeFormatter> dtf) {
        TemporalAccessor ta = DateParser.parseTemporal(str, dtf, false);
        return DateParser.parseOffset(ta, zid);
    }

    @NotNull
    public static LocalTime parseTime(@NotNull CharSequence str, DateTimeFormatter ... dtf) {
        return DateParser.parseTime(str, Arrays.asList(dtf));
    }

    @NotNull
    public static LocalDate parseDate(@NotNull CharSequence str, DateTimeFormatter ... dtf) {
        return DateParser.parseDate(str, Arrays.asList(dtf));
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull CharSequence str, DateTimeFormatter ... dtf) {
        return DateParser.parseDateTime(str, Arrays.asList(dtf));
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull CharSequence str, ZoneId zid, DateTimeFormatter ... dtf) {
        return DateParser.parseZoned(str, zid, Arrays.asList(dtf));
    }

    @NotNull
    public static OffsetDateTime parseOffset(@NotNull CharSequence str, ZoneId zid, DateTimeFormatter ... dtf) {
        return DateParser.parseOffset(str, zid, Arrays.asList(dtf));
    }

    @NotNull
    public static LocalTime parseTime(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.TIME);
        int len = num.length();
        if (len != 6 && len != 9) {
            throw new DateTimeException("only support time6,time9 format, but " + num);
        }
        return DateParser.time(num, 0);
    }

    @NotNull
    public static LocalDate parseDate(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.DATE);
        int len = num.length();
        if (len != 8) {
            throw new DateTimeException("only support date8 format, but " + num);
        }
        return DateParser.date(num);
    }

    @NotNull
    public static Date parseUtilDate(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.FULL);
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(num.substring(0, 4)));
        cal.set(2, Integer.parseInt(num.substring(4, 6)) - 1);
        cal.set(5, Integer.parseInt(num.substring(6, 8)));
        cal.set(11, Integer.parseInt(num.substring(8, 10)));
        cal.set(12, Integer.parseInt(num.substring(10, 12)));
        cal.set(13, Integer.parseInt(num.substring(12, 14)));
        cal.set(14, Integer.parseInt(num.substring(14)));
        return cal.getTime();
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.FULL);
        int len = num.length();
        if (len != 14 && len != 17) {
            throw new DateTimeException("only support datetime14,datetime17 format, but " + num);
        }
        LocalDate ld = DateParser.date(num);
        LocalTime lt = DateParser.time(num, 8);
        return LocalDateTime.of(ld, lt);
    }

    @NotNull
    public static ZonedDateTime parseZoned(@NotNull CharSequence str, ZoneId zid, int off) {
        String ptn = DateParser.digit(str, off, Ptn.ZONE);
        int ztk = 0;
        if (ptn.length() > 14 && ptn.charAt(14) == '@') {
            ztk = 14;
        } else if (ptn.length() > 17 && ptn.charAt(17) == '@') {
            ztk = 17;
        }
        if (ztk != 14 && ztk != 17) {
            throw new DateTimeException("only support datetime14, datetime17 format, but " + ptn);
        }
        String num = ptn.substring(0, ztk);
        String zzz = ptn.substring(ztk + 1);
        ZoneId z = DateParser.zid(zzz);
        LocalDateTime ldt = LocalDateTime.of(DateParser.date(num), DateParser.time(num, 8));
        return DateParser.concatZoned(ldt, z, zid);
    }

    @Contract(value="_,_,false->!null")
    public static TemporalAccessor parseTemporal(@NotNull CharSequence str, @NotNull Iterable<DateTimeFormatter> dtf, boolean quiet) {
        QuietPos best = null;
        for (QuietPos qp : DateParser.parseTemporal(dtf, str, true)) {
            if (best == null) {
                best = qp;
                continue;
            }
            TemporalAccessor ta = qp.getTemporal();
            if (best.getTemporal() == null && ta != null) {
                best = qp;
                continue;
            }
            int ix = qp.getIndex();
            if (best.getIndex() >= ix) continue;
            best = qp;
        }
        if (best == null) {
            if (quiet) {
                return null;
            }
            throw new DateTimeParseException("can not apply any Formatter to parse", str, -1);
        }
        TemporalAccessor tp = best.getTemporal();
        if (tp == null) {
            if (quiet) {
                return null;
            }
            RuntimeException ex = best.getException();
            if (ex != null) {
                throw ex;
            }
            String message = best.getFormatter().toString();
            throw new DateTimeParseException(message, str, best.getErrorIndexReal());
        }
        return tp;
    }

    @NotNull
    public static List<QuietPos> parseTemporal(@NotNull Iterable<DateTimeFormatter> dtf, @NotNull CharSequence str, boolean stopOnSuccess) {
        ArrayList<QuietPos> result = new ArrayList<QuietPos>();
        for (DateTimeFormatter ft : dtf) {
            QuietPos pos = new QuietPos(0);
            pos.formatter = ft;
            try {
                pos.temporal = ft.parse(str, pos);
            }
            catch (RuntimeException e) {
                pos.exception = e;
            }
            result.add(pos);
            if (!stopOnSuccess || pos.temporal == null || pos.getErrorIndexReal() >= 0) continue;
            break;
        }
        return result;
    }

    @NotNull
    public static String digit(@Nullable CharSequence str, int off, Ptn ptn) {
        if (str == null) {
            return "";
        }
        int idx = 0;
        StringBuilder[] buff = new StringBuilder[ptn.pad.length];
        buff[idx] = new StringBuilder(ptn.len);
        int cnt = 0;
        int nan = 0;
        int len = str.length();
        for (int chi = 0; chi < len && cnt - off < ptn.len; ++chi) {
            char c = HalfCharUtil.half(str.charAt(chi));
            if (c >= '0' && c <= '9') {
                if (++cnt <= off) continue;
                buff[idx].append(c);
                nan = 1;
                continue;
            }
            if (nan == 1 && idx < ptn.pad.length - 1) {
                buff[++idx] = new StringBuilder(ptn.len);
                nan = 2;
            }
            if (ptn == Ptn.ZONE && idx > 3 && (c == ' ' || c == '\t' || c != ':' && DateParser.isZidChar(c))) break;
        }
        if (ptn != Ptn.TIME && idx >= 2 && buff[1].length() <= 2 && DateParser.isMonth(buff[0]) && !DateParser.isMonth(buff[2])) {
            StringBuilder tp = buff[2];
            buff[2] = buff[1];
            buff[1] = buff[0];
            buff[0] = tp;
        }
        for (int i = 0; i < ptn.pad.length; ++i) {
            if (i <= idx) {
                int sln;
                int cln = buff[i].length();
                if (cln == (sln = ptn.pad[i].length())) continue;
                if (cln > sln) break;
                boolean az = true;
                for (int j = 0; j < cln; ++j) {
                    if (buff[i].charAt(j) == '0') continue;
                    az = false;
                    break;
                }
                if (az) {
                    buff[i].replace(0, cln, ptn.pad[i]);
                    continue;
                }
                buff[i].insert(0, ptn.pad[i], 0, sln - cln);
                continue;
            }
            buff[idx].append(ptn.pad[i]);
        }
        StringBuilder sb = buff[0];
        for (int i = 1; i <= idx; ++i) {
            sb.append((CharSequence)buff[i]);
        }
        if (sb.length() > ptn.len) {
            sb.setLength(ptn.len);
        }
        if (ptn == Ptn.ZONE) {
            sb.append('@');
            boolean spc = false;
            for (int i = chi; i < len; ++i) {
                char c = str.charAt(i);
                if (DateParser.isZidChar(c)) {
                    sb.append(c);
                    spc = true;
                    continue;
                }
                if (spc) break;
            }
        }
        return sb.toString();
    }

    public static boolean isZidChar(char c) {
        return c == '+' || c == '-' || c == ':' || c == '/' || c == '[' || c == ']' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static ZoneId zid(String str) {
        try {
            int p1 = str.indexOf(91);
            if (p1 >= 0) {
                int p2 = str.indexOf(93, p1);
                if (p2 > p1) {
                    return ZoneId.of(str.substring(p1 + 1, p2));
                }
                return ZoneId.of(str.substring(p1 + 1));
            }
            return ZoneId.of(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isMonth(CharSequence str) {
        int len = str.length();
        if (len == 1) {
            char c = str.charAt(0);
            return c >= '1' && c <= '9';
        }
        if (len == 2) {
            char c1 = str.charAt(0);
            char c2 = str.charAt(1);
            if (c1 == '0' && c2 >= '1' && c2 <= '9') {
                return true;
            }
            return c1 == '1' && c2 >= '0' && c2 <= '2';
        }
        return false;
    }

    private static LocalDate date(String num) {
        int y = Integer.parseInt(num.substring(0, 4));
        int m = Integer.parseInt(num.substring(4, 6));
        int d = Integer.parseInt(num.substring(6, 8));
        return LocalDate.of(y, m, d);
    }

    private static LocalTime time(String num, int off) {
        int h = Integer.parseInt(num.substring(off, off + 2));
        int m = Integer.parseInt(num.substring(off + 2, off + 4));
        int s = Integer.parseInt(num.substring(off + 4, off + 6));
        int n = num.length() - off <= 6 ? 0 : Integer.parseInt(num.substring(off + 6)) * 1000000;
        return LocalTime.of(h, m, s, n);
    }

    public static enum Ptn {
        DATE(8, new String[]{"2000", "01", "01"}),
        TIME(9, new String[]{"00", "00", "00", "000"}),
        FULL(17, new String[]{"2000", "01", "01", "00", "00", "00", "000"}),
        ZONE(17, new String[]{"2000", "01", "01", "00", "00", "00", "000"});

        final int len;
        final String[] pad;

        private Ptn(int len, String[] pad) {
            this.len = len;
            this.pad = pad;
        }
    }

    public static class QuietPos
    extends ParsePosition {
        private TemporalAccessor temporal;
        private DateTimeFormatter formatter;
        private RuntimeException exception;
        private int error;

        public QuietPos(int index) {
            super(index);
        }

        public int getErrorIndexReal() {
            return this.error;
        }

        public TemporalAccessor getTemporal() {
            return this.temporal;
        }

        public DateTimeFormatter getFormatter() {
            return this.formatter;
        }

        public RuntimeException getException() {
            return this.exception;
        }

        @Override
        public void setErrorIndex(int ei) {
            this.error = ei;
        }

        @Override
        public int getErrorIndex() {
            return -1;
        }
    }
}

