/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.tk;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public interface Ticket
extends Serializable {
    public static final char Sep1 = '-';
    public static final char Sep2 = '~';

    @NotNull
    public String getPubMod();

    public long getPubDue();

    public int getPubSeq();

    @NotNull
    public String getBizPart();

    @NotNull
    public String getSigPart();

    @NotNull
    default public String getSigData() {
        String biz = this.getBizPart();
        if (biz.isEmpty()) {
            return this.getPubMod() + '-' + this.getPubDue() + '-' + this.getPubSeq();
        }
        return this.getPubMod() + '-' + this.getPubDue() + '-' + this.getPubSeq() + '~' + biz;
    }

    @NotNull
    default public String serialize() {
        return this.serialize('-', '~');
    }

    @NotNull
    default public String serialize(char sep1, char sep2) {
        String mod = this.getPubMod();
        String sig = this.getSigPart();
        if (mod.isEmpty() || sig.isEmpty()) {
            throw new IllegalStateException("sig-part or pub-mod is empty");
        }
        String biz = this.getBizPart();
        StringBuilder sb = new StringBuilder(biz.length() + 100);
        sb.append(mod);
        sb.append(sep1).append(this.getPubDue());
        sb.append(sep1).append(this.getPubSeq());
        if (!biz.isEmpty()) {
            sb.append(sep2).append(biz);
        }
        sb.append(sep2).append(sig);
        return sb.toString();
    }

    public static interface Mutable
    extends Ticket {
        public void setPubMod(String var1);

        public void setPubDue(long var1);

        public void setPubSeq(int var1);

        public void setBizPart(String var1);

        public void setSigPart(String var1);

        default public void copyPart(Ticket tk) {
            if (tk == null) {
                return;
            }
            this.setPubMod(tk.getPubMod());
            this.setPubDue(tk.getPubDue());
            this.setPubSeq(tk.getPubSeq());
            this.setBizPart(tk.getBizPart());
            this.setSigPart(tk.getSigPart());
        }
    }
}

