/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.math.AnyIntegerUtil;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.flywave.SchemaRevisionManager;
import pro.fessional.wings.faceless.flywave.WingsRevision;
import pro.fessional.wings.faceless.util.FlywaveRevisionScanner;

public class RevisionFitness {
    private static final Logger log = LoggerFactory.getLogger(RevisionFitness.class);
    public static final Long UnInit = -1L;
    private final Set<String> scanPath = new HashSet<String>();
    private final TreeMap<Long, Set<Act>> reviAct = new TreeMap();
    private final HashMap<Long, Set<String>> reviMsg = new HashMap();

    public void addFit(Fit fit, String msg) {
        if (fit == null) {
            return;
        }
        Act act = fit.getLost();
        if (act == null || act == Act.SKIP) {
            log.info("skip fit {}", (Object)msg);
            return;
        }
        Set<String> path = fit.path;
        if (path != null) {
            this.scanPath.addAll(path);
        }
        Set<String> revi = fit.getRevi();
        for (String str : revi) {
            Long r = AnyIntegerUtil.obj64((CharSequence)str);
            this.reviAct.computeIfAbsent(r, ignored -> new HashSet()).add(act);
            this.reviMsg.computeIfAbsent(r, ignored -> new HashSet()).add(msg);
        }
        log.info("found fit {}. `wings.faceless.flywave.fit[{}].lost=SKIP` to skip", revi, (Object)msg);
    }

    public void addFits(Map<String, Fit> fits) {
        for (Map.Entry<String, Fit> ent : fits.entrySet()) {
            this.addFit(ent.getValue(), ent.getKey());
        }
    }

    public void checkRevision(SchemaRevisionManager revisionManager, boolean autoInit) {
        revisionManager.askWay(ignored -> true);
        revisionManager.logWay((ignored1, ignored2) -> {});
        TreeMap<Long, Set<Act>> revi = this.checkUnapply(revisionManager);
        this.applyRevision(revisionManager, revi, autoInit);
    }

    private void applyRevision(SchemaRevisionManager manager, TreeMap<Long, Set<Act>> revi, boolean autoInit) {
        boolean bl;
        TreeMap<Object, Set<String>> exec = new TreeMap<Object, Set<String>>();
        boolean failed = false;
        if (revi.containsKey(UnInit)) {
            for (Set set : revi.values()) {
                if (autoInit || !set.contains((Object)Act.EXEC)) continue;
                throw new IllegalStateException("\nWings `flywave revision` do NOT exist, and Auto Init is dangerous, you can,\n1.stop checker: `wings.faceless.flywave.checker=false`\n2.revision fitness do NOT contain `EXEC`\n3.init `flywave revision` manually\n4.auto-init: `wings.faceless.flywave.auto-init=true` At Your Own Risk\n");
            }
            revi.remove(UnInit);
        }
        for (Map.Entry entry : revi.entrySet()) {
            Long rv = (Long)entry.getKey();
            Set set = (Set)entry.getValue();
            Set<String> ms = this.reviMsg.get(rv);
            if (set.contains((Object)Act.WARN)) {
                log.warn("Wings Revision Lost revi={}. Manual={}", (Object)rv, (Object)this.manual(ms));
            }
            if (set.contains((Object)Act.FAIL)) {
                log.error("Wings Revision Lost revi={}. Manual={}", (Object)rv, (Object)this.manual(ms));
                failed = true;
            }
            if (!set.contains((Object)Act.EXEC)) continue;
            exec.put(rv, ms);
        }
        if (failed) {
            throw new IllegalStateException("Wings Revision Lost revi need FAIL");
        }
        if (exec.isEmpty()) {
            return;
        }
        SortedMap<Long, SchemaRevisionManager.RevisionSql> scan = FlywaveRevisionScanner.scan(this.scanPath);
        boolean bl2 = false;
        for (Map.Entry entry : exec.entrySet()) {
            Long rv = (Long)entry.getKey();
            Set ms = (Set)entry.getValue();
            SchemaRevisionManager.RevisionSql sql = (SchemaRevisionManager.RevisionSql)scan.get(rv);
            if (sql != null) continue;
            log.error("Wings Revision Lost And Failed to Scan. revi={} by={}", (Object)rv, (Object)ms);
            bl = true;
        }
        if (bl) {
            throw new IllegalStateException("Wings Revision Lost And Failed");
        }
        long cid = -ThreadNow.millis();
        for (Map.Entry en : exec.entrySet()) {
            Long rv = (Long)en.getKey();
            Set ms = (Set)en.getValue();
            SchemaRevisionManager.RevisionSql sql = (SchemaRevisionManager.RevisionSql)scan.get(rv);
            if (rv.longValue() == WingsRevision.V00_19_0512_01_Schema.revision()) {
                TreeMap<Long, SchemaRevisionManager.RevisionSql> init = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
                init.put(rv, sql);
                log.info("Wings Revision force to init revi={}, cid={}, by={}", new Object[]{rv, cid, ms});
                manager.checkAndInitSql(init, cid, true);
                continue;
            }
            manager.forceUpdateSql(sql, cid);
            log.info("Wings Revision force to apply revi={}, cid={}, by={}", new Object[]{rv, cid, ms});
            manager.forceApplyBreak(rv, cid, true, null);
        }
    }

    private String manual(Set<String> ms) {
        StringBuilder sb = new StringBuilder();
        sb.append("replace XXX with SKIP to skip, EXEC to exec sqls: ");
        for (String m : ms) {
            sb.append("\nwings.faceless.flywave.fit.").append(m).append(".lost=XXX");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<Long, Set<Act>> checkUnapply(SchemaRevisionManager manager) {
        HashMap reviStatus = null;
        HashMap<Long, Map> reviDbDiff = new HashMap<Long, Map>();
        Object headDb = "";
        boolean unInit = false;
        for (Map.Entry<String, SortedMap<Long, SchemaRevisionManager.Status>> en : manager.statusRevisions().entrySet()) {
            Map diff;
            void var9_10;
            String nextDb = en.getKey();
            log.debug("Wings Revision Check Database={}", (Object)nextDb);
            Map map = en.getValue();
            if (map == null) {
                unInit = true;
                Map<Long, SchemaRevisionManager.Status> map2 = Map.of(UnInit, SchemaRevisionManager.Status.Future);
            }
            if (reviStatus == null) {
                reviStatus = new HashMap(var9_10);
                headDb = nextDb;
                continue;
            }
            HashMap headStatus = new HashMap(reviStatus);
            HashMap<Long, SchemaRevisionManager.Status> nextStatus = new HashMap<Long, SchemaRevisionManager.Status>();
            for (Map.Entry entry : var9_10.entrySet()) {
                Long rv = (Long)entry.getKey();
                SchemaRevisionManager.Status rs = (SchemaRevisionManager.Status)((Object)entry.getValue());
                if (rs == headStatus.get(rv)) {
                    headStatus.remove(rv);
                    continue;
                }
                nextStatus.put(rv, rs);
            }
            for (Map.Entry entry : headStatus.entrySet()) {
                diff = reviDbDiff.computeIfAbsent((Long)entry.getKey(), ignored -> new LinkedHashMap());
                diff.put(headDb, (SchemaRevisionManager.Status)((Object)entry.getValue()));
            }
            for (Map.Entry entry : nextStatus.entrySet()) {
                diff = reviDbDiff.computeIfAbsent((Long)entry.getKey(), ignored -> new LinkedHashMap());
                diff.put(nextDb, (SchemaRevisionManager.Status)((Object)entry.getValue()));
            }
        }
        if (reviStatus == null || reviStatus.isEmpty()) {
            if (unInit) {
                log.warn("Wings Revision UnInit all-revi");
                TreeMap<Long, Set<Act>> map = new TreeMap<Long, Set<Act>>((SortedMap<Long, Set<Act>>)this.reviAct);
                map.put(UnInit, Set.of(Act.WARN));
                return map;
            }
            log.info("Wings Revision Unapply all-revi");
            return this.reviAct;
        }
        StringBuilder diffWarn = new StringBuilder();
        boolean needFail = false;
        for (Map.Entry entry : reviDbDiff.entrySet()) {
            Long rv = (Long)entry.getKey();
            Set<Act> acts = this.reviAct.get(rv);
            diffWarn.append("\nWARN Diff-Revi=").append(rv);
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                diffWarn.append(", ").append((String)entry2.getKey()).append('=').append(entry2.getValue());
            }
            if (acts == null || needFail || !acts.contains((Object)Act.FAIL)) continue;
            needFail = true;
        }
        if (!diffWarn.isEmpty()) {
            if (needFail) {
                throw new IllegalStateException("Wings Revision Diff Schemas Found:" + String.valueOf(diffWarn));
            }
            log.warn("Wings Revision Diff Schemas Found:" + String.valueOf(diffWarn));
        }
        TreeMap<Long, Set<Act>> map = new TreeMap<Long, Set<Act>>();
        for (Map.Entry<Long, Set<Act>> revi : this.reviAct.entrySet()) {
            Long rv = revi.getKey();
            SchemaRevisionManager.Status st = (SchemaRevisionManager.Status)((Object)reviStatus.get(rv));
            if (st == SchemaRevisionManager.Status.Applied) continue;
            map.put(rv, revi.getValue());
            log.info("Wings Revision Unapply revi={}, status={}", (Object)rv, (Object)st);
        }
        if (unInit) {
            log.warn("Wings Revision UnInit all-revi");
            map.put(UnInit, Set.of(Act.WARN));
            return map;
        }
        return map;
    }

    public static class Fit {
        private Set<String> path = Collections.emptySet();
        private Set<String> revi = Collections.emptySet();
        private Act lost = Act.WARN;

        public Set<String> getPath() {
            return this.path;
        }

        public Set<String> getRevi() {
            return this.revi;
        }

        public Act getLost() {
            return this.lost;
        }

        public void setPath(Set<String> path) {
            this.path = path;
        }

        public void setRevi(Set<String> revi) {
            this.revi = revi;
        }

        public void setLost(Act lost) {
            this.lost = lost;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fit)) {
                return false;
            }
            Fit other = (Fit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$path = this.getPath();
            Set<String> other$path = other.getPath();
            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                return false;
            }
            Set<String> this$revi = this.getRevi();
            Set<String> other$revi = other.getRevi();
            if (this$revi == null ? other$revi != null : !((Object)this$revi).equals(other$revi)) {
                return false;
            }
            Act this$lost = this.getLost();
            Act other$lost = other.getLost();
            return !(this$lost == null ? other$lost != null : !((Object)((Object)this$lost)).equals((Object)other$lost));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Fit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            Set<String> $revi = this.getRevi();
            result = result * 59 + ($revi == null ? 43 : ((Object)$revi).hashCode());
            Act $lost = this.getLost();
            result = result * 59 + ($lost == null ? 43 : ((Object)((Object)$lost)).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "RevisionFitness.Fit(path=" + String.valueOf(this.getPath()) + ", revi=" + String.valueOf(this.getRevi()) + ", lost=" + String.valueOf((Object)this.getLost()) + ")";
        }
    }

    public static enum Act {
        SKIP,
        WARN,
        FAIL,
        EXEC;

    }
}

