/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave.impl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.faceless.database.helper.DatabaseChecker;
import pro.fessional.wings.faceless.flywave.SchemaDefinitionLoader;
import pro.fessional.wings.faceless.flywave.util.SimpleJdbcTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpro/fessional/wings/faceless/flywave/impl/MysqlDefinitionLoader;", "Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader;", "()V", "h2database", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljavax/sql/DataSource;", "", "diffBoneSame", "", "dataSource", "table", "other", "types", "", "diffFullSame", "diffTable", "bone", "isH2Database", "makeDdlTrg", "trg", "Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader$Trg;", "drop", "showBoneCol", "", "showBoneTrg", "showFullDdl", "showPkeyCol", "showTables", "faceless-flywave"})
public final class MysqlDefinitionLoader
implements SchemaDefinitionLoader {
    @NotNull
    private final ConcurrentHashMap<DataSource, Boolean> h2database = new ConcurrentHashMap();

    public final boolean isH2Database(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Boolean bl = this.h2database.computeIfAbsent(dataSource, arg_0 -> MysqlDefinitionLoader.isH2Database$lambda$0((Function1)new Function1<DataSource, Boolean>(dataSource){
            final /* synthetic */ DataSource $dataSource;
            {
                this.$dataSource = $dataSource;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DataSource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DatabaseChecker.isH2((DataSource)this.$dataSource);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    @Override
    @NotNull
    public List<String> showTables(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        LinkedList<String> list = new LinkedList<String>();
        new SimpleJdbcTemplate(dataSource, null, 2, null).query("SHOW TABLES", new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(list){
            final /* synthetic */ LinkedList<String> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$list.add(it.getString(1));
            }
        }));
        return list;
    }

    @Override
    @NotNull
    public List<String> showFullDdl(@NotNull DataSource dataSource, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        LinkedList<String> rst = new LinkedList<String>();
        SimpleJdbcTemplate tmpl = new SimpleJdbcTemplate(dataSource, null, 2, null);
        if (this.isH2Database(dataSource)) {
            tmpl.query("SCRIPT NODATA NOPASSWORDS NOSETTINGS TABLE " + table, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
                final /* synthetic */ LinkedList<String> $rst;
                {
                    this.$rst = $rst;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String s = it.getString(1);
                    Intrinsics.checkNotNull((Object)s);
                    if (StringsKt.startsWith((String)s, (String)"CREATE CACHED TABLE ", (boolean)true) || StringsKt.startsWith((String)s, (String)"CREATE TABLE ", (boolean)true) || StringsKt.startsWith((String)s, (String)"CREATE MEMORY TABLE ", (boolean)true)) {
                        this.$rst.add(s);
                    }
                }
            }));
            return rst;
        }
        tmpl.query("SHOW CREATE TABLE " + table, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
            final /* synthetic */ LinkedList<String> $rst;
            {
                this.$rst = $rst;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$rst.add(it.getString(2));
            }
        }));
        Object[] objectArray = new Object[]{table};
        tmpl.query("\n            SELECT\n                TRIGGER_NAME,\n                ACTION_TIMING,\n                EVENT_MANIPULATION,\n                ACTION_STATEMENT\n            FROM\n                INFORMATION_SCHEMA.TRIGGERS\n            WHERE\n                EVENT_OBJECT_SCHEMA = database()\n                AND EVENT_OBJECT_TABLE=?\n        ", objectArray, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst, table){
            final /* synthetic */ LinkedList<String> $rst;
            final /* synthetic */ String $table;
            {
                this.$rst = $rst;
                this.$table = $table;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String n = it.getString("TRIGGER_NAME");
                String t = it.getString("ACTION_TIMING");
                String e = it.getString("EVENT_MANIPULATION");
                String s = it.getString("ACTION_STATEMENT");
                this.$rst.add("CREATE TRIGGER `" + n + "` " + t + " " + e + " ON `" + this.$table + "` FOR EACH ROW " + s);
            }
        }));
        return rst;
    }

    @Override
    @NotNull
    public String diffBoneSame(@NotNull DataSource dataSource, @NotNull String table, @NotNull String other, int types) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.diffTable(dataSource, table, other, types, true);
    }

    @Override
    @NotNull
    public String diffFullSame(@NotNull DataSource dataSource, @NotNull String table, @NotNull String other, int types) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.diffTable(dataSource, table, other, types, false);
    }

    private final String diffTable(DataSource dataSource, String table, String other, int types, boolean bone) {
        Object[] objectArray;
        StringBuilder diff = new StringBuilder();
        SimpleJdbcTemplate tmpl = new SimpleJdbcTemplate(dataSource, null, 2, null);
        if (this.isH2Database(dataSource)) {
            if ((types & 1) != 0) {
                Set s21;
                Set t2;
                Set t1 = CollectionsKt.toSet((Iterable)this.showBoneCol(dataSource, table));
                Set s12 = SetsKt.minus((Set)t1, (Iterable)(t2 = CollectionsKt.toSet((Iterable)this.showBoneCol(dataSource, other))));
                if (!((Collection)s12).isEmpty()) {
                    diff.append("\nCOL@");
                    diff.append(table).append(".");
                    diff.append(CollectionsKt.joinToString$default((Iterable)s12, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                }
                if (!((Collection)(s21 = SetsKt.minus((Set)t2, (Iterable)t1))).isEmpty()) {
                    diff.append("\nCOL@");
                    diff.append(other).append(".");
                    diff.append(CollectionsKt.joinToString$default((Iterable)s21, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                }
            }
            String string = diff.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if ((types & 1) != 0) {
            String cols = bone ? "COLUMN_NAME, COLUMN_TYPE, COLUMN_COMMENT, ORDINAL_POSITION" : "COLUMN_NAME, COLUMN_TYPE, COLUMN_COMMENT, ORDINAL_POSITION, IS_NULLABLE, COLUMN_DEFAULT";
            Object[] objectArray2 = new Object[]{table, other};
            tmpl.query("\n            SELECT\n                " + cols + " ,\n                GROUP_CONCAT(TABLE_NAME) as TBL_NAME,\n                COUNT(1) SAME_COUNT\n            FROM\n                INFORMATION_SCHEMA.COLUMNS\n            WHERE\n                TABLE_SCHEMA = database()\n                AND TABLE_NAME IN (?, ?)\n            GROUP BY " + cols + "\n            HAVING SAME_COUNT != 2\n            ", objectArray2, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(diff, bone){
                final /* synthetic */ StringBuilder $diff;
                final /* synthetic */ boolean $bone;
                {
                    this.$diff = $diff;
                    this.$bone = $bone;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$diff.append("\nCOL@");
                    this.$diff.append(it.getString("TBL_NAME")).append(".");
                    this.$diff.append(it.getString("COLUMN_NAME")).append("=");
                    this.$diff.append(it.getString("COLUMN_TYPE")).append(",");
                    this.$diff.append(it.getString("COLUMN_COMMENT")).append(",");
                    this.$diff.append(it.getString("ORDINAL_POSITION")).append(",");
                    if (!this.$bone) {
                        String nullable = it.getString("IS_NULLABLE");
                        if (it.wasNull()) {
                            nullable = "<NULL>";
                        }
                        this.$diff.append(nullable).append(",");
                        this.$diff.append(it.getString("COLUMN_DEFAULT"));
                    }
                }
            }));
        }
        if ((types & 2) != 0) {
            objectArray = new Object[]{table, other};
            tmpl.query("\n            SELECT\n                INDEX_NAME, NON_UNIQUE, SEQ_IN_INDEX, COLUMN_NAME, INDEX_TYPE,\n                GROUP_CONCAT(TABLE_NAME) as TBL_NAME,\n                COUNT(1) SAME_COUNT\n            FROM\n                INFORMATION_SCHEMA.STATISTICS\n            WHERE\n                TABLE_SCHEMA = database()\n                AND TABLE_NAME IN (?, ?)\n            GROUP BY INDEX_NAME, NON_UNIQUE, SEQ_IN_INDEX, COLUMN_NAME, INDEX_TYPE\n            HAVING SAME_COUNT != 2\n            ", objectArray, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(diff){
                final /* synthetic */ StringBuilder $diff;
                {
                    this.$diff = $diff;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$diff.append("\nIDX@");
                    this.$diff.append(it.getString("TBL_NAME")).append(".");
                    this.$diff.append(it.getString("INDEX_NAME")).append("=");
                    this.$diff.append(it.getString("NON_UNIQUE")).append(",");
                    this.$diff.append(it.getString("SEQ_IN_INDEX")).append(",");
                    this.$diff.append(it.getString("COLUMN_NAME")).append(",");
                    this.$diff.append(it.getString("INDEX_TYPE"));
                }
            }));
        }
        if ((types & 4) != 0) {
            objectArray = new Object[]{table, other};
            tmpl.query("\n            SELECT\n                TRIGGER_NAME, ACTION_TIMING, EVENT_MANIPULATION, ACTION_STATEMENT,\n                GROUP_CONCAT(EVENT_OBJECT_TABLE) as TBL_NAME,\n                COUNT(1) SAME_COUNT\n            FROM\n                INFORMATION_SCHEMA.TRIGGERS\n            WHERE\n                EVENT_OBJECT_SCHEMA = database()\n                AND EVENT_OBJECT_TABLE IN (?, ?)\n            GROUP BY TRIGGER_NAME, ACTION_TIMING, EVENT_MANIPULATION, ACTION_STATEMENT\n            HAVING SAME_COUNT != 2\n            ", objectArray, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(diff){
                final /* synthetic */ StringBuilder $diff;
                {
                    this.$diff = $diff;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$diff.append("\nTRG@");
                    this.$diff.append(it.getString("TBL_NAME")).append(".");
                    this.$diff.append(it.getString("TRIGGER_NAME")).append("=");
                    this.$diff.append(it.getString("ACTION_TIMING")).append(",");
                    this.$diff.append(it.getString("EVENT_MANIPULATION")).append(",");
                    this.$diff.append(it.getString("ACTION_STATEMENT"));
                }
            }));
        }
        String string = diff.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public List<String> showBoneCol(@NotNull DataSource dataSource, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        LinkedList<String> rst = new LinkedList<String>();
        if (this.isH2Database(dataSource)) {
            new SimpleJdbcTemplate(dataSource, null, 2, null).query("SHOW COLUMNS FROM " + table, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
                final /* synthetic */ LinkedList<String> $rst;
                {
                    this.$rst = $rst;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String n = it.getString("FIELD");
                    String t = it.getString("TYPE");
                    this.$rst.add("`" + n + "` " + t + " COMMENT ''");
                }
            }));
            return rst;
        }
        Object[] objectArray = new Object[]{table};
        new SimpleJdbcTemplate(dataSource, null, 2, null).query("\n        SELECT\n            COLUMN_NAME,\n            COLUMN_TYPE,\n            COLUMN_COMMENT,\n            ORDINAL_POSITION\n        FROM\n            INFORMATION_SCHEMA.COLUMNS\n        WHERE\n            TABLE_SCHEMA = database()\n            AND TABLE_NAME = ?\n            ORDER BY ORDINAL_POSITION ASC\n        ", objectArray, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
            final /* synthetic */ LinkedList<String> $rst;
            {
                this.$rst = $rst;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String n = it.getString("COLUMN_NAME");
                String t = it.getString("COLUMN_TYPE");
                String string = it.getString("COLUMN_COMMENT");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String c = StringsKt.replace$default((String)string, (String)"'", (String)"\\'", (boolean)false, (int)4, null);
                this.$rst.add("`" + n + "` " + t + " COMMENT '" + c + "'");
            }
        }));
        return rst;
    }

    @Override
    @NotNull
    public List<String> showPkeyCol(@NotNull DataSource dataSource, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        LinkedList<String> rst = new LinkedList<String>();
        if (this.isH2Database(dataSource)) {
            new SimpleJdbcTemplate(dataSource, null, 2, null).query("SHOW COLUMNS FROM " + table, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
                final /* synthetic */ LinkedList<String> $rst;
                {
                    this.$rst = $rst;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String t = it.getString("KEY");
                    Intrinsics.checkNotNull((Object)t);
                    if (!StringsKt.isBlank((CharSequence)t)) {
                        this.$rst.add(it.getString("FIELD"));
                    }
                }
            }));
            return rst;
        }
        new SimpleJdbcTemplate(dataSource, null, 2, null).query("\n        SHOW KEYS FROM " + table + " WHERE KEY_NAME = 'PRIMARY'\n        ", new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst){
            final /* synthetic */ LinkedList<String> $rst;
            {
                this.$rst = $rst;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$rst.add(it.getString("COLUMN_NAME"));
            }
        }));
        return rst;
    }

    @Override
    @NotNull
    public List<SchemaDefinitionLoader.Trg> showBoneTrg(@NotNull DataSource dataSource, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ArrayList<SchemaDefinitionLoader.Trg> rst = new ArrayList<SchemaDefinitionLoader.Trg>();
        if (this.isH2Database(dataSource)) {
            return rst;
        }
        Object[] objectArray = new Object[]{table};
        new SimpleJdbcTemplate(dataSource, null, 2, null).query("\n            SELECT\n                TRIGGER_NAME,\n                ACTION_TIMING,\n                EVENT_MANIPULATION,\n                ACTION_STATEMENT\n            FROM\n                INFORMATION_SCHEMA.TRIGGERS\n            WHERE\n                EVENT_OBJECT_SCHEMA = database()\n                AND EVENT_OBJECT_TABLE = ?\n            ", objectArray, (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(rst, table){
            final /* synthetic */ ArrayList<SchemaDefinitionLoader.Trg> $rst;
            final /* synthetic */ String $table;
            {
                this.$rst = $rst;
                this.$table = $table;
                super(1);
            }

            public final void invoke(@NotNull ResultSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getString("TRIGGER_NAME");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String string2 = it.getString("ACTION_TIMING");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = it.getString("EVENT_MANIPULATION");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                String string4 = it.getString("ACTION_STATEMENT");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                this.$rst.add(new SchemaDefinitionLoader.Trg(string, string2, string3, string4, this.$table));
            }
        }));
        return rst;
    }

    @Override
    @NotNull
    public String makeDdlTrg(@NotNull SchemaDefinitionLoader.Trg trg, boolean drop) {
        Intrinsics.checkNotNullParameter((Object)trg, (String)"trg");
        return drop ? "DROP TRIGGER IF EXISTS " + trg.getName() : "CREATE TRIGGER " + trg.getName() + " " + trg.getTiming() + " " + trg.getAction() + " ON " + trg.getTable() + " FOR EACH ROW " + trg.getEvent();
    }

    private static final Boolean isH2Database$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

