/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.faceless.flywave.SchemaDefinitionLoader;
import pro.fessional.wings.faceless.flywave.SqlStatementParser;
import pro.fessional.wings.faceless.flywave.util.SimpleJdbcTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152$\b\u0002\u0010\u0016\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00130\u0017j\u0002`\u0019J:\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152$\b\u0002\u0010\u0016\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00130\u0017j\u0002`\u0019J\u001c\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013J\u001c\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager;", "", "sqlStatementParser", "Lpro/fessional/wings/faceless/flywave/SqlStatementParser;", "schemaDefinitionLoader", "Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader;", "(Lpro/fessional/wings/faceless/flywave/SqlStatementParser;Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "appendRevision", "", "result", "Ljava/util/ArrayList;", "Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlString;", "Lkotlin/collections/ArrayList;", "tmpl", "Lpro/fessional/wings/faceless/flywave/util/SimpleJdbcTemplate;", "dumpDdl", "", "database", "Ljavax/sql/DataSource;", "filterSorter", "Lkotlin/Function1;", "", "Lpro/fessional/wings/faceless/flywave/FilterSorter;", "dumpRec", "saveFile", "file", "Ljava/io/File;", "sqls", "path", "Companion", "SqlString", "SqlType", "faceless-flywave"})
public final class SchemaFulldumpManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SqlStatementParser sqlStatementParser;
    @NotNull
    private final SchemaDefinitionLoader schemaDefinitionLoader;
    private final Logger log;
    @NotNull
    public static final String prefix = "--";
    @JvmField
    @NotNull
    public static final Function1<List<String>, List<String>> excludeShadow;

    public SchemaFulldumpManager(@NotNull SqlStatementParser sqlStatementParser, @NotNull SchemaDefinitionLoader schemaDefinitionLoader) {
        Intrinsics.checkNotNullParameter((Object)sqlStatementParser, (String)"sqlStatementParser");
        Intrinsics.checkNotNullParameter((Object)schemaDefinitionLoader, (String)"schemaDefinitionLoader");
        this.sqlStatementParser = sqlStatementParser;
        this.schemaDefinitionLoader = schemaDefinitionLoader;
        this.log = LoggerFactory.getLogger(SchemaFulldumpManager.class);
    }

    public final void saveFile(@NotNull String path, @NotNull List<SqlString> sqls) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
        this.saveFile(new File(path), sqls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveFile(@NotNull File file, @NotNull List<SqlString> sqls) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
        file.getParentFile().mkdirs();
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter buf = (BufferedWriter)object;
            boolean bl = false;
            ArrayList<SqlString> trgs = new ArrayList<SqlString>();
            block9: for (SqlString sql : sqls) {
                switch (WhenMappings.$EnumSwitchMapping$0[sql.getSqlType().ordinal()]) {
                    case 1: {
                        buf.write(sql.getSqlText());
                        buf.write("\n\n");
                        continue block9;
                    }
                    case 2: {
                        trgs.add(sql);
                        continue block9;
                    }
                }
                buf.write("-- " + sql.getTable() + " " + sql.getSqlType());
                buf.write("\n");
                buf.write(sql.getSqlText() + ";");
                buf.write("\n\n");
            }
            if (!((Collection)trgs).isEmpty()) {
                buf.write("-- TRIGGER");
                buf.write("\n\n");
                buf.write("DELIMITER $$");
                buf.write("\n\n");
                for (SqlString sql : trgs) {
                    buf.write("-- " + sql.getTable() + " " + sql.getSqlType() + "\n" + sql.getSqlText() + " $$\n\n");
                }
                buf.write("DELIMITER ;\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public final List<SqlString> dumpDdl(@NotNull DataSource database, @NotNull Function1<? super List<String>, ? extends List<String>> filterSorter) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(filterSorter, (String)"filterSorter");
        ArrayList<SqlString> result = new ArrayList<SqlString>();
        this.appendRevision(result, new SimpleJdbcTemplate(database, null, 2, null));
        Regex ddlTableReg = new Regex("CREATE\\s+TABLE\\s+", RegexOption.IGNORE_CASE);
        Regex ddlTriggerReg = new Regex("CREATE\\s+TRIGGER\\s+", RegexOption.IGNORE_CASE);
        List<String> tables = this.schemaDefinitionLoader.showTables(database);
        for (String table : (List)filterSorter.invoke(tables)) {
            if (StringsKt.startsWith$default((String)table, (String)prefix, (boolean)false, (int)2, null)) {
                this.log.info("[dumpDdl] insert comment, {}", (Object)table);
                result.add(new SqlString(table, SqlType.StrComment, ((Object)StringsKt.trim((CharSequence)table)).toString()));
                continue;
            }
            this.log.info("[dumpDdl] dump ddls for table={}", (Object)table);
            List<String> ddls = this.schemaDefinitionLoader.showFullDdl(database, table);
            for (String ddl : ddls) {
                String sql = ((Object)StringsKt.trim((CharSequence)ddl)).toString();
                if (ddlTableReg.containsMatchIn((CharSequence)sql)) {
                    result.add(new SqlString(table, SqlType.DdlTable, sql));
                    continue;
                }
                if (ddlTriggerReg.containsMatchIn((CharSequence)sql)) {
                    result.add(new SqlString(table, SqlType.DdlTrigger, sql));
                    continue;
                }
                result.add(new SqlString(table, SqlType.SqlUnknown, sql));
            }
        }
        return result;
    }

    public static /* synthetic */ List dumpDdl$default(SchemaFulldumpManager schemaFulldumpManager, DataSource dataSource, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = excludeShadow;
        }
        return schemaFulldumpManager.dumpDdl(dataSource, function1);
    }

    @NotNull
    public final List<SqlString> dumpRec(@NotNull DataSource database, @NotNull Function1<? super List<String>, ? extends List<String>> filterSorter) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(filterSorter, (String)"filterSorter");
        ArrayList<SqlString> result = new ArrayList<SqlString>();
        SimpleJdbcTemplate tmpl = new SimpleJdbcTemplate(database, null, 2, null);
        this.appendRevision(result, tmpl);
        List<String> tables = this.schemaDefinitionLoader.showTables(database);
        StringBuilder builder = new StringBuilder();
        for (String table : (List)filterSorter.invoke(tables)) {
            if (StringsKt.startsWith$default((String)table, (String)prefix, (boolean)false, (int)2, null)) {
                this.log.info("[dumpRec] insert comment, {}", (Object)table);
                result.add(new SqlString(table, SqlType.StrComment, ((Object)StringsKt.trim((CharSequence)table)).toString()));
                continue;
            }
            this.log.info("[dumpRec] dump record for table={}", (Object)table);
            String tbl = this.sqlStatementParser.safeName(table);
            Ref.BooleanRef ist = new Ref.BooleanRef();
            ist.element = true;
            tmpl.query("select * from " + tbl, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(ist, builder, tbl, this){
                final /* synthetic */ Ref.BooleanRef $ist;
                final /* synthetic */ StringBuilder $builder;
                final /* synthetic */ String $tbl;
                final /* synthetic */ SchemaFulldumpManager this$0;
                {
                    this.$ist = $ist;
                    this.$builder = $builder;
                    this.$tbl = $tbl;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet rs) {
                    Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                    ResultSetMetaData meta = rs.getMetaData();
                    int cnt = meta.getColumnCount();
                    if (this.$ist.element) {
                        this.$builder.append("INSERT INTO ").append(this.$tbl);
                        CollectionsKt.joinTo$default((Iterable)((Iterable)new IntRange(1, cnt)), (Appendable)this.$builder, (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this.this$0, meta){
                            final /* synthetic */ SchemaFulldumpManager this$0;
                            final /* synthetic */ ResultSetMetaData $meta;
                            {
                                this.this$0 = $receiver;
                                this.$meta = $meta;
                                super(1);
                            }

                            @NotNull
                            public final CharSequence invoke(int it) {
                                SqlStatementParser sqlStatementParser = SchemaFulldumpManager.access$getSqlStatementParser$p(this.this$0);
                                String string = this.$meta.getColumnName(it);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColumnName(...)");
                                return sqlStatementParser.safeName(string);
                            }
                        }), (int)48, null);
                        this.$builder.append(" VALUES \n");
                        this.$ist.element = false;
                    }
                    CollectionsKt.joinTo$default((Iterable)((Iterable)new IntRange(1, cnt)), (Appendable)this.$builder, (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this.this$0, rs){
                        final /* synthetic */ SchemaFulldumpManager this$0;
                        final /* synthetic */ ResultSet $rs;
                        {
                            this.this$0 = $receiver;
                            this.$rs = $rs;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(int it) {
                            return SchemaFulldumpManager.access$getSqlStatementParser$p(this.this$0).safeValue(this.$rs.getObject(it));
                        }
                    }), (int)48, null);
                    this.$builder.append(",\n");
                }
            }));
            if (builder.length() <= 2) continue;
            String string = builder.substring(0, builder.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new SqlString(table, SqlType.DmlInsert, string));
            StringsKt.clear((StringBuilder)builder);
        }
        return result;
    }

    public static /* synthetic */ List dumpRec$default(SchemaFulldumpManager schemaFulldumpManager, DataSource dataSource, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = excludeShadow;
        }
        return schemaFulldumpManager.dumpRec(dataSource, function1);
    }

    private final void appendRevision(ArrayList<SqlString> result, SimpleJdbcTemplate tmpl) {
        try {
            tmpl.query("SELECT revision, apply_dt FROM sys_schema_version WHERE apply_dt >'1000-01-01' order by revision desc limit 1", new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(result){
                final /* synthetic */ ArrayList<SqlString> $result;
                {
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StringBuilder sb = new StringBuilder();
                    sb.append("--");
                    sb.append(" revision=");
                    sb.append(it.getString("revision"));
                    sb.append(", apply_dt=");
                    sb.append(it.getString("apply_dt"));
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    this.$result.add(new SqlString("", SqlType.StrComment, string));
                }
            }));
        }
        catch (Exception e) {
            this.log.warn("[getRevision] failed to revision", (Throwable)e);
        }
    }

    @JvmStatic
    @NotNull
    public static final Function1<List<String>, List<String>> excludeRegexp(String ... regex) {
        return Companion.excludeRegexp(regex);
    }

    @JvmStatic
    @NotNull
    public static final Function1<List<String>, List<String>> includeRegexp(String ... regex) {
        return Companion.includeRegexp(regex);
    }

    @JvmStatic
    @NotNull
    public static final Function1<List<String>, List<String>> groupedTable(boolean only, String ... table) {
        return Companion.groupedTable(only, table);
    }

    @JvmStatic
    @NotNull
    public static final Function1<List<String>, List<String>> groupedRegexp(boolean only, String ... regexp) {
        return Companion.groupedRegexp(only, regexp);
    }

    public static final /* synthetic */ SqlStatementParser access$getSqlStatementParser$p(SchemaFulldumpManager $this) {
        return $this.sqlStatementParser;
    }

    static {
        String[] stringArray = new String[]{".*_\\d+$", ".*\\$\\w+$"};
        excludeShadow = Companion.excludeRegexp(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\t\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u0002`\u00072\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\fJG\u0010\r\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u0002`\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0011JG\u0010\u0012\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u0002`\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0011J=\u0010\u0014\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u0002`\u00072\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\fR,\u0010\u0003\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u0002`\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$Companion;", "", "()V", "excludeShadow", "Lkotlin/Function1;", "", "", "Lpro/fessional/wings/faceless/flywave/FilterSorter;", "prefix", "excludeRegexp", "regex", "", "([Ljava/lang/String;)Lkotlin/jvm/functions/Function1;", "groupedRegexp", "only", "", "regexp", "(Z[Ljava/lang/String;)Lkotlin/jvm/functions/Function1;", "groupedTable", "table", "includeRegexp", "faceless-flywave"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Function1<List<String>, List<String>> excludeRegexp(String ... regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            return (Function1)new Function1<List<? extends String>, List<? extends String>>(regex){
                final /* synthetic */ String[] $regex;
                {
                    this.$regex = $regex;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke(@NotNull List<String> tables) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(tables, (String)"tables");
                    String[] $this$map$iv = this.$regex;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new Regex((String)it, RegexOption.IGNORE_CASE));
                    }
                    List excludes = (List)destination$iv$iv;
                    Iterable $this$filter$iv = tables;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Object v0;
                        block3: {
                            String it = (String)element$iv$iv;
                            boolean bl = false;
                            Iterable iterable = excludes;
                            for (T t : iterable) {
                                Regex tt = (Regex)t;
                                boolean bl2 = false;
                                if (!tt.matches((CharSequence)it)) continue;
                                v0 = t;
                                break block3;
                            }
                            v0 = null;
                        }
                        boolean bl = v0 == null;
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                }
            };
        }

        @JvmStatic
        @NotNull
        public final Function1<List<String>, List<String>> includeRegexp(String ... regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            return (Function1)new Function1<List<? extends String>, List<? extends String>>(regex){
                final /* synthetic */ String[] $regex;
                {
                    this.$regex = $regex;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke(@NotNull List<String> tables) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(tables, (String)"tables");
                    String[] $this$map$iv = this.$regex;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new Regex((String)it, RegexOption.IGNORE_CASE));
                    }
                    List excludes = (List)destination$iv$iv;
                    Iterable $this$filter$iv = tables;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Object v0;
                        block3: {
                            String it = (String)element$iv$iv;
                            boolean bl = false;
                            Iterable iterable = excludes;
                            for (T t : iterable) {
                                Regex tt = (Regex)t;
                                boolean bl2 = false;
                                if (!tt.matches((CharSequence)it)) continue;
                                v0 = t;
                                break block3;
                            }
                            v0 = null;
                        }
                        boolean bl = v0 != null;
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                }
            };
        }

        @JvmStatic
        @NotNull
        public final Function1<List<String>, List<String>> groupedTable(boolean only, String ... table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return (Function1)new Function1<List<? extends String>, ArrayList<String>>(table, only){
                final /* synthetic */ String[] $table;
                final /* synthetic */ boolean $only;
                {
                    this.$table = $table;
                    this.$only = $only;
                    super(1);
                }

                @NotNull
                public final ArrayList<String> invoke(@NotNull List<String> tables) {
                    Intrinsics.checkNotNullParameter(tables, (String)"tables");
                    ArrayList<String> spec = new ArrayList<String>(tables.size() + this.$table.length);
                    LinkedList<E> temp = new LinkedList<E>(tables);
                    block0: for (String t : this.$table) {
                        Iterator<E> iter;
                        if (StringsKt.startsWith$default((String)t, (String)"--", (boolean)false, (int)2, null)) {
                            spec.add(t);
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue(temp.iterator(), (String)"iterator(...)");
                        while (iter.hasNext()) {
                            String s = (String)iter.next();
                            if (!StringsKt.equals((String)s, (String)t, (boolean)true)) continue;
                            iter.remove();
                            spec.add(s);
                            continue block0;
                        }
                    }
                    if (!this.$only && !((Collection)temp).isEmpty()) {
                        spec.add("--");
                        spec.addAll(CollectionsKt.sorted((Iterable)temp));
                    }
                    return spec;
                }
            };
        }

        public static /* synthetic */ Function1 groupedTable$default(Companion companion, boolean bl, String[] stringArray, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return companion.groupedTable(bl, stringArray);
        }

        @JvmStatic
        @NotNull
        public final Function1<List<String>, List<String>> groupedRegexp(boolean only, String ... regexp) {
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            return (Function1)new Function1<List<? extends String>, List<? extends String>>(regexp, only){
                final /* synthetic */ String[] $regexp;
                final /* synthetic */ boolean $only;
                {
                    this.$regexp = $regexp;
                    this.$only = $only;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke(@NotNull List<String> tables) {
                    List list;
                    void $this$mapTo$iv$iv;
                    Iterable r;
                    Intrinsics.checkNotNullParameter(tables, (String)"tables");
                    LinkedHashMap<K, V> regexSlots = new LinkedHashMap<K, V>(this.$regexp.length);
                    for (String it : this.$regexp) {
                        if (StringsKt.startsWith$default((String)it, (String)"--", (boolean)false, (int)2, null)) {
                            Map object = regexSlots;
                            Regex regex = new Regex(it, RegexOption.LITERAL);
                            Object object2 = new String[]{((Object)StringsKt.trim((CharSequence)it)).toString()};
                            object2 = CollectionsKt.arrayListOf((Object[])object2);
                            object.put(regex, object2);
                            continue;
                        }
                        ((Map)regexSlots).put(new Regex(it, RegexOption.IGNORE_CASE), new ArrayList<E>());
                    }
                    LinkedList<E> temp = new LinkedList<E>(tables);
                    Iterator<E> iterator = temp.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator<E> iter = iterator;
                    block1: while (iter.hasNext()) {
                        String t = (String)iter.next();
                        for (Map.Entry entry : ((Map)regexSlots).entrySet()) {
                            r = (Regex)entry.getKey();
                            ArrayList v = (ArrayList)entry.getValue();
                            Intrinsics.checkNotNull((Object)t);
                            if (!r.matches(t)) continue;
                            v.add(t);
                            iter.remove();
                            continue block1;
                        }
                    }
                    Collection<V> collection = regexSlots.values();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                    Iterable $this$map$iv = collection;
                    boolean bl = false;
                    r = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ArrayList arrayList = (ArrayList)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection2.add(CollectionsKt.sorted((Iterable)((Iterable)it)));
                    }
                    List grpd = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    if (!this.$only && !((Collection)temp).isEmpty()) {
                        ArrayList<String> arrayList;
                        ArrayList<String> arrayList2 = arrayList = new ArrayList<String>(grpd.size() + temp.size() + 1);
                        boolean bl3 = false;
                        arrayList2.addAll(grpd);
                        arrayList2.add("--");
                        arrayList2.addAll(CollectionsKt.sorted((Iterable)temp));
                        list = arrayList;
                    } else {
                        list = grpd;
                    }
                    return list;
                }
            };
        }

        public static /* synthetic */ Function1 groupedRegexp$default(Companion companion, boolean bl, String[] stringArray, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return companion.groupedRegexp(bl, stringArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlString;", "", "table", "", "sqlType", "Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlType;", "sqlText", "(Ljava/lang/String;Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlType;Ljava/lang/String;)V", "getSqlText", "()Ljava/lang/String;", "getSqlType", "()Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlType;", "getTable", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "faceless-flywave"})
    public static final class SqlString {
        @NotNull
        private final String table;
        @NotNull
        private final SqlType sqlType;
        @NotNull
        private final String sqlText;

        public SqlString(@NotNull String table, @NotNull SqlType sqlType, @NotNull String sqlText) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)((Object)sqlType), (String)"sqlType");
            Intrinsics.checkNotNullParameter((Object)sqlText, (String)"sqlText");
            this.table = table;
            this.sqlType = sqlType;
            this.sqlText = sqlText;
        }

        @NotNull
        public final String getTable() {
            return this.table;
        }

        @NotNull
        public final SqlType getSqlType() {
            return this.sqlType;
        }

        @NotNull
        public final String getSqlText() {
            return this.sqlText;
        }

        @NotNull
        public final String component1() {
            return this.table;
        }

        @NotNull
        public final SqlType component2() {
            return this.sqlType;
        }

        @NotNull
        public final String component3() {
            return this.sqlText;
        }

        @NotNull
        public final SqlString copy(@NotNull String table, @NotNull SqlType sqlType, @NotNull String sqlText) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)((Object)sqlType), (String)"sqlType");
            Intrinsics.checkNotNullParameter((Object)sqlText, (String)"sqlText");
            return new SqlString(table, sqlType, sqlText);
        }

        public static /* synthetic */ SqlString copy$default(SqlString sqlString, String string, SqlType sqlType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = sqlString.table;
            }
            if ((n & 2) != 0) {
                sqlType = sqlString.sqlType;
            }
            if ((n & 4) != 0) {
                string2 = sqlString.sqlText;
            }
            return sqlString.copy(string, sqlType, string2);
        }

        @NotNull
        public String toString() {
            return "SqlString(table=" + this.table + ", sqlType=" + this.sqlType + ", sqlText=" + this.sqlText + ")";
        }

        public int hashCode() {
            int result = this.table.hashCode();
            result = result * 31 + this.sqlType.hashCode();
            result = result * 31 + this.sqlText.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SqlString)) {
                return false;
            }
            SqlString sqlString = (SqlString)other;
            if (!Intrinsics.areEqual((Object)this.table, (Object)sqlString.table)) {
                return false;
            }
            if (this.sqlType != sqlString.sqlType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sqlText, (Object)sqlString.sqlText);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaFulldumpManager$SqlType;", "", "(Ljava/lang/String;I)V", "DdlTable", "DdlTrigger", "DmlInsert", "SqlUnknown", "StrComment", "faceless-flywave"})
    public static final class SqlType
    extends Enum<SqlType> {
        public static final /* enum */ SqlType DdlTable = new SqlType();
        public static final /* enum */ SqlType DdlTrigger = new SqlType();
        public static final /* enum */ SqlType DmlInsert = new SqlType();
        public static final /* enum */ SqlType SqlUnknown = new SqlType();
        public static final /* enum */ SqlType StrComment = new SqlType();
        private static final /* synthetic */ SqlType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SqlType[] values() {
            return (SqlType[])$VALUES.clone();
        }

        public static SqlType valueOf(String value) {
            return Enum.valueOf(SqlType.class, value);
        }

        @NotNull
        public static EnumEntries<SqlType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sqlTypeArray = new SqlType[]{SqlType.DdlTable, SqlType.DdlTrigger, SqlType.DmlInsert, SqlType.SqlUnknown, SqlType.StrComment};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlType.values().length];
            try {
                nArray[SqlType.StrComment.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlType.DdlTrigger.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

