/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave.impl;

import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.time.DateFormatter;
import pro.fessional.wings.faceless.flywave.SqlStatementParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u0018J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0004J \u0010\"\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u0018J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0012\u0010(\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0016J\u001e\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u0018*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000RB\u0010\u0016\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u00180\u0017j\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u0018`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0017j\b\u0012\u0004\u0012\u00020\u0004`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u001d\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u00180\u0017j\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001a0\u0018`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lpro/fessional/wings/faceless/flywave/impl/MySqlStatementParser;", "Lpro/fessional/wings/faceless/flywave/SqlStatementParser;", "()V", "ddlAlterTable", "Ljava/util/regex/Pattern;", "ddlCreateIndex", "ddlCreateTable", "ddlCreateTrigger", "ddlDropIndex", "ddlDropTable", "ddlDropTrigger", "ddlRenameTable", "ddlTruncateTable", "dmlDelete", "dmlInsert", "dmlReplace", "dmlUpdate", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "options", "", "plainRegex", "Ljava/util/LinkedHashSet;", "Ljava/util/function/Function;", "", "Ljava/util/Optional;", "Lkotlin/collections/LinkedHashSet;", "plainRename", "shardRegex", "addPlain", "", "function", "pattern", "addShard", "parseTypeAndTable", "Lpro/fessional/wings/faceless/flywave/SqlStatementParser$SqlType;", "sql", "safeName", "str", "safeValue", "obj", "", "trimName", "toFunction", "faceless-flywave"})
public final class MySqlStatementParser
implements SqlStatementParser {
    private final Logger log = LoggerFactory.getLogger(MySqlStatementParser.class);
    private final int options;
    @NotNull
    private final Pattern ddlRenameTable;
    @NotNull
    private final Pattern ddlAlterTable;
    @NotNull
    private final Pattern ddlCreateIndex;
    @NotNull
    private final Pattern ddlCreateTable;
    @NotNull
    private final Pattern ddlCreateTrigger;
    @NotNull
    private final Pattern ddlDropIndex;
    @NotNull
    private final Pattern ddlDropTable;
    @NotNull
    private final Pattern ddlDropTrigger;
    @NotNull
    private final Pattern ddlTruncateTable;
    @NotNull
    private final Pattern dmlDelete;
    @NotNull
    private final Pattern dmlInsert;
    @NotNull
    private final Pattern dmlReplace;
    @NotNull
    private final Pattern dmlUpdate;
    @NotNull
    private final LinkedHashSet<Pattern> plainRename;
    @NotNull
    private final LinkedHashSet<Function<String, Optional<String>>> plainRegex;
    @NotNull
    private final LinkedHashSet<Function<String, Optional<String>>> shardRegex;

    public MySqlStatementParser() {
        this.options = 10;
        Pattern pattern = Pattern.compile("^ALTER\\s+TABLE\\s+([^(\\s]+)\\s+RENAME\\s+TO\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.ddlRenameTable = pattern;
        Pattern pattern2 = Pattern.compile("^ALTER\\s+TABLE\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        this.ddlAlterTable = pattern2;
        Pattern pattern3 = Pattern.compile("^CREATE\\s+(?:UNIQUE\\s+|FULLTEXT\\s+|SPATIAL\\s+)?INDEX\\s+\\S+\\s+(?:\\S+\\s+)?ON\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        this.ddlCreateIndex = pattern3;
        Pattern pattern4 = Pattern.compile("^CREATE\\s+(?:TEMPORARY\\s+)?TABLE\\s+(?:IF\\s+NOT\\s+EXISTS\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        this.ddlCreateTable = pattern4;
        Pattern pattern5 = Pattern.compile("^CREATE\\s+(?:DEFINER\\s*=\\s*\\S+\\s+)?TRIGGER\\s+(?:\\S+\\s+)*ON\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        this.ddlCreateTrigger = pattern5;
        Pattern pattern6 = Pattern.compile("^DROP\\s+INDEX\\s+\\S+\\s+ON\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern6, (String)"compile(...)");
        this.ddlDropIndex = pattern6;
        Pattern pattern7 = Pattern.compile("^DROP\\s+(?:TEMPORARY\\s+)?TABLE\\s+(?:IF\\s+EXISTS\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern7, (String)"compile(...)");
        this.ddlDropTable = pattern7;
        Pattern pattern8 = Pattern.compile("^DROP\\s+TRIGGER\\s+(?:IF\\s+EXISTS\\s+)?\\S+\\s", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern8, (String)"compile(...)");
        this.ddlDropTrigger = pattern8;
        Pattern pattern9 = Pattern.compile("^TRUNCATE\\s+(?:TABLE\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern9, (String)"compile(...)");
        this.ddlTruncateTable = pattern9;
        Pattern pattern10 = Pattern.compile("^DELETE\\s+(?:\\S+\\s)*FROM\\s+([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern10, (String)"compile(...)");
        this.dmlDelete = pattern10;
        Pattern pattern11 = Pattern.compile("^INSERT\\s+(?:LOW_PRIORITY\\s+|DELAYED\\s+|HIGH_PRIORITY\\s+)?(?:IGNORE\\s+)?(?:INTO\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern11, (String)"compile(...)");
        this.dmlInsert = pattern11;
        Pattern pattern12 = Pattern.compile("^REPLACE\\s+(?:LOW_PRIORITY|DELAYED)?\\s*(?:INTO\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern12, (String)"compile(...)");
        this.dmlReplace = pattern12;
        Pattern pattern13 = Pattern.compile("^UPDATE\\s+(?:LOW_PRIORITY\\s+)?(?:IGNORE\\s+)?([^(\\s]+)", this.options);
        Intrinsics.checkNotNullExpressionValue((Object)pattern13, (String)"compile(...)");
        this.dmlUpdate = pattern13;
        Object[] objectArray = new Pattern[]{this.ddlRenameTable};
        this.plainRename = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Function[]{this.toFunction(this.ddlAlterTable), this.toFunction(this.ddlCreateIndex), this.toFunction(this.ddlCreateTable), this.toFunction(this.ddlCreateTrigger), this.toFunction(this.ddlDropIndex), this.toFunction(this.ddlDropTable), this.toFunction(this.ddlDropTrigger), this.toFunction(this.ddlTruncateTable)};
        this.plainRegex = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Function[]{this.toFunction(this.dmlDelete), this.toFunction(this.dmlInsert), this.toFunction(this.dmlReplace), this.toFunction(this.dmlUpdate)};
        this.shardRegex = SetsKt.linkedSetOf((Object[])objectArray);
    }

    public final boolean addShard(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.shardRegex.add(this.toFunction(pattern));
    }

    public final boolean addPlain(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.plainRegex.add(this.toFunction(pattern));
    }

    public final boolean addShard(@NotNull Function<String, Optional<String>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.shardRegex.add(function);
    }

    public final boolean addPlain(@NotNull Function<String, Optional<String>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.plainRegex.add(function);
    }

    private final Function<String, Optional<String>> toFunction(Pattern $this$toFunction) {
        return arg_0 -> MySqlStatementParser.toFunction$lambda$0($this$toFunction, this, arg_0);
    }

    @Override
    @NotNull
    public SqlStatementParser.SqlType parseTypeAndTable(@NotNull String sql) {
        Object m;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (StringsKt.startsWith((String)sql, (String)"SELECT ", (boolean)true)) {
            return SqlStatementParser.SqlType.Other.INSTANCE;
        }
        for (Pattern pattern : this.plainRename) {
            m = pattern.matcher(sql);
            if (!((Matcher)m).find()) continue;
            String string = ((Matcher)m).group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String tbl = this.trimName(string);
            String string2 = ((Matcher)m).group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            String ren = this.trimName(string2);
            return new SqlStatementParser.SqlType.Plain(tbl, ren);
        }
        for (Function function : this.plainRegex) {
            Object r = function.apply(sql);
            Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
            m = (Optional)r;
            if (!((Optional)m).isPresent()) continue;
            Object t = ((Optional)m).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return new SqlStatementParser.SqlType.Plain((String)t, null, 2, null);
        }
        for (Function function : this.shardRegex) {
            m = ((Optional)function.apply(sql)).orElse("");
            Intrinsics.checkNotNull((Object)m);
            if (!(((CharSequence)m).length() > 0)) continue;
            return new SqlStatementParser.SqlType.Shard((String)m);
        }
        this.log.warn("unmatched sql type, return Other. sql=[" + sql + "]");
        return SqlStatementParser.SqlType.Other.INSTANCE;
    }

    @Override
    @NotNull
    public String safeName(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int i1 = StringsKt.indexOf$default((CharSequence)str, (char)'`', (int)0, (boolean)false, (int)6, null);
        if (i1 >= 0) {
            int i2 = StringsKt.lastIndexOf$default((CharSequence)str, (char)'`', (int)0, (boolean)false, (int)6, null);
            return i1 == 0 && i2 == str.length() - 1 ? str : "`" + StringsKt.replaceAfter$default((String)str, (String)"`", (String)"", null, (int)4, null) + "`";
        }
        return "`" + str + "`";
    }

    @Override
    @NotNull
    public String safeValue(@Nullable Object obj) {
        String string;
        Object object = obj;
        if (object == null) {
            return "NULL";
        }
        if (object instanceof Boolean) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (object instanceof Number) {
            return ((Number)obj).toString();
        }
        if (object instanceof LocalDate) {
            return "'" + DateFormatter.date10((LocalDate)((LocalDate)obj)) + "'";
        }
        if (object instanceof LocalDateTime) {
            return "'" + DateFormatter.full23((LocalDateTime)((LocalDateTime)obj)) + "'";
        }
        if (object instanceof LocalTime) {
            return "'" + DateFormatter.time12((LocalTime)((LocalTime)obj)) + "'";
        }
        if (object instanceof Time) {
            return "'" + obj + "'";
        }
        if (object instanceof Date) {
            return "'" + obj + "'";
        }
        if (object instanceof Timestamp) {
            return "'" + DateFormatter.full23((LocalDateTime)((Timestamp)obj).toLocalDateTime()) + "'";
        }
        if (object instanceof java.util.Date) {
            return "'" + DateFormatter.full23((java.util.Date)((java.util.Date)obj)) + "'";
        }
        if (object instanceof byte[]) {
            return "0x" + Bytes.hex((byte[])((byte[])obj));
        }
        if (object instanceof Blob) {
            return "0x" + Bytes.hex((byte[])((Blob)obj).getBytes(0L, (int)((Blob)obj).length()));
        }
        if (obj instanceof Clob) {
            Reader reader = ((Clob)obj).getCharacterStream();
            Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"getCharacterStream(...)");
            string = TextStreamsKt.readText((Reader)reader);
        } else {
            string = String.valueOf(obj);
        }
        String str = string;
        StringBuilder sb = new StringBuilder(str.length() + 10);
        sb.append('\'');
        boolean c00 = false;
        char c26 = '&';
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            char c2 = c;
            if (c2 == '\u0000') {
                sb.append("\\0");
                continue;
            }
            if (c2 == '\'') {
                sb.append("\\'");
                continue;
            }
            if (c2 == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c2 == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c2 == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c2 == c26) {
                sb.append("\\Z");
                continue;
            }
            if (c2 == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        sb.append('\'');
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public String trimName(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.contains$default((CharSequence)str, (char)'`', (boolean)false, (int)2, null) ? StringsKt.replace$default((String)str, (String)"`", (String)"", (boolean)false, (int)4, null) : str;
    }

    private static final Optional toFunction$lambda$0(Pattern $this_toFunction, MySqlStatementParser this$0, String sql) {
        Intrinsics.checkNotNullParameter((Object)$this_toFunction, (String)"$this_toFunction");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Matcher m = $this_toFunction.matcher(sql);
        if (m.find()) {
            Optional<String> optional;
            if (m.groupCount() > 0) {
                String string = m.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                optional = Optional.of(this$0.trimName(string));
            } else {
                optional = Optional.of("");
            }
            return optional;
        }
        return Optional.empty();
    }
}

