/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.project;

import java.util.Arrays;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import lombok.Generated;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.flywave.SchemaRevisionManager;
import pro.fessional.wings.faceless.util.FlywaveInteractiveGui;
import pro.fessional.wings.faceless.util.FlywaveRevisionScanner;

public class ProjectSchemaManager {
    protected final SchemaRevisionManager schemaRevisionManager;

    public ProjectSchemaManager(SchemaRevisionManager schemaRevisionManager) {
        this(schemaRevisionManager, true);
    }

    public ProjectSchemaManager(SchemaRevisionManager schemaRevisionManager, boolean enableGui) {
        this.schemaRevisionManager = schemaRevisionManager;
        if (enableGui) {
            schemaRevisionManager.askWay(FlywaveInteractiveGui.askGui());
            schemaRevisionManager.logWay(FlywaveInteractiveGui.logGui());
        }
    }

    @SafeVarargs
    public final void mergePublish(long revision, Consumer<FlywaveRevisionScanner.Helper> ... customize) {
        FlywaveRevisionScanner.Helper helper = FlywaveRevisionScanner.helper();
        for (Consumer<FlywaveRevisionScanner.Helper> consumer : customize) {
            consumer.accept(helper);
        }
        this.mergePublish(helper.scan(), -ThreadNow.millis(), revision);
    }

    public void mergePublish(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls, long commitId, long revision) {
        this.schemaRevisionManager.checkAndInitSql(sqls, commitId, true);
        this.schemaRevisionManager.publishRevision(revision, commitId);
    }

    @SafeVarargs
    public final void mergeForceApply(boolean isUpto, Consumer<FlywaveRevisionScanner.Helper> ... customize) {
        FlywaveRevisionScanner.Helper helper = FlywaveRevisionScanner.helper();
        for (Consumer<FlywaveRevisionScanner.Helper> consumer : customize) {
            consumer.accept(helper);
        }
        this.mergeForceApply(helper.scan(), -ThreadNow.millis(), isUpto);
    }

    public void mergeForceApply(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls, long commitId, boolean isUpto) {
        this.schemaRevisionManager.checkAndInitSql(sqls, commitId, true);
        for (Long rev : sqls.keySet()) {
            this.schemaRevisionManager.forceApplyBreak(rev, commitId, isUpto, null);
        }
    }

    public void downThenMergePublish(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls, long commitId, Collection<Long> revision) {
        TreeSet<Long> tree = new TreeSet<Long>(revision);
        for (Long rev : tree.descendingSet()) {
            this.schemaRevisionManager.forceApplyBreak(rev, commitId, false, null);
        }
        this.schemaRevisionManager.checkAndInitSql(sqls, commitId, true);
        for (long rev : tree) {
            this.schemaRevisionManager.publishRevision(rev, commitId);
        }
    }

    public void downThenMergePublish(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls, long commitId, Long ... revision) {
        this.downThenMergePublish(sqls, commitId, Arrays.asList(revision));
    }

    @Generated
    public SchemaRevisionManager getSchemaRevisionManager() {
        return this.schemaRevisionManager;
    }
}

