/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.util;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;
import pro.fessional.mirana.text.BuilderHelper;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.faceless.flywave.RevisionRegister;
import pro.fessional.wings.faceless.flywave.SchemaRevisionManager;

public class FlywaveRevisionScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlywaveRevisionScanner.class);
    public static final String REVISION_PATH_REVIFILE_EXTN = ".sql";
    public static final String REVISION_PATH_REVIFILE_TAIL = "**/*.sql";
    public static final String REVISION_PATH_FLYWAVE_HEAD = "classpath*:/wings-flywave/";
    public static final String REVISION_PATH_MASTER_HEAD = "classpath*:/wings-flywave/master/";
    public static final String REVISION_PATH_MASTER = "classpath*:/wings-flywave/master/**/*.sql";
    public static final String REVISION_PATH_BRANCH_HEAD = "classpath*:/wings-flywave/branch/";
    public static final String REVISION_PATH_FEATURE_HEAD = "classpath*:/wings-flywave/branch/feature/";
    public static final String REVISION_PATH_SUPPORT_HEAD = "classpath*:/wings-flywave/branch/support/";
    public static final String REVISION_PATH_SOMEFIX_HEAD = "classpath*:/wings-flywave/branch/somefix/";
    public static final String REVISION_PATH_BRANCH_FULL = "classpath*:/wings-flywave/branch/**/*.sql";

    @NotNull
    public static String flywavePath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_FLYWAVE_HEAD, name);
    }

    @NotNull
    public static String masterPath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_MASTER_HEAD, name);
    }

    @NotNull
    public static String somefixPath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_SOMEFIX_HEAD, name);
    }

    @NotNull
    public static String supportPath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_SUPPORT_HEAD, name);
    }

    @NotNull
    public static String featurePath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_FEATURE_HEAD, name);
    }

    @NotNull
    public static String branchPath(String name) {
        return FlywaveRevisionScanner.prefixPath(REVISION_PATH_BRANCH_HEAD, name);
    }

    @NotNull
    private static String prefixPath(String prefix, String name) {
        int lst;
        String en;
        if (name == null) {
            return prefix + REVISION_PATH_REVIFILE_TAIL;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(prefix);
        for (String pt : name.split("[/\\\\]+")) {
            if ((pt = pt.trim()).isEmpty()) continue;
            sb.append(pt).append("/");
        }
        int dot = sb.length() - REVISION_PATH_REVIFILE_EXTN.length() - 1;
        if (dot > 0 && (en = sb.substring(dot, lst = sb.length() - 1)).equalsIgnoreCase(REVISION_PATH_REVIFILE_EXTN)) {
            return sb.substring(0, lst);
        }
        sb.append(REVISION_PATH_REVIFILE_TAIL);
        return sb.toString();
    }

    @NotNull
    public static String commentInfo(String ... path) {
        Pattern tknRegex = Pattern.compile("[/\\\\]wings-flywave[/\\\\]([^:]*[/\\\\])([-_0-9]{8,}[uv][0-9]{2,})([^/]*\\.sql)$", 2);
        LinkedHashSet<String> info = new LinkedHashSet<String>();
        for (String s : path) {
            Matcher m = tknRegex.matcher(s);
            if (m.find()) {
                BuilderHelper.W sb = BuilderHelper.w();
                sb.append((CharSequence)m.group(1));
                sb.append((CharSequence)FlywaveRevisionScanner.formatRevi(m.group(2)));
                sb.append((CharSequence)m.group(3));
                info.add(sb.toString());
                continue;
            }
            info.add(s);
        }
        info.removeIf(String::isBlank);
        return String.join((CharSequence)", ", info);
    }

    public static String formatRevi(String revi) {
        StringBuilder sb = new StringBuilder(revi.length());
        int cnt = 0;
        int len = revi.length();
        for (int i = 0; i < len; ++i) {
            char c = revi.charAt(i);
            if (c == 'u' || c == 'U' || c == 'v' || c == 'V') {
                sb.append("_");
                cnt = 0;
                continue;
            }
            if (c < '0' || c > '9') continue;
            if (cnt > 0 && cnt % 4 == 0) {
                sb.append("-");
            }
            ++cnt;
            sb.append(c);
        }
        int lst = sb.length() - 1;
        if (sb.charAt(lst) == '-') {
            return sb.substring(0, lst);
        }
        return sb.toString();
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scanMaster() {
        return FlywaveRevisionScanner.scan(REVISION_PATH_MASTER);
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scanMaster(String ... name) {
        TreeMap<Long, SchemaRevisionManager.RevisionSql> result = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
        for (String n : name) {
            FlywaveRevisionScanner.scan(result, FlywaveRevisionScanner.masterPath(n));
        }
        return result;
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scanBranch(String ... name) {
        TreeMap<Long, SchemaRevisionManager.RevisionSql> result = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
        for (String n : name) {
            FlywaveRevisionScanner.scan(result, FlywaveRevisionScanner.branchPath(n));
        }
        return result;
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scan(RevisionRegister ... path) {
        TreeMap<Long, SchemaRevisionManager.RevisionSql> result = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
        for (RevisionRegister p : path) {
            FlywaveRevisionScanner.scan(result, p.classpath());
        }
        return result;
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scan(String ... path) {
        return FlywaveRevisionScanner.scan(Arrays.asList(path));
    }

    @NotNull
    public static SortedMap<Long, SchemaRevisionManager.RevisionSql> scan(@NotNull Collection<String> path) {
        TreeMap<Long, SchemaRevisionManager.RevisionSql> result = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
        for (String p : path) {
            FlywaveRevisionScanner.scan(result, p);
        }
        return result;
    }

    public static void scan(SortedMap<Long, SchemaRevisionManager.RevisionSql> result, String path) {
        String file = null;
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources(path);
            log.info("[FlywaveRevisionScanner]\ud83d\udc1d scanned " + resources.length + " resources in path=" + path);
            Pattern reviRegex = Pattern.compile("([-_0-9]{8,})([uv])([0-9]{2,})[^/]*\\.sql$", 2);
            Charset utf8 = StandardCharsets.UTF_8;
            HashSet<Long> newRevi = new HashSet<Long>();
            HashSet<Long> rplRevi = new HashSet<Long>();
            for (Resource res : resources) {
                String ou;
                file = res.getURL().getPath();
                Matcher m = reviRegex.matcher(file);
                if (!m.find()) {
                    log.info("[FlywaveRevisionScanner]\ud83d\udc1d skip unsupported resource=" + file);
                    continue;
                }
                boolean undo = "u".equalsIgnoreCase(m.group(2));
                StringBuilder sb = new StringBuilder(10);
                String g1 = m.group(1);
                for (int i = 0; i < g1.length(); ++i) {
                    char c = g1.charAt(i);
                    if (c < '0' || c > '9') continue;
                    sb.append(c);
                }
                sb.append(m.group(3));
                Long revi = Long.valueOf(sb.toString());
                newRevi.add(revi);
                SchemaRevisionManager.RevisionSql d = result.computeIfAbsent(revi, SchemaRevisionManager.RevisionSql::new);
                String text = StreamUtils.copyToString((InputStream)res.getInputStream(), (Charset)utf8);
                if (undo) {
                    ou = d.getUndoPath();
                    if (EmptySugar.asEmptyValue((String)ou)) {
                        log.info("[FlywaveRevisionScanner]\ud83d\udc1d scan " + revi + " undo\u2193 resource=" + file);
                    } else {
                        rplRevi.add(revi);
                        log.warn("[FlywaveRevisionScanner]\ud83d\udc1d replace " + revi + " undo\u2193 new=" + file + ", old=" + ou);
                    }
                    d.setUndoPath(file);
                    d.setUndoText(text);
                    continue;
                }
                ou = d.getUptoPath();
                if (EmptySugar.asEmptyValue((String)ou)) {
                    log.info("[FlywaveRevisionScanner]\ud83d\udc1d scan " + revi + " upto\u2191 resource=" + file);
                } else {
                    rplRevi.add(revi);
                    log.warn("[FlywaveRevisionScanner]\ud83d\udc1d replace " + revi + " upto\u2191 new=" + file + ", old=" + ou);
                }
                d.setUptoPath(file);
                d.setUptoText(text);
            }
            log.info("[FlywaveRevisionScanner]\ud83d\udc1d scanned revisions new=" + newRevi.size() + ", replace=" + rplRevi.size());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to scan path = " + path + ", file=" + file, e);
        }
    }

    @NotNull
    public static String undo(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls) {
        BuilderHelper.W sb = BuilderHelper.w();
        if (sqls != null) {
            sb.join(true, "\n", sqls.values(), SchemaRevisionManager.RevisionSql::getUndoText);
        }
        return sb.toString();
    }

    @NotNull
    public static String upto(SortedMap<Long, SchemaRevisionManager.RevisionSql> sqls) {
        BuilderHelper.W sb = BuilderHelper.w();
        if (sqls != null) {
            sb.join(true, "\n", sqls.values(), SchemaRevisionManager.RevisionSql::getUptoText);
        }
        return sb.toString();
    }

    public static Helper helper() {
        return new Helper();
    }

    public static class Helper {
        private final LinkedHashMap<Predicate<Long>, String> includes = new LinkedHashMap();
        private final LinkedHashMap<Predicate<Long>, String> excludes = new LinkedHashMap();
        private final HashMap<Long, Long> replaces = new HashMap();
        private final LinkedHashMap<BiConsumer<Long, SchemaRevisionManager.RevisionSql>, String> modifier = new LinkedHashMap();
        private final LinkedHashSet<String> paths = new LinkedHashSet();

        @Contract(value="_->this")
        public Helper path(RevisionRegister ... path) {
            for (RevisionRegister s : path) {
                this.paths.add(s.classpath());
            }
            return this;
        }

        @Contract(value="_->this")
        public Helper path(String ... path) {
            Collections.addAll(this.paths, path);
            return this;
        }

        @Contract(value="_->this")
        public Helper flywave(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.flywavePath(s));
            }
            return this;
        }

        @Contract(value="->this")
        public Helper master() {
            this.paths.add(FlywaveRevisionScanner.REVISION_PATH_MASTER);
            return this;
        }

        @Contract(value="_->this")
        public Helper master(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.masterPath(s));
            }
            return this;
        }

        @Contract(value="_->this")
        public Helper branch(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.branchPath(s));
            }
            return this;
        }

        @Contract(value="_->this")
        public Helper feature(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.featurePath(s));
            }
            return this;
        }

        @Contract(value="_->this")
        public Helper somefix(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.somefixPath(s));
            }
            return this;
        }

        @Contract(value="_->this")
        public Helper support(String ... path) {
            for (String s : path) {
                this.paths.add(FlywaveRevisionScanner.supportPath(s));
            }
            return this;
        }

        @Contract(value="_,_->this")
        public Helper replace(long from, long to) {
            return this.replace(from, to, false);
        }

        @Contract(value="_,_,_->this")
        public Helper replace(long from, long to, boolean sql) {
            if (sql) {
                Pattern op = Pattern.compile("\\b" + from + "\\b");
                String ns = String.valueOf(to);
                return this.replace(from, to, it -> op.matcher((CharSequence)it).replaceAll(ns));
            }
            return this.replace(from, to, null);
        }

        @Contract(value="_,_,_->this")
        public Helper replace(long from, long to, Function<String, String> mod) {
            if (from < 0L || to < 0L) {
                throw new IllegalArgumentException("revi must >0");
            }
            this.replaces.put(from, to);
            if (mod != null) {
                this.modify("replace " + from + " to " + to + " with sql", to, (SchemaRevisionManager.RevisionSql it) -> {
                    it.setUptoText((String)mod.apply(it.getUptoText()));
                    it.setUndoText((String)mod.apply(it.getUndoText()));
                    log.info("[FlywaveRevisionScanner]\ud83d\udc1d replace revi from=" + from + " to=" + to + " with sql text");
                });
            }
            return this;
        }

        @Contract(value="_,_,_->this")
        public Helper modify(long revi, String str, String rpl) {
            return this.modify("replace " + str + " to " + rpl + " at revi=" + revi, revi, (SchemaRevisionManager.RevisionSql it) -> {
                it.setUptoText(it.getUptoText().replace(str, rpl));
                it.setUndoText(it.getUndoText().replace(str, rpl));
            });
        }

        @Contract(value="_,_->this")
        public Helper modify(long revi, Consumer<SchemaRevisionManager.RevisionSql> mod) {
            return this.modify("", revi, mod);
        }

        @Contract(value="_,_,_->this")
        public Helper modify(String info, long revi, Consumer<SchemaRevisionManager.RevisionSql> mod) {
            this.modifier.put((r, s) -> {
                if (r == revi) {
                    mod.accept((SchemaRevisionManager.RevisionSql)s);
                }
            }, info);
            return this;
        }

        @Contract(value="_->this")
        public Helper modify(BiConsumer<Long, SchemaRevisionManager.RevisionSql> mod) {
            return this.modify("", mod);
        }

        @Contract(value="_,_->this")
        public Helper modify(String info, BiConsumer<Long, SchemaRevisionManager.RevisionSql> mod) {
            this.modifier.put(mod, info);
            return this;
        }

        @Contract(value="_->this")
        public Helper include(RevisionRegister revi) {
            return this.include(revi.description(), revi.revision());
        }

        @Contract(value="_->this")
        public Helper include(long ... revi) {
            return this.include("", revi);
        }

        @Contract(value="_,_->this")
        public Helper include(String info, long ... revi) {
            HashSet<Long> rvs = new HashSet<Long>();
            long[] lArray = revi;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long l = lArray[i];
                rvs.add(l);
            }
            return this.include(info, rvs::contains);
        }

        @Contract(value="_->this")
        public Helper include(Predicate<Long> inc) {
            return this.include("", inc);
        }

        @Contract(value="_,_->this")
        public Helper include(String info, Predicate<Long> inc) {
            this.includes.put(inc, info);
            return this;
        }

        @Contract(value="_->this")
        public Helper exclude(RevisionRegister revi) {
            return this.exclude(revi.description(), revi.revision());
        }

        @Contract(value="_->this")
        public Helper exclude(long ... revi) {
            return this.exclude("", revi);
        }

        @Contract(value="_,_->this")
        public Helper exclude(String info, long ... revi) {
            HashSet<Long> rvs = new HashSet<Long>();
            long[] lArray = revi;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long l = lArray[i];
                rvs.add(l);
            }
            return this.exclude(info, rvs::contains);
        }

        @Contract(value="_->this")
        public Helper exclude(Predicate<Long> exc) {
            return this.exclude("", exc);
        }

        @Contract(value="_,_->this")
        public Helper exclude(String info, Predicate<Long> exc) {
            this.excludes.put(exc, info);
            return this;
        }

        @NotNull
        public SortedMap<Long, SchemaRevisionManager.RevisionSql> scan() {
            TreeMap<Long, SchemaRevisionManager.RevisionSql> result = new TreeMap<Long, SchemaRevisionManager.RevisionSql>();
            for (String string : this.paths) {
                FlywaveRevisionScanner.scan(result, string);
            }
            if (result.isEmpty()) {
                return result;
            }
            for (Map.Entry entry : this.replaces.entrySet()) {
                Long nv;
                Long ov = (Long)entry.getKey();
                if (ov.equals(nv = (Long)entry.getValue())) continue;
                SchemaRevisionManager.RevisionSql old = result.remove(ov);
                if (old == null) {
                    throw new IllegalStateException("failed to replace not-exist from=" + ov + " to=" + nv);
                }
                SchemaRevisionManager.RevisionSql tor = result.put(nv, old);
                if (tor == null) continue;
                log.info("[FlywaveRevisionScanner]\ud83d\udc1d replace revi from=" + ov + " to=" + nv + ", exist=" + String.valueOf(tor));
            }
            if (!this.includes.isEmpty()) {
                result.entrySet().removeIf(it -> {
                    for (Map.Entry<Predicate<Long>, String> ent : this.includes.entrySet()) {
                        if (!ent.getKey().test((Long)it.getKey())) continue;
                        String info = ent.getValue();
                        if (info != null && !info.isEmpty()) {
                            log.info("[FlywaveRevisionScanner]\ud83d\udc1d include " + String.valueOf(it.getKey()) + " by " + info);
                        } else {
                            log.info("[FlywaveRevisionScanner]\ud83d\udc1d include " + String.valueOf(it.getKey()));
                        }
                        return false;
                    }
                    log.info("[FlywaveRevisionScanner]\ud83d\udc1d remove " + String.valueOf(it.getKey()) + " by include filter unmatched");
                    return true;
                });
            }
            if (!this.excludes.isEmpty()) {
                result.entrySet().removeIf(it -> {
                    for (Map.Entry<Predicate<Long>, String> ent : this.excludes.entrySet()) {
                        if (!ent.getKey().test((Long)it.getKey())) continue;
                        String info = ent.getValue();
                        if (info == null || info.isEmpty()) {
                            log.info("[FlywaveRevisionScanner]\ud83d\udc1d remove " + String.valueOf(it.getKey()) + " by exclude filter matched");
                        } else {
                            log.info("[FlywaveRevisionScanner]\ud83d\udc1d remove " + String.valueOf(it.getKey()) + " by " + info);
                        }
                        return true;
                    }
                    return false;
                });
            }
            for (Map.Entry entry : this.modifier.entrySet()) {
                log.info("[FlywaveRevisionScanner]\ud83d\udc1d modify RevisionSql by " + (String)entry.getValue());
                BiConsumer fn = (BiConsumer)entry.getKey();
                for (Map.Entry<Long, SchemaRevisionManager.RevisionSql> ent : result.entrySet()) {
                    fn.accept(ent.getKey(), ent.getValue());
                }
            }
            return result;
        }
    }
}

