/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\tJ \u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u0006J*\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u0006JB\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00110\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00182\b\b\u0002\u0010\u0019\u001a\u00020\tH\u0002J6\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\tJH\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00110\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\tJ2\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\tJ6\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00132\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\t\u00a8\u0006\u001e"}, d2={"Lpro/fessional/wings/faceless/flywave/util/TemplateUtil;", "", "()V", "findQuoteEnd", "", "txt", "", "idx", "isBoundary", "", "dollar", "sub", "maskQuote", "qto", "merge", "Ljava/util/SortedMap;", "tbl", "Lkotlin/Pair;", "map", "", "parse", "", "msk", "tkn", "Ljava/util/TreeMap;", "bnd", "", "replace", "rpl", "rep", "faceless-flywave"})
public final class TemplateUtil {
    @NotNull
    public static final TemplateUtil INSTANCE = new TemplateUtil();

    private TemplateUtil() {
    }

    @NotNull
    public final String replace(@NotNull String txt, @NotNull String sub, @NotNull String rpl, @NotNull String qto, boolean bnd) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        Intrinsics.checkNotNullParameter((Object)rpl, (String)"rpl");
        Intrinsics.checkNotNullParameter((Object)qto, (String)"qto");
        SortedMap<Integer, Integer> idx = this.parse(txt, sub, qto, bnd);
        return this.merge(txt, idx, rpl);
    }

    public static /* synthetic */ String replace$default(TemplateUtil templateUtil, String string, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "'";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return templateUtil.replace(string, string2, string3, string4, bl);
    }

    @NotNull
    public final String replace(@NotNull String txt, @NotNull Map<String, String> rep, @NotNull String qto, boolean bnd) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter(rep, (String)"rep");
        Intrinsics.checkNotNullParameter((Object)qto, (String)"qto");
        List key = CollectionsKt.toList((Iterable)rep.keySet());
        SortedMap<Integer, Pair<Integer, String>> idx = this.parse(txt, key, qto, bnd);
        return this.merge(txt, idx, rep);
    }

    public static /* synthetic */ String replace$default(TemplateUtil templateUtil, String string, Map map, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "'";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return templateUtil.replace(string, map, string2, bl);
    }

    @NotNull
    public final String merge(@NotNull String txt, @NotNull SortedMap<Integer, Integer> idx, @NotNull String tbl) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter(idx, (String)"idx");
        Intrinsics.checkNotNullParameter((Object)tbl, (String)"tbl");
        if (idx.isEmpty()) {
            return txt;
        }
        int len = txt.length();
        StringBuilder buff = new StringBuilder(len * 3 / 2);
        int off = 0;
        for (Map.Entry entry : ((Map)idx).entrySet()) {
            Integer p1 = (Integer)entry.getKey();
            Integer p2 = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)p1);
            if (p1 > off) {
                buff.append(txt, off, (int)p1);
            }
            buff.append(tbl);
            Intrinsics.checkNotNull((Object)p2);
            off = p2;
        }
        boolean bl = 1 <= off ? off < len : false;
        if (bl) {
            buff.append(txt, off, len);
        }
        String string = buff.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String merge(@NotNull String txt, @NotNull SortedMap<Integer, Pair<Integer, String>> idx, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter(idx, (String)"idx");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (idx.isEmpty()) {
            return txt;
        }
        int len = txt.length();
        StringBuilder buf = new StringBuilder(len * 3);
        int off = 0;
        for (Map.Entry entry : ((Map)idx).entrySet()) {
            Integer p1 = (Integer)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            int p2 = ((Number)pair.component1()).intValue();
            String tkn = (String)pair.component2();
            Intrinsics.checkNotNull((Object)p1);
            if (p1 > off) {
                buf.append(txt, off, (int)p1);
            }
            buf.append(map.get(tkn));
            off = p2;
        }
        boolean bl = 1 <= off ? off < len : false;
        if (bl) {
            buf.append(txt, off, len);
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final SortedMap<Integer, Pair<Integer, String>> parse(@NotNull String txt, @NotNull List<String> tkn, @NotNull String qto, boolean bnd) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter(tkn, (String)"tkn");
        Intrinsics.checkNotNullParameter((Object)qto, (String)"qto");
        TreeMap idx = new TreeMap();
        if (tkn.isEmpty() || StringsKt.isBlank((CharSequence)txt)) {
            return idx;
        }
        String msk = this.maskQuote(txt, qto);
        TreeMap<Integer, Integer> ix = new TreeMap<Integer, Integer>();
        for (String tk : tkn) {
            if (((CharSequence)tk).length() == 0) continue;
            this.parse(msk, tk, ix, bnd);
            for (Map.Entry entry : ((Map)ix).entrySet()) {
                int p1 = ((Number)entry.getKey()).intValue();
                int p2 = ((Number)entry.getValue()).intValue();
                Integer n = p1;
                ((Map)idx).put(n, new Pair((Object)p2, (Object)tk));
            }
            ix.clear();
        }
        int e2 = -1;
        Iterator iter = idx.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Intrinsics.checkNotNull(entry);
            Integer n = (Integer)entry.getKey();
            Pair p2 = (Pair)entry.getValue();
            Intrinsics.checkNotNull((Object)n);
            if (n < e2) {
                iter.remove();
                continue;
            }
            e2 = ((Number)p2.getFirst()).intValue();
        }
        return idx;
    }

    public static /* synthetic */ SortedMap parse$default(TemplateUtil templateUtil, String string, List list, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "'";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return templateUtil.parse(string, list, string2, bl);
    }

    @NotNull
    public final SortedMap<Integer, Integer> parse(@NotNull String txt, @NotNull String tkn, @NotNull String qto, boolean bnd) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)tkn, (String)"tkn");
        Intrinsics.checkNotNullParameter((Object)qto, (String)"qto");
        TreeMap<Integer, Integer> idx = new TreeMap<Integer, Integer>();
        if (StringsKt.isBlank((CharSequence)tkn) || StringsKt.isBlank((CharSequence)txt)) {
            return idx;
        }
        String msk = this.maskQuote(txt, qto);
        this.parse(msk, tkn, idx, bnd);
        return idx;
    }

    public static /* synthetic */ SortedMap parse$default(TemplateUtil templateUtil, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "'";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return templateUtil.parse(string, string2, string3, bl);
    }

    private final void parse(String msk, String tkn, TreeMap<Integer, Integer> idx, boolean bnd) {
        int i;
        if (StringsKt.isBlank((CharSequence)msk) || StringsKt.isBlank((CharSequence)tkn)) {
            return;
        }
        int len = tkn.length();
        int off = 0;
        while ((i = StringsKt.indexOf((CharSequence)msk, (String)tkn, (int)off, (boolean)true)) >= 0) {
            int end = i + len;
            if (bnd) {
                boolean bgn;
                boolean bl = bgn = i == 0 || TemplateUtil.isBoundary$default(this, msk, i - 1, false, 4, null);
                if (bgn && TemplateUtil.isBoundary$default(this, msk, end, false, 4, null)) {
                    var11_11 = i;
                    Integer n = end;
                    ((Map)idx).put(var11_11, n);
                }
            } else {
                Integer n = i;
                var11_11 = end;
                ((Map)idx).put(n, var11_11);
            }
            off = end;
        }
    }

    static /* synthetic */ void parse$default(TemplateUtil templateUtil, String string, String string2, TreeMap treeMap, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        templateUtil.parse(string, string2, treeMap, bl);
    }

    @NotNull
    public final String maskQuote(@NotNull String txt, @NotNull String qto) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)qto, (String)"qto");
        if (StringsKt.isBlank((CharSequence)txt) || StringsKt.isBlank((CharSequence)qto)) {
            return txt;
        }
        int off = 0;
        int idx = 0;
        boolean fnd = false;
        char[] cArray = txt.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] buf = cArray;
        int n = qto.length();
        for (int i = 0; i < n; ++i) {
            char chr = qto.charAt(i);
            off = 0;
            idx = StringsKt.indexOf$default((CharSequence)txt, (char)chr, (int)off, (boolean)false, (int)4, null);
            while (idx >= 0) {
                int end = this.findQuoteEnd(txt, idx);
                if (end > idx) {
                    off = end + 1;
                    ArraysKt.fill((char[])buf, (char)' ', (int)idx, (int)off);
                    fnd = true;
                } else {
                    off = idx + 1;
                }
                idx = StringsKt.indexOf$default((CharSequence)txt, (char)chr, (int)off, (boolean)false, (int)4, null);
            }
        }
        return fnd ? new String(buf) : txt;
    }

    public static /* synthetic */ String maskQuote$default(TemplateUtil templateUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "'";
        }
        return templateUtil.maskQuote(string, string2);
    }

    public final int findQuoteEnd(@NotNull String txt, int idx) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        if (idx < 0 || idx >= txt.length() - 1) {
            return -1;
        }
        char chr = txt.charAt(idx);
        int off = idx + 1;
        int ix;
        while ((ix = StringsKt.indexOf$default((CharSequence)txt, (char)chr, (int)off, (boolean)false, (int)4, null)) >= 0) {
            char c;
            int cnt = 0;
            for (int qtc = ix - 1; qtc > 0 && (c = txt.charAt(qtc)) == '\\'; --qtc) {
                ++cnt;
            }
            if (cnt % 2 == 0) {
                return ix;
            }
            off = ix + 1;
        }
        return -1;
    }

    public final boolean isBoundary(@NotNull String txt, int idx, boolean dollar) {
        boolean bl;
        block2: {
            char c;
            block1: {
                Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
                if (idx <= 0 || idx >= txt.length() - 1) {
                    return true;
                }
                c = txt.charAt(idx);
                boolean bl2 = 'A' <= c ? c < '[' : false;
                if (!bl2) break block1;
                bl = false;
                break block2;
            }
            bl = ('a' <= c ? c < '{' : false) ? false : (('0' <= c ? c < ':' : false) ? false : (c == '_' ? false : (c == '$' ? dollar : c <= '\u007f' || txt.charAt(idx - 1) <= '\u007f')));
        }
        return bl;
    }

    public static /* synthetic */ boolean isBoundary$default(TemplateUtil templateUtil, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return templateUtil.isBoundary(string, n, bl);
    }

    public final boolean isBoundary(@NotNull String txt, @NotNull String sub, boolean dollar) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        if (((CharSequence)txt).length() == 0 || ((CharSequence)sub).length() == 0) {
            return false;
        }
        int off = 0;
        int len = sub.length();
        int i;
        while ((i = StringsKt.indexOf((CharSequence)txt, (String)sub, (int)off, (boolean)true)) >= 0) {
            int end = i + len;
            if (this.isBoundary(txt, i - 1, dollar) && this.isBoundary(txt, end, dollar)) {
                return true;
            }
            off = end;
        }
        return false;
    }

    public static /* synthetic */ boolean isBoundary$default(TemplateUtil templateUtil, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return templateUtil.isBoundary(string, string2, bl);
    }
}

