/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.util;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FlywaveInteractiveGui {
    private static final LinkedList<BiConsumer<String, String>> hooked;

    public static Function<String, Boolean> askGui() {
        return msg -> {
            int res;
            do {
                if ((res = JOptionPane.showConfirmDialog(null, msg, "\ud83d\ude3a\ud83d\ude38\ud83d\ude39\ud83d\ude3b\ud83d\ude3c\ud83d\ude3d\ud83d\ude40\ud83d\ude3f\ud83d\ude3e\ud83d\ude3a", 0, 2)) != 0) continue;
                return true;
            } while (res != 1);
            return false;
        };
    }

    public static BiConsumer<String, String> logGui() {
        BiConsumer<String, String> fun = new BiConsumer<String, String>(){
            private final AtomicInteger counter = new AtomicInteger(0);
            private final JTextPane textPane = new JTextPane();
            private final Pattern colorPattern;
            {
                JScrollPane scrollPang = new JScrollPane(this.textPane);
                JFrame frame = new JFrame("\ud83d\ude3a\ud83d\ude38\ud83d\ude39\ud83d\ude3b\ud83d\ude3c\ud83d\ude3d\ud83d\ude40\ud83d\ude3f\ud83d\ude3e\ud83d\ude3a");
                frame.setDefaultCloseOperation(0);
                frame.add(scrollPang);
                frame.setSize(1200, 800);
                frame.setLocationRelativeTo(null);
                frame.setState(0);
                frame.toFront();
                frame.requestFocus();
                frame.setVisible(true);
                this.colorPattern = Pattern.compile("(ERROR|WARN|\\d{10,})");
            }

            @Override
            public void accept(String s1, String s2) {
                String[] pt = s1.split("\\|", 2);
                String lvl = "INFO";
                String slf = s1;
                if (pt.length == 2) {
                    lvl = pt[0];
                    slf = pt[1];
                }
                String msg = s2.replace('\n', ' ').trim();
                String line = String.format("%03d %5s %-18s %s\n", this.counter.incrementAndGet(), lvl, slf, msg);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.insertString(line);
                } else {
                    SwingUtilities.invokeLater(() -> this.insertString(line));
                }
            }

            private void insertString(String line) {
                Matcher matcher = this.colorPattern.matcher(line);
                int off = 0;
                LinkedHashMap<String, SimpleAttributeSet> parts = new LinkedHashMap<String, SimpleAttributeSet>();
                while (matcher.find()) {
                    Color color;
                    SimpleAttributeSet at1 = new SimpleAttributeSet(this.textPane.getInputAttributes());
                    StyleConstants.setForeground(at1, Color.BLACK);
                    parts.put(line.substring(off, matcher.start()), at1);
                    Object key = matcher.group(1);
                    if ("ERROR".equalsIgnoreCase((String)key)) {
                        color = Color.PINK;
                    } else if ("WARN".equalsIgnoreCase((String)key)) {
                        color = Color.ORANGE;
                    } else {
                        color = Color.MAGENTA;
                        key = ((String)key).substring(0, 4) + "-" + ((String)key).substring(4, 8) + "-" + ((String)key).substring(8);
                    }
                    SimpleAttributeSet at2 = new SimpleAttributeSet(this.textPane.getInputAttributes());
                    StyleConstants.setForeground(at2, color);
                    parts.put((String)key, at2);
                    off = matcher.end();
                }
                if (off < line.length()) {
                    SimpleAttributeSet attributes = new SimpleAttributeSet(this.textPane.getInputAttributes());
                    StyleConstants.setForeground(attributes, Color.BLACK);
                    parts.put(line.substring(off), attributes);
                }
                try {
                    StyledDocument styled = this.textPane.getStyledDocument();
                    Document doc = this.textPane.getDocument();
                    for (Map.Entry entry : parts.entrySet()) {
                        styled.insertString(doc.getLength(), (String)entry.getKey(), (AttributeSet)entry.getValue());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        if (hooked.isEmpty()) {
            hooked.add(fun);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                int res = JOptionPane.showConfirmDialog(null, "The program exit, Please check ASAP!\nFocus on ERROR, more in the logger.\n\n[yes] Exit\n[no] show console, and press ENTER to exit", "\ud83d\ude3a\ud83d\ude38\ud83d\ude39\ud83d\ude3b\ud83d\ude3c\ud83d\ude3d\ud83d\ude40\ud83d\ude3f\ud83d\ude3e\ud83d\ude3a", 0, 2);
                if (res != 0) {
                    try {
                        for (BiConsumer biConsumer : hooked) {
                            biConsumer.accept("WARN", "The program exit, press ENTER to exit.");
                        }
                        System.out.println("The program exit, waiting for in.read() to keep the log window");
                        System.out.println("press ENTER to exit");
                        System.in.read();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }
        return fun;
    }

    public static void main(String[] args) {
        BiConsumer<String, String> log = FlywaveInteractiveGui.logGui();
        log.accept("INFO", "message 1");
        log.accept("WARN", "message 2");
        log.accept("ERROR", "message 3");
    }

    static {
        System.setProperty("java.awt.headless", "false");
        Font font = new Font("Monospaced", 0, 12);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        hooked = new LinkedList();
    }
}

