/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import pro.fessional.wings.faceless.flywave.InteractiveManager;
import pro.fessional.wings.faceless.flywave.SchemaDefinitionLoader;
import pro.fessional.wings.faceless.flywave.SchemaShardingManager;
import pro.fessional.wings.faceless.flywave.SqlSegmentProcessor;
import pro.fessional.wings.faceless.flywave.SqlStatementParser;
import pro.fessional.wings.faceless.flywave.impl.DefaultInteractiveManager;
import pro.fessional.wings.faceless.flywave.util.SimpleJdbcTemplate;
import pro.fessional.wings.faceless.flywave.util.TemplateUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B3\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017H\u0016J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u0014R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaShardingManager;", "Lpro/fessional/wings/faceless/flywave/InteractiveManager;", "Lpro/fessional/wings/faceless/flywave/SchemaShardingManager$AskType;", "plainDataSources", "", "", "Ljavax/sql/DataSource;", "shardDataSource", "sqlStatementParser", "Lpro/fessional/wings/faceless/flywave/SqlStatementParser;", "schemaDefinitionLoader", "Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader;", "(Ljava/util/Map;Ljavax/sql/DataSource;Lpro/fessional/wings/faceless/flywave/SqlStatementParser;Lpro/fessional/wings/faceless/flywave/SchemaDefinitionLoader;)V", "interactive", "Lpro/fessional/wings/faceless/flywave/impl/DefaultInteractiveManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "askWay", "Ljava/util/function/Function;", "", "func", "logWay", "Ljava/util/function/BiConsumer;", "needAsk", "ask", "yes", "(Lpro/fessional/wings/faceless/flywave/SchemaShardingManager$AskType;Z)Ljava/lang/Boolean;", "publishShard", "", "table", "number", "", "shardingData", "stopOnError", "AskType", "faceless-flywave"})
@SourceDebugExtension(value={"SMAP\nSchemaShardingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaShardingManager.kt\npro/fessional/wings/faceless/flywave/SchemaShardingManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,351:1\n1549#2:352\n1620#2,3:353\n26#3:356\n*S KotlinDebug\n*F\n+ 1 SchemaShardingManager.kt\npro/fessional/wings/faceless/flywave/SchemaShardingManager\n*L\n146#1:352\n146#1:353,3\n346#1:356\n*E\n"})
public final class SchemaShardingManager
implements InteractiveManager<AskType> {
    @NotNull
    private final Map<String, DataSource> plainDataSources;
    @Nullable
    private final DataSource shardDataSource;
    @NotNull
    private final SqlStatementParser sqlStatementParser;
    @NotNull
    private final SchemaDefinitionLoader schemaDefinitionLoader;
    private final Logger log;
    @NotNull
    private final DefaultInteractiveManager<AskType> interactive;

    public SchemaShardingManager(@NotNull Map<String, ? extends DataSource> plainDataSources, @Nullable DataSource shardDataSource, @NotNull SqlStatementParser sqlStatementParser, @NotNull SchemaDefinitionLoader schemaDefinitionLoader) {
        Intrinsics.checkNotNullParameter(plainDataSources, (String)"plainDataSources");
        Intrinsics.checkNotNullParameter((Object)sqlStatementParser, (String)"sqlStatementParser");
        Intrinsics.checkNotNullParameter((Object)schemaDefinitionLoader, (String)"schemaDefinitionLoader");
        this.plainDataSources = plainDataSources;
        this.shardDataSource = shardDataSource;
        this.sqlStatementParser = sqlStatementParser;
        this.schemaDefinitionLoader = schemaDefinitionLoader;
        Logger logger = this.log = LoggerFactory.getLogger(SchemaShardingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        this.interactive = new DefaultInteractiveManager(logger, this.plainDataSources, "\ud83d\udc35");
    }

    @Override
    @NotNull
    public BiConsumer<String, String> logWay(@NotNull BiConsumer<String, String> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.interactive.logWay(func);
    }

    @Override
    @NotNull
    public Function<String, Boolean> askWay(@NotNull Function<String, Boolean> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.interactive.askWay(func);
    }

    @Override
    @Nullable
    public Boolean needAsk(@NotNull AskType ask, boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)ask), (String)"ask");
        return this.interactive.needAsk(ask, yes);
    }

    /*
     * WARNING - void declaration
     */
    public final void publishShard(@NotNull String table, int number) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String here = "publishShard";
        DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "start publishShard table=" + table + ", number=" + number, null, 8, null);
        for (Map.Entry<String, DataSource> entry : this.plainDataSources.entrySet()) {
            void $this$mapTo$iv$iv;
            Object object;
            Object old;
            String plainName = entry.getKey();
            DataSource plainDs = entry.getValue();
            DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "ready publishShard table=" + table + ", db=" + plainName, null, 8, null);
            List<String> allTables = this.schemaDefinitionLoader.showTables(plainDs);
            HashMap shardAll = new HashMap();
            int shardBgn = table.length() + 1;
            for (String tbl : allTables) {
                if (SqlSegmentProcessor.Companion.hasType(table, tbl) != 2) continue;
                Map map = shardAll;
                String string = tbl.substring(shardBgn);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                map.put(tbl, Integer.parseInt(string));
            }
            HashMap shardReb = new HashMap();
            HashMap shardNew = new HashMap();
            for (int i = 0; i < number; ++i) {
                Integer n;
                String tbl = table + "_" + i;
                old = (Integer)shardAll.remove(tbl);
                if (old == null) {
                    n = i;
                    ((Map)shardNew).put(n, tbl);
                    continue;
                }
                n = i;
                ((Map)shardReb).put(n, tbl);
            }
            SimpleJdbcTemplate tmpl = new SimpleJdbcTemplate(plainDs, plainName);
            boolean hasError = false;
            old = ((Map)shardAll).entrySet().iterator();
            while (old.hasNext()) {
                String tbl = (String)((Map.Entry)old.next()).getKey();
                int cnt = tmpl.count("SELECT COUNT(1) FROM " + tbl, new Object[0]);
                String drop = "DROP TABLE " + this.sqlStatementParser.safeName(tbl);
                if (cnt == 0) {
                    DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "drop unused empty shard table=" + table + ", db=" + plainName, null, 8, null);
                    if (this.interactive.needAsk(AskType.DropTable)) {
                        DefaultInteractiveManager.ask$default(this.interactive, "continue?\ndrop unused empty shard table=" + table, false, 2, null);
                    }
                    tmpl.execute(drop);
                    continue;
                }
                hasError = true;
                DefaultInteractiveManager.log$default(this.interactive, Level.ERROR, here, "ignore drop table with " + cnt + " records, table=" + table + ", db=" + plainName + ", sql=" + drop, null, 8, null);
            }
            for (Map.Entry entry2 : ((Map)shardReb).entrySet()) {
                boolean canDrop;
                boolean bl;
                int idx = ((Number)entry2.getKey()).intValue();
                String tbl = (String)entry2.getValue();
                int cnt = tmpl.count("SELECT COUNT(1) FROM " + tbl, new Object[0]);
                if (cnt == 0) {
                    bl = true;
                } else {
                    String diff = SchemaDefinitionLoader.DefaultImpls.diffFullSame$default(this.schemaDefinitionLoader, plainDs, table, tbl, 0, 8, null);
                    if (((CharSequence)diff).length() == 0) {
                        bl = true;
                    } else {
                        hasError = true;
                        DefaultInteractiveManager.log$default(this.interactive, Level.ERROR, here, "ignore existed diff shard=" + tbl + ", db=" + plainName + " , diff=" + diff, null, 8, null);
                        bl = false;
                    }
                }
                if (!(canDrop = bl)) continue;
                String drop = "DROP TABLE " + this.sqlStatementParser.safeName(tbl);
                DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "drop empty shard table then recreate it, table=" + table + ", db=" + plainName, null, 8, null);
                if (this.interactive.needAsk(AskType.DropTable)) {
                    DefaultInteractiveManager.ask$default(this.interactive, "continue?\ndrop empty shard table then recreate it, table=" + table, false, 2, null);
                }
                tmpl.execute(drop);
                object = idx;
                ((Map)shardNew).put(object, tbl);
            }
            if (hasError) {
                DefaultInteractiveManager.log$default(this.interactive, Level.ERROR, here, "need manually handle above errors to continue, table=" + table + ", db=" + plainName, null, 8, null);
                if (!this.interactive.needAsk(AskType.ManualCheck)) continue;
                DefaultInteractiveManager.ask$default(this.interactive, "continue?\nskip above errors and continue next, table=" + table, false, 2, null);
                continue;
            }
            Iterable iterable = this.schemaDefinitionLoader.showFullDdl(plainDs, table);
            boolean $i$f$map = false;
            Object tbl = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it, (Object)TemplateUtil.parse$default(TemplateUtil.INSTANCE, (String)it, table, null, false, 12, null)));
            }
            List ddls = (List)destination$iv$iv;
            Iterator iterator = ((Map)shardNew).entrySet().iterator();
            while (iterator.hasNext()) {
                tbl = (String)iterator.next().getValue();
                DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "create shard table, table=" + table + ", db=" + plainName, null, 8, null);
                for (Pair pair : ddls) {
                    String ddl = (String)pair.component1();
                    SortedMap idx = (SortedMap)pair.component2();
                    String sql = TemplateUtil.INSTANCE.merge(ddl, idx, (String)tbl);
                    DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "running db=" + plainName + ", ddl=" + sql, null, 8, null);
                    tmpl.execute(sql);
                }
            }
        }
        DefaultInteractiveManager.log$default(this.interactive, Level.INFO, here, "done publishShard table=" + table + ", number=" + number, null, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shardingData(@NotNull String table, boolean stopOnError) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (this.shardDataSource == null) {
            this.log.error("[shardingData]\ud83d\udc35 can NOT shard without sharding datasource, table={}", (Object)table);
            return;
        }
        LinkedList<String> pks = new LinkedList<String>();
        LinkedList<String> cls = new LinkedList<String>();
        AutoCloseable autoCloseable = this.plainDataSources.values().iterator().next().getConnection();
        Throwable throwable = null;
        try {
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            String cate = conn.getCatalog();
            String schm = conn.getSchema();
            DatabaseMetaData meta = conn.getMetaData();
            AutoCloseable autoCloseable2 = meta.getPrimaryKeys(cate, schm, table);
            Throwable throwable2 = null;
            try {
                ResultSet rs2 = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                while (rs2.next()) {
                    pks.add(rs2.getString("COLUMN_NAME"));
                }
                rs2 = Unit.INSTANCE;
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            autoCloseable2 = meta.getColumns(cate, schm, table, null);
            throwable2 = null;
            try {
                Object rs3 = (ResultSet)autoCloseable2;
                boolean entry = false;
                while (rs3.next()) {
                    cls.add(rs3.getString("COLUMN_NAME"));
                }
                rs3 = Unit.INSTANCE;
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            conn = Unit.INSTANCE;
        }
        catch (Throwable conn) {
            throwable = conn;
            throw conn;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (pks.isEmpty()) {
            this.log.error("[shardingData]\ud83d\udc35 can NOT shard without pk, table={}", (Object)table);
            return;
        }
        AtomicInteger selectCounter = new AtomicInteger(0);
        AtomicInteger insertCounter = new AtomicInteger(0);
        AtomicInteger deleteCounter = new AtomicInteger(0);
        LinkedBlockingQueue<Triple<String, Object[], Object[]>> insertQueue = new LinkedBlockingQueue<Triple<String, Object[], Object[]>>(1024);
        LinkedBlockingQueue<Pair<String, Object[]>> deleteQueue = new LinkedBlockingQueue<Pair<String, Object[]>>(1024);
        String safeTable = this.sqlStatementParser.safeName(table);
        String string = "DELETE FROM " + safeTable + " WHERE " + CollectionsKt.joinToString$default((Iterable)pks, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ SchemaShardingManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SchemaShardingManager.access$getSqlStatementParser$p(this.this$0).safeName(it) + "=?";
            }
        }), (int)31, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String deleteStmt2 = string;
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"flywave-shard-insert", (int)0, (Function0)((Function0)new Function0<Unit>(insertQueue, safeTable, cls, this, table, stopOnError, deleteQueue, insertCounter){
            final /* synthetic */ LinkedBlockingQueue<Triple<String, Object[], Object[]>> $insertQueue;
            final /* synthetic */ String $safeTable;
            final /* synthetic */ LinkedList<String> $cls;
            final /* synthetic */ SchemaShardingManager this$0;
            final /* synthetic */ String $table;
            final /* synthetic */ boolean $stopOnError;
            final /* synthetic */ LinkedBlockingQueue<Pair<String, Object[]>> $deleteQueue;
            final /* synthetic */ AtomicInteger $insertCounter;
            {
                this.$insertQueue = $insertQueue;
                this.$safeTable = $safeTable;
                this.$cls = $cls;
                this.this$0 = $receiver;
                this.$table = $table;
                this.$stopOnError = $stopOnError;
                this.$deleteQueue = $deleteQueue;
                this.$insertCounter = $insertCounter;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Triple<String, Object[], Object[]> triple = this.$insertQueue.take();
                String string = "INSERT INTO " + this.$safeTable + "(" + CollectionsKt.joinToString$default((Iterable)this.$cls, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this.this$0){
                    final /* synthetic */ SchemaShardingManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return SchemaShardingManager.access$getSqlStatementParser$p(this.this$0).safeName(it);
                    }
                }), (int)31, null) + ") VALUES (" + CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, ((Object[])triple.getThird()).length)), null, null, null, (int)0, null, (Function1)shardingData.insertStmt.2.INSTANCE, (int)31, null) + ")";
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String insertStmt2 = string;
                SimpleJdbcTemplate shardTmpl = new SimpleJdbcTemplate(SchemaShardingManager.access$getShardDataSource$p(this.this$0), "sharding");
                try {
                    while (true) {
                        int n;
                        Triple<String, Object[], Object[]> triple2 = triple;
                        String dsName = (String)triple2.component1();
                        Object[] keys = (Object[])triple2.component2();
                        Object[] vals = (Object[])triple2.component3();
                        if (keys.length == 0) {
                            break;
                        }
                        try {
                            n = shardTmpl.update(insertStmt2, Arrays.copyOf(vals, vals.length));
                        }
                        catch (Exception e) {
                            String err = "[shardingData]\ud83d\udc35 failed to insert records shard table=" + this.$table + ", values=" + ArraysKt.joinToString$default((Object[])vals, null, null, null, (int)0, null, null, (int)63, null);
                            if (this.$stopOnError) {
                                throw new IllegalStateException(err, e);
                            }
                            SchemaShardingManager.access$getLog$p(this.this$0).error(err, (Throwable)e);
                            continue;
                        }
                        int rst = n;
                        if (rst == 1) {
                            this.$deleteQueue.offer((Pair<String, Object[]>)new Pair((Object)dsName, (Object)keys));
                            int cnt = this.$insertCounter.incrementAndGet();
                            if (cnt % 100 == 0) {
                                SchemaShardingManager.access$getLog$p(this.this$0).info("[shardingData]\ud83d\udc35 insert {} records on shard table={}", (Object)cnt, (Object)this.$table);
                            }
                        } else {
                            String err = "[shardingData]\ud83d\udc35 failed, insert " + rst + " records, shard table=" + this.$table;
                            if (this.$stopOnError) {
                                throw new IllegalStateException(err);
                            }
                            SchemaShardingManager.access$getLog$p(this.this$0).error(err);
                        }
                        triple = this.$insertQueue.take();
                    }
                }
                finally {
                    boolean $i$f$emptyArray = false;
                    this.$deleteQueue.offer((Pair<String, Object[]>)new Pair((Object)"", (Object)new Object[0]));
                    SchemaShardingManager.access$getLog$p(this.this$0).info("[shardingData]\ud83d\udc35 finished, total insert {} records on table={}", (Object)this.$insertCounter.get(), (Object)this.$table);
                }
            }
        }), (int)23, null);
        CountDownLatch latch = new CountDownLatch(1);
        ConcurrentHashMap<String, SimpleJdbcTemplate> tmplMap = new ConcurrentHashMap<String, SimpleJdbcTemplate>();
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"flywave-shard-delete", (int)0, (Function0)((Function0)new Function0<Unit>(deleteQueue, tmplMap, deleteStmt2, table, stopOnError, this, deleteCounter, latch){
            final /* synthetic */ LinkedBlockingQueue<Pair<String, Object[]>> $deleteQueue;
            final /* synthetic */ ConcurrentHashMap<String, SimpleJdbcTemplate> $tmplMap;
            final /* synthetic */ String $deleteStmt;
            final /* synthetic */ String $table;
            final /* synthetic */ boolean $stopOnError;
            final /* synthetic */ SchemaShardingManager this$0;
            final /* synthetic */ AtomicInteger $deleteCounter;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$deleteQueue = $deleteQueue;
                this.$tmplMap = $tmplMap;
                this.$deleteStmt = $deleteStmt;
                this.$table = $table;
                this.$stopOnError = $stopOnError;
                this.this$0 = $receiver;
                this.$deleteCounter = $deleteCounter;
                this.$latch = $latch;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    while (true) {
                        int n;
                        Pair<String, Object[]> pair = this.$deleteQueue.take();
                        String plainName = (String)pair.component1();
                        Object[] vals = (Object[])pair.component2();
                        if (vals.length == 0) {
                            break;
                        }
                        try {
                            SimpleJdbcTemplate simpleJdbcTemplate = this.$tmplMap.get(plainName);
                            Intrinsics.checkNotNull((Object)simpleJdbcTemplate);
                            n = simpleJdbcTemplate.update(this.$deleteStmt, Arrays.copyOf(vals, vals.length));
                        }
                        catch (Exception e) {
                            String err = "[shardingData]\ud83d\udc35 failed to delete records, table=" + this.$table + ", db=" + plainName + ", pks=" + ArraysKt.joinToString$default((Object[])vals, null, null, null, (int)0, null, null, (int)63, null);
                            if (this.$stopOnError) {
                                throw new IllegalStateException(err, e);
                            }
                            SchemaShardingManager.access$getLog$p(this.this$0).error(err, (Throwable)e);
                            continue;
                        }
                        int rst = n;
                        String vls = ArraysKt.joinToString$default((Object[])vals, null, null, null, (int)0, null, null, (int)63, null);
                        if (rst == 1) {
                            int cnt = this.$deleteCounter.incrementAndGet();
                            Object[] objectArray = new Object[]{cnt, this.$table, plainName, vls};
                            SchemaShardingManager.access$getLog$p(this.this$0).info("[shardingData]\ud83d\udc35 delete {} records on table={}, db={}, pks={}", objectArray);
                            continue;
                        }
                        String err = "[shardingData]\ud83d\udc35 delete " + rst + " records, table=" + this.$table + ", db=" + plainName + ", pks=" + vls;
                        if (this.$stopOnError) {
                            throw new IllegalStateException(err);
                        }
                        SchemaShardingManager.access$getLog$p(this.this$0).error(err);
                    }
                }
                finally {
                    SchemaShardingManager.access$getLog$p(this.this$0).info("[shardingData]\ud83d\udc35 finished, total delete {} records on table={}", (Object)this.$deleteCounter.get(), (Object)this.$table);
                    this.$latch.countDown();
                }
            }
        }), (int)23, null);
        for (Map.Entry entry : this.plainDataSources.entrySet()) {
            String plainName = (String)entry.getKey();
            DataSource plainDs = (DataSource)entry.getValue();
            this.log.info("[shardingData]\ud83d\udc35 move data from plain db={}, table={}", (Object)plainName, (Object)table);
            SimpleJdbcTemplate plainTmpl = new SimpleJdbcTemplate(plainDs, plainName);
            ((Map)tmplMap).put(plainName, plainTmpl);
            int count = plainTmpl.count("SELECT COUNT(1) FROM " + table, new Object[0]);
            Object[] objectArray = new Object[]{count, table, plainName};
            this.log.info("[shardingData]\ud83d\udc35 find {} records on table={}, db={}", objectArray);
            int lastCnt = selectCounter.get();
            plainTmpl.query("SELECT * FROM " + safeTable, new Object[0], (Function1<? super ResultSet, Unit>)((Function1)new Function1<ResultSet, Unit>(pks, insertQueue, plainName, selectCounter, this, table){
                final /* synthetic */ LinkedList<String> $pks;
                final /* synthetic */ LinkedBlockingQueue<Triple<String, Object[], Object[]>> $insertQueue;
                final /* synthetic */ String $plainName;
                final /* synthetic */ AtomicInteger $selectCounter;
                final /* synthetic */ SchemaShardingManager this$0;
                final /* synthetic */ String $table;
                {
                    this.$pks = $pks;
                    this.$insertQueue = $insertQueue;
                    this.$plainName = $plainName;
                    this.$selectCounter = $selectCounter;
                    this.this$0 = $receiver;
                    this.$table = $table;
                    super(1);
                }

                public final void invoke(@NotNull ResultSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = 0;
                    int n2 = this.$pks.size();
                    Object[] objectArray = new Object[n2];
                    while (n < n2) {
                        int n3 = n++;
                        objectArray[n3] = Unit.INSTANCE;
                    }
                    Object[] keys = objectArray;
                    Iterator<E> iterator = this.$pks.iterator();
                    n2 = 0;
                    while (iterator.hasNext()) {
                        int i = n2++;
                        String k = (String)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)it.getObject(k), (String)"getObject(...)");
                    }
                    n2 = 0;
                    int n4 = it.getMetaData().getColumnCount();
                    Object[] objectArray2 = new Object[n4];
                    while (n2 < n4) {
                        int n5 = n2++;
                        objectArray2[n5] = Unit.INSTANCE;
                    }
                    Object[] vals = objectArray2;
                    n4 = vals.length;
                    for (int i = 0; i < n4; ++i) {
                        Intrinsics.checkNotNullExpressionValue((Object)it.getObject(i + 1), (String)"getObject(...)");
                    }
                    this.$insertQueue.offer((Triple<String, Object[], Object[]>)new Triple((Object)this.$plainName, (Object)keys, (Object)vals));
                    int cnt = this.$selectCounter.incrementAndGet();
                    if (cnt % 100 == 0) {
                        Object[] objectArray3 = new Object[]{cnt, this.$table, this.$plainName};
                        SchemaShardingManager.access$getLog$p(this.this$0).info("[shardingData]\ud83d\udc35 select {} records on table={}, db={}", objectArray3);
                    }
                }
            }));
            Object[] objectArray2 = new Object[]{selectCounter.get() - lastCnt, table, plainName};
            this.log.info("[shardingData]\ud83d\udc35 finish one select. {} records on table={}, db={}", objectArray2);
        }
        boolean $i$f$emptyArray = false;
        $i$f$emptyArray = false;
        insertQueue.offer((Triple<String, Object[], Object[]>)new Triple((Object)"", (Object)new Object[0], (Object)new Object[0]));
        this.log.info("[shardingData]\ud83d\udc35 finish all select. {} records on table={}, and wait for insert and delete done", (Object)selectCounter.get(), (Object)table);
        latch.await();
    }

    public static /* synthetic */ void shardingData$default(SchemaShardingManager schemaShardingManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaShardingManager.shardingData(string, bl);
    }

    public static final /* synthetic */ SqlStatementParser access$getSqlStatementParser$p(SchemaShardingManager $this) {
        return $this.sqlStatementParser;
    }

    public static final /* synthetic */ DataSource access$getShardDataSource$p(SchemaShardingManager $this) {
        return $this.shardDataSource;
    }

    public static final /* synthetic */ Logger access$getLog$p(SchemaShardingManager $this) {
        return $this.log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lpro/fessional/wings/faceless/flywave/SchemaShardingManager$AskType;", "", "(Ljava/lang/String;I)V", "DropTable", "ManualCheck", "faceless-flywave"})
    public static final class AskType
    extends Enum<AskType> {
        public static final /* enum */ AskType DropTable = new AskType();
        public static final /* enum */ AskType ManualCheck = new AskType();
        private static final /* synthetic */ AskType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AskType[] values() {
            return (AskType[])$VALUES.clone();
        }

        public static AskType valueOf(String value) {
            return Enum.valueOf(AskType.class, value);
        }

        @NotNull
        public static EnumEntries<AskType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = askTypeArray = new AskType[]{AskType.DropTable, AskType.ManualCheck};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

