/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.faceless.flywave.SqlStatementParser;
import pro.fessional.wings.faceless.flywave.util.TemplateUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor;", "", "commentSingle", "", "commentMultiple", "delimiterDefault", "delimiterCommand", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "blockComment1", "blockComment2", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "singleComment", "merge", "segment", "Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Segment;", "newTbl", "", "parse", "", "statementParser", "Lpro/fessional/wings/faceless/flywave/SqlStatementParser;", "text", "Companion", "DbsType", "ErrType", "Segment", "faceless-flywave"})
public final class SqlSegmentProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log;
    @NotNull
    private final String singleComment;
    @NotNull
    private final String blockComment1;
    @NotNull
    private final String blockComment2;
    @NotNull
    private final String delimiterDefault;
    @NotNull
    private final String delimiterCommand;
    public static final int TYPE_OTHER = -1;
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_TRACE = 1;
    public static final int TYPE_SHARD = 2;
    @NotNull
    public static final String PLAIN_TABLE = "XXX";
    @NotNull
    public static final String SHARD_LINE_SEQ = "XXX_[0-9]+";
    @NotNull
    public static final String TRACE_DOLLAR = "XXX(_[0-9]+)?\\$[a-z]*";
    @NotNull
    public static final String TRACE_SU2_LINE = "XXX(_[0-9]+)?__+[a-z]*";
    @NotNull
    public static final String TRACE_PRE_LINE = "_+([a-z]+_+)?XXX(_[0-9]+)?";
    @NotNull
    private static Regex regShard = new Regex("XXX_[0-9]+", RegexOption.IGNORE_CASE);
    @NotNull
    private static Regex regTrace = new Regex("XXX(_[0-9]+)?__+[a-z]*", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex cmdReg = new Regex("([^@\\s]+)?\\s*@\\s*([^@\\s]+)", RegexOption.MULTILINE);

    public SqlSegmentProcessor(@NotNull String commentSingle, @NotNull String commentMultiple, @NotNull String delimiterDefault, @NotNull String delimiterCommand) {
        Intrinsics.checkNotNullParameter((Object)commentSingle, (String)"commentSingle");
        Intrinsics.checkNotNullParameter((Object)commentMultiple, (String)"commentMultiple");
        Intrinsics.checkNotNullParameter((Object)delimiterDefault, (String)"delimiterDefault");
        Intrinsics.checkNotNullParameter((Object)delimiterCommand, (String)"delimiterCommand");
        this.log = LoggerFactory.getLogger(SqlSegmentProcessor.class);
        this.singleComment = StringsKt.isBlank((CharSequence)commentSingle) ? "--" : ((Object)StringsKt.trim((CharSequence)commentSingle)).toString();
        this.log.debug("[init] use single-comment= {}", (Object)this.singleComment);
        if (StringsKt.isBlank((CharSequence)commentMultiple)) {
            this.blockComment1 = "/*";
            this.blockComment2 = "*/";
        } else {
            CharSequence charSequence = commentMultiple;
            Regex regex = new Regex("[ \t]+");
            int n = 2;
            List spt = regex.split(charSequence, n);
            this.blockComment1 = ((Object)StringsKt.trim((CharSequence)((String)spt.get(0)))).toString();
            this.blockComment2 = ((Object)StringsKt.trim((CharSequence)((String)spt.get(1)))).toString();
        }
        this.log.debug("[init] use multiple-comment={} {}", (Object)this.blockComment1, (Object)this.blockComment2);
        this.delimiterDefault = StringsKt.isBlank((CharSequence)delimiterDefault) ? ";" : ((Object)StringsKt.trim((CharSequence)delimiterDefault)).toString();
        this.log.debug("[init] use delimiter={}", (Object)this.delimiterDefault);
        this.delimiterCommand = StringsKt.isBlank((CharSequence)delimiterCommand) ? "DELIMITER" : ((Object)StringsKt.trim((CharSequence)delimiterCommand)).toString();
        this.log.debug("[init] use delimiter command={}", (Object)this.delimiterCommand);
    }

    public /* synthetic */ SqlSegmentProcessor(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "--";
        }
        if ((n & 2) != 0) {
            string2 = "/*   */";
        }
        if ((n & 4) != 0) {
            string3 = ";";
        }
        if ((n & 8) != 0) {
            string4 = "DELIMITER";
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final List<Segment> parse(@NotNull SqlStatementParser statementParser, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)statementParser, (String)"statementParser");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return CollectionsKt.emptyList();
        }
        this.log.debug("[parse] parse sql start");
        int lineBgn = -1;
        int dbsAnot = 0;
        String tblName = "";
        String tbApply = "";
        ErrType errType = ErrType.Stop;
        String askText = "";
        boolean trgJour = false;
        boolean inComment = false;
        int lineCur = 0;
        String delimiter = this.delimiterDefault;
        LinkedList<Segment> result = new LinkedList<Segment>();
        List lines = StringsKt.lines((CharSequence)text);
        int total = lines.size();
        StringBuilder builder = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        for (String line : lines) {
            ++lineCur;
            String ln = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (StringsKt.isBlank((CharSequence)ln)) continue;
            boolean sic = StringsKt.startsWith$default((String)ln, (String)this.singleComment, (boolean)false, (int)2, null);
            if (sic || !inComment && ((CharSequence)comment).length() > 0) {
                Companion.Opt mt;
                if (sic) {
                    v0 = Companion.parseCmd(ln, this.singleComment);
                } else {
                    String string = comment.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String ts = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    this.log.debug("[parse] multi-comment {}", (Object)ts);
                    comment.setLength(0);
                    v0 = mt = Companion.parseCmd(ts, this.blockComment1);
                }
                if (mt != null) {
                    this.log.debug("[parse] got annotation, line={} , options={}", (Object)lineCur, (Object)mt);
                    if (((CharSequence)mt.getTbl()).length() > 0) {
                        tblName = mt.getTbl();
                    }
                    if (StringsKt.contains((CharSequence)mt.getDbs(), (CharSequence)"shard", (boolean)true)) {
                        dbsAnot = 1;
                    } else if (StringsKt.contains((CharSequence)ln, (CharSequence)"plain", (boolean)true)) {
                        dbsAnot = -1;
                    }
                    if (((CharSequence)mt.getApl()).length() > 0) {
                        tbApply = mt.getApl();
                    }
                    if (StringsKt.contains((CharSequence)mt.getErs(), (CharSequence)"skip", (boolean)true)) {
                        errType = ErrType.Skip;
                    } else if (StringsKt.contains((CharSequence)mt.getErs(), (CharSequence)"stop", (boolean)true)) {
                        errType = ErrType.Stop;
                    }
                    if (((CharSequence)mt.getAsk()).length() > 0) {
                        askText = mt.getAsk();
                    }
                    if (mt.getTrg()) {
                        trgJour = true;
                    }
                }
                if (sic) continue;
            }
            boolean m1 = StringsKt.startsWith$default((String)ln, (String)this.blockComment1, (boolean)false, (int)2, null);
            boolean m2 = StringsKt.endsWith$default((String)ln, (String)this.blockComment2, (boolean)false, (int)2, null);
            if (m1 && m2) {
                comment.append(ln);
                inComment = false;
                continue;
            }
            if (m1) {
                inComment = true;
                comment.append(ln);
                continue;
            }
            if (m2) {
                comment.append('\n').append(ln);
                inComment = false;
                continue;
            }
            if (inComment) {
                comment.append('\n').append(ln);
                continue;
            }
            if (StringsKt.startsWith((String)ln, (String)this.delimiterCommand, (boolean)true)) {
                delimiter = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)ln, (String)this.delimiterCommand, null, (int)2, null))).toString();
                this.log.debug("[parse] got delimiter command, delimiter={}", (Object)delimiter);
                continue;
            }
            if (lineBgn < 0) {
                lineBgn = lineCur;
            }
            int idx = StringsKt.lastIndexOf$default((CharSequence)ln, (String)delimiter, (int)0, (boolean)true, (int)2, null);
            boolean den = false;
            if (idx >= 0) {
                String lst;
                int idl = StringsKt.indexOf$default((CharSequence)ln, (String)delimiter, (int)0, (boolean)true, (int)2, null);
                if (idl < idx) {
                    String string = ln.substring(idl + delimiter.length(), idx);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    v3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                } else {
                    String string = ln.substring(idx + delimiter.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    v3 = lst = ((Object)StringsKt.trim((CharSequence)string)).toString();
                }
                if (((CharSequence)lst).length() == 0) {
                    den = true;
                } else if (StringsKt.startsWith$default((String)lst, (String)this.singleComment, (boolean)false, (int)2, null)) {
                    den = true;
                    if (idx == idl) {
                        idx = ln.length();
                    }
                } else if (StringsKt.startsWith$default((String)lst, (String)this.blockComment1, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)lst, (String)this.blockComment2, (int)0, (boolean)true, (int)2, null) == lst.length() - this.blockComment2.length()) {
                    den = true;
                    if (idx == idl) {
                        idx = ln.length();
                    }
                } else {
                    this.log.warn("find middle delimiter=" + delimiter + " in line=" + ln);
                    boolean bl = den = idx == ln.length() - delimiter.length();
                }
            }
            if (den || lineCur == total) {
                if (den) {
                    builder.append(ln, 0, idx);
                } else {
                    builder.append(ln);
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String sql = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (((CharSequence)sql).length() > 0) {
                    List list;
                    Map dicName;
                    String rename = "";
                    if (((CharSequence)tblName).length() == 0) {
                        this.log.debug("[parse] use statementParser to get tableName and shard/plain");
                        SqlStatementParser.SqlType st = statementParser.parseTypeAndTable(sql);
                        if (st instanceof SqlStatementParser.SqlType.Plain) {
                            tblName = ((SqlStatementParser.SqlType.Plain)st).getTable();
                            rename = ((SqlStatementParser.SqlType.Plain)st).getRename();
                            trgJour = true;
                            if (dbsAnot == 0) {
                                dbsAnot = -1;
                            }
                        } else if (st instanceof SqlStatementParser.SqlType.Shard) {
                            tblName = ((SqlStatementParser.SqlType.Shard)st).getTable();
                            if (dbsAnot == 0) {
                                dbsAnot = 1;
                            }
                        } else if (Intrinsics.areEqual((Object)st, (Object)SqlStatementParser.SqlType.Other.INSTANCE)) {
                            this.log.warn("[parse] unsupported type, use shard datasource to run, sql=" + sql);
                        }
                    }
                    Map map = dicName = StringsKt.isBlank((CharSequence)rename) ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)tblName, (Object)rename));
                    if (StringsKt.isBlank((CharSequence)rename)) {
                        list = CollectionsKt.listOf((Object)tblName);
                    } else {
                        Object[] objectArray = new String[]{tblName, rename};
                        list = CollectionsKt.listOf((Object[])objectArray);
                    }
                    List tblList = list;
                    SortedMap tblIdx2 = TemplateUtil.parse$default(TemplateUtil.INSTANCE, sql, tblList, null, false, 12, null);
                    DbsType dbsType = dbsAnot < 0 ? DbsType.Plain : DbsType.Shard;
                    Regex tblRegx = ((CharSequence)tbApply).length() == 0 ? null : new Regex(tbApply, RegexOption.IGNORE_CASE);
                    Object[] objectArray = new Object[]{lineBgn, lineCur, tblName, dbsType, errType, tbApply};
                    this.log.debug("[parse] got a segment line from={}, to={}, tableName={}, dbsType={}, errType={}, tblRegx={}", objectArray);
                    result.add(new Segment(dbsType, lineBgn, lineCur, tblName, tblIdx2, sql, errType, askText, tblRegx, trgJour, dicName));
                }
                lineBgn = -1;
                dbsAnot = 0;
                tblName = "";
                tbApply = "";
                errType = ErrType.Stop;
                askText = "";
                trgJour = false;
                builder.setLength(0);
                continue;
            }
            builder.append(ln).append("\n");
        }
        this.log.debug("[parse] parse sql done");
        return result;
    }

    @NotNull
    public final String merge(@NotNull Segment segment, @NotNull Map<String, String> newTbl) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter(newTbl, (String)"newTbl");
        return TemplateUtil.INSTANCE.merge(segment.getSqlText(), segment.getTblIdx2(), newTbl);
    }

    public SqlSegmentProcessor() {
        this(null, null, null, null, 15, null);
    }

    @JvmStatic
    public static final void setShardFormat(@NotNull String reg) {
        Companion.setShardFormat(reg);
    }

    @JvmStatic
    public static final void setTraceFormat(@NotNull String reg) {
        Companion.setTraceFormat(reg);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Companion;", "", "()V", "PLAIN_TABLE", "", "SHARD_LINE_SEQ", "TRACE_DOLLAR", "TRACE_PRE_LINE", "TRACE_SU2_LINE", "TYPE_OTHER", "", "TYPE_PLAIN", "TYPE_SHARD", "TYPE_TRACE", "cmdReg", "Lkotlin/text/Regex;", "regShard", "regTrace", "hasType", "table", "other", "parseCmd", "Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Companion$Opt;", "line", "head", "setShardFormat", "", "reg", "setTraceFormat", "Opt", "faceless-flywave"})
    @SourceDebugExtension(value={"SMAP\nSqlSegmentProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSegmentProcessor.kt\npro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n1#2:467\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setShardFormat(@NotNull String reg) {
            Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
            boolean bl = StringsKt.contains$default((CharSequence)reg, (CharSequence)SqlSegmentProcessor.PLAIN_TABLE, (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Regexp MUST contains XXX";
                throw new AssertionError((Object)string);
            }
            regShard = new Regex(reg, RegexOption.IGNORE_CASE);
        }

        @JvmStatic
        public final void setTraceFormat(@NotNull String reg) {
            Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
            boolean bl = StringsKt.contains$default((CharSequence)reg, (CharSequence)SqlSegmentProcessor.PLAIN_TABLE, (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Regexp MUST contains XXX";
                throw new AssertionError((Object)string);
            }
            regTrace = new Regex(reg, RegexOption.IGNORE_CASE);
        }

        public final int hasType(@NotNull String table, @NotNull String other) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int pos = StringsKt.indexOf((CharSequence)other, (String)table, (int)0, (boolean)true);
            if (pos < 0) {
                return -1;
            }
            String suf = StringsKt.replace$default((String)other, (String)table, (String)SqlSegmentProcessor.PLAIN_TABLE, (boolean)false, (int)4, null);
            return Intrinsics.areEqual((Object)suf, (Object)SqlSegmentProcessor.PLAIN_TABLE) ? 0 : (regShard.matches((CharSequence)suf) ? 2 : (regTrace.matches((CharSequence)suf) ? 1 : -1));
        }

        @Nullable
        public final Opt parseCmd(@NotNull String line, @NotNull String head) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)head, (String)"head");
            boolean emt = true;
            String tbl = "";
            String dbs = "";
            String apl = "";
            String ers = "";
            String ask = "";
            boolean trg = false;
            for (MatchResult mr : Regex.findAll$default((Regex)cmdReg, (CharSequence)StringsKt.substringAfter$default((String)line, (String)head, null, (int)2, null), (int)0, (int)2, null)) {
                MatchResult.Destructured destructured = mr.getDestructured();
                String ko = (String)destructured.getMatch().getGroupValues().get(1);
                String vo = (String)destructured.getMatch().getGroupValues().get(2);
                String k = ((Object)StringsKt.trim((CharSequence)ko)).toString();
                String v = ((Object)StringsKt.trim((CharSequence)vo)).toString();
                if (StringsKt.equals((String)v, (String)"plain", (boolean)true) || StringsKt.equals((String)v, (String)"shard", (boolean)true)) {
                    tbl = k;
                    dbs = v;
                    emt = false;
                    continue;
                }
                if (StringsKt.equals((String)k, (String)"apply", (boolean)true)) {
                    apl = v;
                    emt = false;
                    continue;
                }
                if (StringsKt.equals((String)k, (String)"error", (boolean)true)) {
                    ers = v;
                    emt = false;
                    continue;
                }
                if (StringsKt.equals((String)k, (String)"ask", (boolean)true)) {
                    ask = v;
                    emt = false;
                    continue;
                }
                if (!StringsKt.equals((String)v, (String)"trigger", (boolean)true)) continue;
                trg = true;
                emt = false;
            }
            return emt ? null : new Opt(tbl, dbs, apl, ers, ask, trg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Companion$Opt;", "", "tbl", "", "dbs", "apl", "ers", "ask", "trg", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getApl", "()Ljava/lang/String;", "getAsk", "getDbs", "getErs", "getTbl", "getTrg", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "faceless-flywave"})
        public static final class Opt {
            @NotNull
            private final String tbl;
            @NotNull
            private final String dbs;
            @NotNull
            private final String apl;
            @NotNull
            private final String ers;
            @NotNull
            private final String ask;
            private final boolean trg;

            public Opt(@NotNull String tbl, @NotNull String dbs, @NotNull String apl, @NotNull String ers, @NotNull String ask, boolean trg) {
                Intrinsics.checkNotNullParameter((Object)tbl, (String)"tbl");
                Intrinsics.checkNotNullParameter((Object)dbs, (String)"dbs");
                Intrinsics.checkNotNullParameter((Object)apl, (String)"apl");
                Intrinsics.checkNotNullParameter((Object)ers, (String)"ers");
                Intrinsics.checkNotNullParameter((Object)ask, (String)"ask");
                this.tbl = tbl;
                this.dbs = dbs;
                this.apl = apl;
                this.ers = ers;
                this.ask = ask;
                this.trg = trg;
            }

            public /* synthetic */ Opt(String string, String string2, String string3, String string4, String string5, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "";
                }
                if ((n & 2) != 0) {
                    string2 = "";
                }
                if ((n & 4) != 0) {
                    string3 = "";
                }
                if ((n & 8) != 0) {
                    string4 = "";
                }
                if ((n & 0x10) != 0) {
                    string5 = "";
                }
                if ((n & 0x20) != 0) {
                    bl = false;
                }
                this(string, string2, string3, string4, string5, bl);
            }

            @NotNull
            public final String getTbl() {
                return this.tbl;
            }

            @NotNull
            public final String getDbs() {
                return this.dbs;
            }

            @NotNull
            public final String getApl() {
                return this.apl;
            }

            @NotNull
            public final String getErs() {
                return this.ers;
            }

            @NotNull
            public final String getAsk() {
                return this.ask;
            }

            public final boolean getTrg() {
                return this.trg;
            }

            @NotNull
            public final String component1() {
                return this.tbl;
            }

            @NotNull
            public final String component2() {
                return this.dbs;
            }

            @NotNull
            public final String component3() {
                return this.apl;
            }

            @NotNull
            public final String component4() {
                return this.ers;
            }

            @NotNull
            public final String component5() {
                return this.ask;
            }

            public final boolean component6() {
                return this.trg;
            }

            @NotNull
            public final Opt copy(@NotNull String tbl, @NotNull String dbs, @NotNull String apl, @NotNull String ers, @NotNull String ask, boolean trg) {
                Intrinsics.checkNotNullParameter((Object)tbl, (String)"tbl");
                Intrinsics.checkNotNullParameter((Object)dbs, (String)"dbs");
                Intrinsics.checkNotNullParameter((Object)apl, (String)"apl");
                Intrinsics.checkNotNullParameter((Object)ers, (String)"ers");
                Intrinsics.checkNotNullParameter((Object)ask, (String)"ask");
                return new Opt(tbl, dbs, apl, ers, ask, trg);
            }

            public static /* synthetic */ Opt copy$default(Opt opt, String string, String string2, String string3, String string4, String string5, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    string = opt.tbl;
                }
                if ((n & 2) != 0) {
                    string2 = opt.dbs;
                }
                if ((n & 4) != 0) {
                    string3 = opt.apl;
                }
                if ((n & 8) != 0) {
                    string4 = opt.ers;
                }
                if ((n & 0x10) != 0) {
                    string5 = opt.ask;
                }
                if ((n & 0x20) != 0) {
                    bl = opt.trg;
                }
                return opt.copy(string, string2, string3, string4, string5, bl);
            }

            @NotNull
            public String toString() {
                return "Opt(tbl=" + this.tbl + ", dbs=" + this.dbs + ", apl=" + this.apl + ", ers=" + this.ers + ", ask=" + this.ask + ", trg=" + this.trg + ")";
            }

            public int hashCode() {
                int result = this.tbl.hashCode();
                result = result * 31 + this.dbs.hashCode();
                result = result * 31 + this.apl.hashCode();
                result = result * 31 + this.ers.hashCode();
                result = result * 31 + this.ask.hashCode();
                result = result * 31 + Boolean.hashCode(this.trg);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Opt)) {
                    return false;
                }
                Opt opt = (Opt)other;
                if (!Intrinsics.areEqual((Object)this.tbl, (Object)opt.tbl)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.dbs, (Object)opt.dbs)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.apl, (Object)opt.apl)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.ers, (Object)opt.ers)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.ask, (Object)opt.ask)) {
                    return false;
                }
                return this.trg == opt.trg;
            }

            public Opt() {
                this(null, null, null, null, null, false, 63, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$DbsType;", "", "(Ljava/lang/String;I)V", "Plain", "Shard", "faceless-flywave"})
    public static final class DbsType
    extends Enum<DbsType> {
        public static final /* enum */ DbsType Plain = new DbsType();
        public static final /* enum */ DbsType Shard = new DbsType();
        private static final /* synthetic */ DbsType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DbsType[] values() {
            return (DbsType[])$VALUES.clone();
        }

        public static DbsType valueOf(String value) {
            return Enum.valueOf(DbsType.class, value);
        }

        @NotNull
        public static EnumEntries<DbsType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dbsTypeArray = new DbsType[]{DbsType.Plain, DbsType.Shard};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$ErrType;", "", "(Ljava/lang/String;I)V", "Skip", "Stop", "faceless-flywave"})
    public static final class ErrType
    extends Enum<ErrType> {
        public static final /* enum */ ErrType Skip = new ErrType();
        public static final /* enum */ ErrType Stop = new ErrType();
        private static final /* synthetic */ ErrType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ErrType[] values() {
            return (ErrType[])$VALUES.clone();
        }

        public static ErrType valueOf(String value) {
            return Enum.valueOf(ErrType.class, value);
        }

        @NotNull
        public static EnumEntries<ErrType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = errTypeArray = new ErrType[]{ErrType.Skip, ErrType.Stop};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0015\u00a2\u0006\u0002\u0010\u0016J.\u0010*\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00150\u00152\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010,J\u0006\u0010-\u001a\u00020\u0013R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R)\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006."}, d2={"Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Segment;", "", "dbsType", "Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$DbsType;", "lineBgn", "", "lineEnd", "tblName", "", "tblIdx2", "Ljava/util/SortedMap;", "Lkotlin/Pair;", "sqlText", "errType", "Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$ErrType;", "askText", "tblRegx", "Lkotlin/text/Regex;", "trgJour", "", "dicName", "", "(Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$DbsType;IILjava/lang/String;Ljava/util/SortedMap;Ljava/lang/String;Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$ErrType;Ljava/lang/String;Lkotlin/text/Regex;ZLjava/util/Map;)V", "getAskText", "()Ljava/lang/String;", "getDbsType", "()Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$DbsType;", "getDicName", "()Ljava/util/Map;", "getErrType", "()Lpro/fessional/wings/faceless/flywave/SqlSegmentProcessor$ErrType;", "getLineBgn", "()I", "getLineEnd", "getSqlText", "getTblIdx2", "()Ljava/util/SortedMap;", "getTblName", "getTblRegx", "()Lkotlin/text/Regex;", "getTrgJour", "()Z", "applyTbl", "tables", "", "isPlain", "faceless-flywave"})
    @SourceDebugExtension(value={"SMAP\nSqlSegmentProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSegmentProcessor.kt\npro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Segment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,466:1\n766#2:467\n857#2,2:468\n766#2:470\n857#2,2:471\n766#2:473\n857#2,2:474\n766#2:476\n857#2,2:477\n1549#2:479\n1620#2,3:480\n1271#2,2:483\n1285#2,2:485\n1271#2,2:487\n1285#2,4:489\n1288#2:493\n*S KotlinDebug\n*F\n+ 1 SqlSegmentProcessor.kt\npro/fessional/wings/faceless/flywave/SqlSegmentProcessor$Segment\n*L\n48#1:467\n48#1:468,2\n54#1:470\n54#1:471,2\n59#1:473\n59#1:474,2\n63#1:476\n63#1:477,2\n70#1:479\n70#1:480,3\n73#1:483,2\n73#1:485,2\n74#1:487,2\n74#1:489,4\n73#1:493\n*E\n"})
    public static final class Segment {
        @NotNull
        private final DbsType dbsType;
        private final int lineBgn;
        private final int lineEnd;
        @NotNull
        private final String tblName;
        @NotNull
        private final SortedMap<Integer, Pair<Integer, String>> tblIdx2;
        @NotNull
        private final String sqlText;
        @NotNull
        private final ErrType errType;
        @NotNull
        private final String askText;
        @Nullable
        private final Regex tblRegx;
        private final boolean trgJour;
        @NotNull
        private final Map<String, String> dicName;

        public Segment(@NotNull DbsType dbsType, int lineBgn, int lineEnd, @NotNull String tblName, @NotNull SortedMap<Integer, Pair<Integer, String>> tblIdx2, @NotNull String sqlText, @NotNull ErrType errType, @NotNull String askText, @Nullable Regex tblRegx, boolean trgJour, @NotNull Map<String, String> dicName) {
            Intrinsics.checkNotNullParameter((Object)((Object)dbsType), (String)"dbsType");
            Intrinsics.checkNotNullParameter((Object)tblName, (String)"tblName");
            Intrinsics.checkNotNullParameter(tblIdx2, (String)"tblIdx2");
            Intrinsics.checkNotNullParameter((Object)sqlText, (String)"sqlText");
            Intrinsics.checkNotNullParameter((Object)((Object)errType), (String)"errType");
            Intrinsics.checkNotNullParameter((Object)askText, (String)"askText");
            Intrinsics.checkNotNullParameter(dicName, (String)"dicName");
            this.dbsType = dbsType;
            this.lineBgn = lineBgn;
            this.lineEnd = lineEnd;
            this.tblName = tblName;
            this.tblIdx2 = tblIdx2;
            this.sqlText = sqlText;
            this.errType = errType;
            this.askText = askText;
            this.tblRegx = tblRegx;
            this.trgJour = trgJour;
            this.dicName = dicName;
        }

        public /* synthetic */ Segment(DbsType dbsType, int n, int n2, String string, SortedMap sortedMap, String string2, ErrType errType, String string3, Regex regex, boolean bl, Map map, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x40) != 0) {
                errType = ErrType.Stop;
            }
            if ((n3 & 0x400) != 0) {
                map = MapsKt.emptyMap();
            }
            this(dbsType, n, n2, string, sortedMap, string2, errType, string3, regex, bl, map);
        }

        @NotNull
        public final DbsType getDbsType() {
            return this.dbsType;
        }

        public final int getLineBgn() {
            return this.lineBgn;
        }

        public final int getLineEnd() {
            return this.lineEnd;
        }

        @NotNull
        public final String getTblName() {
            return this.tblName;
        }

        @NotNull
        public final SortedMap<Integer, Pair<Integer, String>> getTblIdx2() {
            return this.tblIdx2;
        }

        @NotNull
        public final String getSqlText() {
            return this.sqlText;
        }

        @NotNull
        public final ErrType getErrType() {
            return this.errType;
        }

        @NotNull
        public final String getAskText() {
            return this.askText;
        }

        @Nullable
        public final Regex getTblRegx() {
            return this.tblRegx;
        }

        public final boolean getTrgJour() {
            return this.trgJour;
        }

        @NotNull
        public final Map<String, String> getDicName() {
            return this.dicName;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Map<String, String>> applyTbl(@Nullable List<String> tables) {
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            List list;
            Collection collection = tables;
            if (collection == null || collection.isEmpty() || this.tblIdx2.isEmpty() || ((CharSequence)this.tblName).length() == 0) {
                return MapsKt.emptyMap();
            }
            if (this.tblRegx == null) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv = tables;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(Companion.hasType(this.tblName, it) >= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                String ptn = this.tblRegx.getPattern();
                if (StringsKt.equals((String)ptn, (String)"nut", (boolean)true)) {
                    Iterable $this$filter$iv = tables;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        int tp = Companion.hasType(this.tblName, it);
                        if (!(tp == 0 || tp == 2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else if (StringsKt.equals((String)ptn, (String)"log", (boolean)true)) {
                    Iterable $this$filter$iv = tables;
                    boolean $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        if (!(Companion.hasType(this.tblName, it) == 1)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    Iterable $this$filter$iv = tables;
                    boolean $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        if (!this.tblRegx.matches((CharSequence)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
            }
            Set tbls = CollectionsKt.toSet((Iterable)list);
            if (tbls.isEmpty()) {
                return MapsKt.emptyMap();
            }
            Collection<Pair<Integer, String>> collection2 = this.tblIdx2.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair it = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String v = (String)it.component2();
                object.add(v);
            }
            Set tkns = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$associateWith$iv = tbls;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String it = (String)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Iterable $this$associateWith$iv2 = tkns;
                boolean $i$f$associateWith2 = false;
                LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
                boolean $i$f$associateWithTo2 = false;
                for (Object element$iv$iv2 : $this$associateWithTo$iv$iv2) {
                    void tk;
                    String string = (String)element$iv$iv2;
                    Object t2 = element$iv$iv2;
                    Map map = result$iv2;
                    boolean bl2 = false;
                    String string2 = StringsKt.replace$default((String)it, (String)this.tblName, (String)tk, (boolean)false, (int)4, null);
                    map.put(t2, string2);
                }
                Map map = result$iv2;
                object.put(t, map);
            }
            return result$iv;
        }

        public final boolean isPlain() {
            return this.dbsType == DbsType.Plain;
        }
    }
}

