/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.flywave.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import pro.fessional.wings.faceless.database.helper.DatabaseChecker;
import pro.fessional.wings.faceless.flywave.InteractiveManager;
import pro.fessional.wings.faceless.util.FlywaveInteractiveTty;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\rJ(\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fH\u0016J0\u0010\u0003\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0010\b\u0002\u0010\"\u001a\n\u0018\u00010#j\u0004\u0018\u0001`$J(\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0016J\u0013\u0010&\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\u001f\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010)R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u000fj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lpro/fessional/wings/faceless/flywave/impl/DefaultInteractiveManager;", "T", "Lpro/fessional/wings/faceless/flywave/InteractiveManager;", "log", "Lorg/slf4j/Logger;", "plainDataSources", "", "", "Ljavax/sql/DataSource;", "emoji", "(Lorg/slf4j/Logger;Ljava/util/Map;Ljava/lang/String;)V", "askFunc", "Ljava/util/function/Function;", "", "askType", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "lastMessage", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "getLastMessage", "()Ljava/util/concurrent/atomic/AtomicReference;", "msgFunc", "Ljava/util/function/BiConsumer;", "ask", "msg", "quit", "askWay", "func", "", "level", "Lorg/slf4j/event/Level;", "where", "info", "er", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logWay", "needAsk", "(Ljava/lang/Object;)Z", "yes", "(Ljava/lang/Object;Z)Ljava/lang/Boolean;", "faceless-flywave"})
public final class DefaultInteractiveManager<T>
implements InteractiveManager<T> {
    @NotNull
    private final Logger log;
    @NotNull
    private final Map<String, DataSource> plainDataSources;
    @NotNull
    private final String emoji;
    @NotNull
    private final HashMap<T, Boolean> askType;
    @NotNull
    private BiConsumer<String, String> msgFunc;
    @NotNull
    private Function<String, Boolean> askFunc;
    @NotNull
    private final AtomicReference<Pair<String, String>> lastMessage;

    public DefaultInteractiveManager(@NotNull Logger log, @NotNull Map<String, ? extends DataSource> plainDataSources, @NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(plainDataSources, (String)"plainDataSources");
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        this.log = log;
        this.plainDataSources = plainDataSources;
        this.emoji = emoji;
        this.askType = new HashMap();
        BiConsumer<String, String> biConsumer = FlywaveInteractiveTty.logNil;
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"logNil");
        this.msgFunc = biConsumer;
        Function<String, Boolean> function = FlywaveInteractiveTty.askYes;
        Intrinsics.checkNotNullExpressionValue(function, (String)"askYes");
        this.askFunc = function;
        this.lastMessage = new AtomicReference();
    }

    public /* synthetic */ DefaultInteractiveManager(Logger logger, Map map, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "\ud83d\udc1d";
        }
        this(logger, map, string);
    }

    @NotNull
    public final AtomicReference<Pair<String, String>> getLastMessage() {
        return this.lastMessage;
    }

    public final void log(@NotNull Level level, @NotNull String where, @NotNull String info, @Nullable Exception er) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String msg = "[" + where + "] " + this.emoji + " " + info;
        if (level == Level.ERROR) {
            if (er == null) {
                this.log.error(msg);
            } else {
                this.log.error(msg, (Throwable)er);
            }
        } else if (level == Level.WARN) {
            if (er == null) {
                this.log.warn(msg);
            } else {
                this.log.warn(msg, (Throwable)er);
            }
        } else if (er == null) {
            this.log.info(msg);
        } else {
            this.log.info(msg, (Throwable)er);
        }
        String tkn = level.name() + "|" + where;
        boolean fst = this.lastMessage.get() == null;
        this.lastMessage.set((Pair<String, String>)TuplesKt.to((Object)tkn, (Object)info));
        this.msgFunc.accept(tkn, info);
        if (fst) {
            this.log.info("[askSegment]\ud83d\udc1d\ud83d\ude40 if no console, add '-Deditable.java.test.console=true' ('Help' > 'Edit Custom VM Options...')");
            if (!this.plainDataSources.isEmpty()) {
                StringBuffer bd = new StringBuffer("apply to databases?");
                for (Map.Entry<String, DataSource> entry : this.plainDataSources.entrySet()) {
                    String k = entry.getKey();
                    DataSource v = entry.getValue();
                    bd.append("\nname=").append(k);
                    bd.append("\njdbc=").append(DatabaseChecker.extractJdbcUrl((DataSource)v));
                }
                String string = bd.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                DefaultInteractiveManager.ask$default(this, string, false, 2, null);
            }
        }
    }

    public static /* synthetic */ void log$default(DefaultInteractiveManager defaultInteractiveManager, Level level, String string, String string2, Exception exception, int n, Object object) {
        if ((n & 8) != 0) {
            exception = null;
        }
        defaultInteractiveManager.log(level, string, string2, exception);
    }

    public final boolean ask(@NotNull String msg, boolean quit) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Boolean bl = this.askFunc.apply(msg);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"apply(...)");
        boolean y = bl;
        if (y) {
            DefaultInteractiveManager.log$default(this, Level.INFO, "Confirm-Yes", msg, null, 8, null);
        } else {
            if (quit) {
                DefaultInteractiveManager.log$default(this, Level.ERROR, "Confirm-NO", msg, null, 8, null);
                throw new RuntimeException("Confirm-NO " + msg);
            }
            DefaultInteractiveManager.log$default(this, Level.WARN, "Confirm-NO", msg, null, 8, null);
        }
        return y;
    }

    public static /* synthetic */ boolean ask$default(DefaultInteractiveManager defaultInteractiveManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return defaultInteractiveManager.ask(string, bl);
    }

    public final boolean needAsk(T ask) {
        return !Intrinsics.areEqual((Object)this.askType.get(ask), (Object)false);
    }

    @Override
    @Nullable
    public Boolean needAsk(T ask, boolean yes) {
        return this.askType.put(ask, yes);
    }

    @Override
    @NotNull
    public Function<String, Boolean> askWay(@NotNull Function<String, Boolean> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Function<String, Boolean> old = this.askFunc;
        this.askFunc = func;
        return old;
    }

    @Override
    @NotNull
    public BiConsumer<String, String> logWay(@NotNull BiConsumer<String, String> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        BiConsumer<String, String> old = this.msgFunc;
        this.msgFunc = func;
        return old;
    }
}

