/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import pro.fessional.wings.faceless.database.DataSourceContext;
import pro.fessional.wings.faceless.flywave.RevisionFitness;
import pro.fessional.wings.faceless.flywave.SchemaDefinitionLoader;
import pro.fessional.wings.faceless.flywave.SchemaFulldumpManager;
import pro.fessional.wings.faceless.flywave.SchemaJournalManager;
import pro.fessional.wings.faceless.flywave.SchemaShardingManager;
import pro.fessional.wings.faceless.flywave.SqlSegmentProcessor;
import pro.fessional.wings.faceless.flywave.SqlStatementParser;
import pro.fessional.wings.faceless.flywave.impl.DefaultRevisionManager;
import pro.fessional.wings.faceless.flywave.impl.MySqlStatementParser;
import pro.fessional.wings.faceless.flywave.impl.MysqlDefinitionLoader;
import pro.fessional.wings.faceless.spring.prop.FlywaveFitProp;
import pro.fessional.wings.faceless.spring.prop.FlywaveSqlProp;
import pro.fessional.wings.faceless.spring.prop.FlywaveVerProp;
import pro.fessional.wings.silencer.runner.ApplicationRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={DataSourceContext.class})
public class FlywaveConfiguration {
    private static final Log log = LogFactory.getLog(FlywaveConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    @Scope(value="prototype")
    public SchemaJournalManager schemaJournalManager(DataSourceContext sourceContext, SqlStatementParser statementParser, SchemaDefinitionLoader schemaDefinitionLoader, FlywaveVerProp properties) {
        SchemaJournalManager.JournalDdl ddl = new SchemaJournalManager.JournalDdl(properties.getJournalInsert(), properties.getTriggerInsert(), properties.getJournalUpdate(), properties.getTriggerUpdate(), properties.getJournalDelete(), properties.getTriggerDelete());
        log.info((Object)"FacelessFlywave spring-bean schemaJournalManager");
        return new SchemaJournalManager(sourceContext.getBackends(), statementParser, schemaDefinitionLoader, ddl, properties.getSchemaJournalTable());
    }

    @Bean
    @ConditionalWingsEnabled
    @Scope(value="prototype")
    public DefaultRevisionManager schemaVersionManger(DataSourceContext sourceContext, SqlStatementParser statementParser, SqlSegmentProcessor segmentProcessor, SchemaDefinitionLoader schemaDefinitionLoader, FlywaveVerProp properties) {
        DefaultRevisionManager bean = new DefaultRevisionManager(sourceContext.getBackends(), null, statementParser, segmentProcessor, schemaDefinitionLoader, properties.getSchemaVersionTable());
        for (String s : new TreeSet<String>(properties.getDropReg().values())) {
            if (s == null || s.isEmpty()) continue;
            bean.addDropRegexp(s);
        }
        log.info((Object)"FacelessFlywave spring-bean schemaVersionManger");
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    @Scope(value="prototype")
    public SchemaShardingManager schemaShardingManager(DataSourceContext sourceContext, SqlStatementParser statementParser, SchemaDefinitionLoader schemaDefinitionLoader) {
        log.info((Object)"FacelessFlywave spring-bean schemaShardingManager");
        return new SchemaShardingManager(sourceContext.getBackends(), sourceContext.getCurrent(), statementParser, schemaDefinitionLoader);
    }

    @Bean
    @ConditionalWingsEnabled
    public SchemaFulldumpManager schemaFulldumpManager(SqlStatementParser statementParser, SchemaDefinitionLoader schemaDefinitionLoader) {
        log.info((Object)"FacelessFlywave spring-bean schemaFulldumpManager");
        return new SchemaFulldumpManager(statementParser, schemaDefinitionLoader);
    }

    @Bean
    @ConditionalWingsEnabled
    public MysqlDefinitionLoader schemaDefinitionLoader(FlywaveSqlProp conf) {
        if ("mysql".equalsIgnoreCase(conf.getDialect())) {
            log.info((Object)"FacelessFlywave spring-bean schemaDefinitionLoader");
            return new MysqlDefinitionLoader();
        }
        throw new IllegalArgumentException("only support mysql");
    }

    @Bean
    @ConditionalWingsEnabled
    public MySqlStatementParser sqlStatementParser(FlywaveSqlProp conf) {
        if ("mysql".equalsIgnoreCase(conf.getDialect())) {
            log.info((Object)"FacelessFlywave spring-bean sqlStatementParser");
            return new MySqlStatementParser();
        }
        throw new IllegalArgumentException("only support mysql");
    }

    @Bean
    @ConditionalWingsEnabled
    public SqlSegmentProcessor sqlSegmentProcessor(FlywaveSqlProp conf) {
        if ("mysql".equalsIgnoreCase(conf.getDialect())) {
            String ft;
            String fs = conf.getFormatShard();
            if (fs != null && !fs.isEmpty()) {
                log.info((Object)("FacelessFlywave spring-bean static ShardFormat=" + fs));
                SqlSegmentProcessor.setShardFormat(fs);
            }
            if ((ft = conf.getFormatTrace()) != null && !ft.isEmpty()) {
                log.info((Object)("FacelessFlywave spring-bean static TraceFormat=" + ft));
                SqlSegmentProcessor.setTraceFormat(ft);
            }
            log.info((Object)"FacelessFlywave spring-bean sqlSegmentParser");
            return new SqlSegmentProcessor(conf.getCommentSingle(), conf.getCommentMultiple(), conf.getDelimiterDefault(), conf.getDelimiterCommand());
        }
        throw new IllegalArgumentException("only support mysql");
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.faceless.flywave.checker")
    public ApplicationRunnerOrdered revisionCheckerRunner(DefaultRevisionManager manager, FlywaveFitProp prop) {
        log.info((Object)"FacelessFlywave spring-runs runnerRevisionChecker");
        return new ApplicationRunnerOrdered(-90000000, ignored -> {
            log.info((Object)"FacelessFlywave check RevisionFitness");
            RevisionFitness fits = new RevisionFitness();
            fits.addFits(prop.getFit());
            fits.checkRevision(manager, prop.isAutoInit());
        });
    }
}

