/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.helper;

import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.UpdatableRecord;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.DSL;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.database.helper.JournalJdbcHelper;
import pro.fessional.wings.faceless.service.journal.JournalService;

public class JournalJooqHelper
extends JournalJdbcHelper {
    public static String getJournalDateColumn(DSLContext dsl, String table) {
        return JournalJooqHelper.getJournalDateColumn((String)table, (T s) -> {
            ResultSet rs = dsl.selectFrom(s + " where 1 = 0").fetchResultSet();
            return JournalJooqHelper.getJournalDateColumn((ResultSet)rs, (boolean)true);
        });
    }

    public static String getJournalDateColumn(Table<? extends Record> table) {
        return JournalJooqHelper.getJournalDateColumn((String)table.getName(), (T s) -> {
            String[] columns = JournalJooqHelper.extractColumn(table.fields(), "delete_dt", "modify_dt", "modify_time");
            if (columns[0] != null) {
                return columns[0];
            }
            if (columns[1] != null) {
                return columns[1];
            }
            return "";
        });
    }

    public static int deleteByIds(DAOImpl<? extends UpdatableRecord<?>, ?, ?> dao, JournalService.Journal commit, Long ... ids) {
        return JournalJooqHelper.deleteByIds(dao.ctx(), (Table<? extends Record>)dao.getTable(), (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(DAOImpl<? extends UpdatableRecord<?>, ?, ?> dao, JournalService.Journal commit, Collection<Long> ids) {
        return JournalJooqHelper.deleteByIds(dao.ctx(), (Table<? extends Record>)dao.getTable(), (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, JournalService.Journal commit, Long ... ids) {
        return JournalJooqHelper.deleteByIds(dsl, table, (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, JournalService.Journal commit, Collection<Long> ids) {
        return JournalJooqHelper.deleteByIds(dsl, table, (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, Long commitId, Long ... ids) {
        return JournalJooqHelper.deleteByIds(dsl, table, commitId, null, ids);
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, Long commitId, Collection<Long> ids) {
        return JournalJooqHelper.deleteByIds(dsl, table, commitId, null, ids);
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, Long commitId, LocalDateTime now, Long ... ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return JournalJooqHelper.deleteByIds(dsl, table, commitId, now, Arrays.asList(ids));
    }

    public static int deleteByIds(DSLContext dsl, Table<? extends Record> table, Long commitId, LocalDateTime now, Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        Field id = DSL.field((String)"id", Long.class);
        return JournalJooqHelper.deleteWhere(dsl, table, commitId, now, id.in(ids));
    }

    public static int deleteWhere(DAOImpl<? extends UpdatableRecord<?>, ?, ?> dao, JournalService.Journal commit, Condition where) {
        return JournalJooqHelper.deleteWhere(dao.ctx(), (Table<? extends Record>)dao.getTable(), commit.getCommitId(), commit.getCommitDt(), where);
    }

    public static int deleteWhere(DSLContext dsl, Table<? extends Record> table, JournalService.Journal commit, Condition where) {
        return JournalJooqHelper.deleteWhere(dsl, table, commit.getCommitId(), commit.getCommitDt(), where);
    }

    public static int deleteWhere(DSLContext dsl, Table<? extends Record> table, Long commitId, Condition where) {
        return JournalJooqHelper.deleteWhere(dsl, table, commitId, null, where);
    }

    public static int deleteWhere(DSLContext dsl, Table<? extends Record> table, Long commitId, LocalDateTime now, Condition where) {
        UpdateSetMoreStep update = dsl.update(table).set(DSL.field((String)"commit_id", Long.class), (Object)commitId);
        String jf = JournalJooqHelper.getJournalDateColumn(table);
        if (!jf.isEmpty()) {
            update = now == null ? update.set(DSL.field((String)jf, String.class), DSL.field((String)"NOW(3)", String.class)) : update.set(DSL.field((String)jf, LocalDateTime.class), (Object)now);
        }
        update.where(where).execute();
        return dsl.deleteFrom(table).where(where).execute();
    }

    public static String[] extractColumn(Field<?>[] fields, String ... name) {
        String[] result = new String[name.length];
        for (Field<?> fd : fields) {
            String cn = JournalJooqHelper.getFieldName((String)fd.getName());
            for (int j = 0; j < name.length; ++j) {
                if (result[j] != null || !cn.equalsIgnoreCase(name[j])) continue;
                result[j] = cn;
            }
        }
        return result;
    }

    public static Field<?>[] extractField(Field<?>[] fields, String ... name) {
        Field[] result = new Field[name.length];
        for (Field<?> fd : fields) {
            String cn = JournalJooqHelper.getFieldName((String)fd.getName());
            for (int j = 0; j < name.length; ++j) {
                if (result[j] != null || !cn.equalsIgnoreCase(name[j])) continue;
                result[j] = fd;
            }
        }
        return result;
    }

    public static <T extends Table<?>> void create(@NotNull JournalService.Journal journal, @Nullable T table, @Nullable Map<?, ?> setter) {
        JournalJooqHelper.commit(journal, table, setter, "commit_id", "create_dt", "modify_dt", "delete_dt");
    }

    public static <T extends Table<?>> void modify(@NotNull JournalService.Journal journal, @Nullable T table, @Nullable Map<?, ?> setter) {
        JournalJooqHelper.commit(journal, table, setter, "commit_id", "modify_dt");
    }

    public static <T extends Table<?>> void delete(@NotNull JournalService.Journal journal, @Nullable T table, @Nullable Map<?, ?> setter) {
        JournalJooqHelper.commit(journal, table, setter, "commit_id", "delete_dt");
    }

    public static <T extends Table<?>> void commit(@NotNull JournalService.Journal journal, @Nullable T table, @Nullable Map<?, ?> setter, String ... field) {
        if (table == null || setter == null || field == null) {
            return;
        }
        Field<?>[] fields = JournalJooqHelper.extractField(table.fields(), field);
        JournalJooqHelper.commit(journal, setter, fields);
    }

    public static void commit(@NotNull JournalService.Journal journal, @Nullable Map<?, ?> setter, Field<?> ... field) {
        if (setter == null || field == null) {
            return;
        }
        Map<?, ?> putter = setter;
        Field<?> createDt = null;
        Field<?> modifyDt = null;
        Field<?> deleteDt = null;
        for (Field<?> fd : field) {
            String k = JournalJooqHelper.getFieldName((String)fd.getName());
            if (k.equalsIgnoreCase("commit_id")) {
                putter.put(fd, journal.getCommitId());
                continue;
            }
            if (k.equalsIgnoreCase("create_dt")) {
                createDt = fd;
                continue;
            }
            if (k.equalsIgnoreCase("modify_dt")) {
                modifyDt = fd;
                continue;
            }
            if (!k.equalsIgnoreCase("delete_dt")) continue;
            deleteDt = fd;
        }
        LocalDateTime commitDt = journal.getCommitDt();
        if (createDt == null) {
            if (modifyDt != null) {
                putter.put(modifyDt, commitDt);
            }
            if (deleteDt != null) {
                putter.put(deleteDt, commitDt);
            }
        } else {
            putter.put(createDt, commitDt);
            if (modifyDt != null) {
                putter.put(modifyDt, EmptyValue.DATE_TIME);
            }
            if (deleteDt != null) {
                putter.put(deleteDt, EmptyValue.DATE_TIME);
            }
        }
    }
}

