/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.Converter;
import org.jooq.ConverterProvider;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultVisitListenerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jooq.DefaultConfigurationCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.faceless.database.jooq.WingsJooqEnv;
import pro.fessional.wings.faceless.database.jooq.converter.JooqConverterDelegate;
import pro.fessional.wings.faceless.database.jooq.listener.AutoQualifyFieldListener;
import pro.fessional.wings.faceless.spring.prop.FacelessJooqConfProp;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={Settings.class})
public class FacelessJooqConfiguration {
    private static final Log log = LogFactory.getLog(FacelessJooqConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.faceless.jooq.conf.auto-qualify")
    public VisitListenerProvider jooqAutoQualifyFieldListener() {
        log.info((Object)"FacelessJooq spring-bean jooqAutoQualifyFieldListener");
        return new DefaultVisitListenerProvider((VisitListener)new AutoQualifyFieldListener());
    }

    @Bean
    @ConditionalWingsEnabled
    public DefaultConfigurationCustomizer jooqWingsConfigCustomizer(FacelessJooqConfProp config, ObjectProvider<ConverterProvider> providers, ObjectProvider<Converter<?, ?>> converters, ObjectProvider<VisitListenerProvider> visitListenerProviders) {
        log.info((Object)"FacelessJooq spring-bean jooqWingsConfigCustomizer");
        return configuration -> {
            VisitListenerProvider[] visitArr = (VisitListenerProvider[])visitListenerProviders.orderedStream().toArray(VisitListenerProvider[]::new);
            log.info((Object)("FacelessJooq conf visitListener, size=" + visitArr.length));
            configuration.set(visitArr);
            Settings settings = configuration.settings();
            WingsJooqEnv.daoBatchMysql = config.isBatchMysql();
            settings.withRenderCatalog(Boolean.valueOf(config.isRenderCatalog())).withRenderSchema(Boolean.valueOf(config.isRenderSchema())).withRenderGroupConcatMaxLenSessionVariable(Boolean.valueOf(config.isRenderGroupConcat())).withRenderTable(config.getRenderTable());
            log.info((Object)("FacelessJooq conf jooq setting, dialect=" + String.valueOf(settings.getParseDialect())));
            if (config.isConverter()) {
                log.info((Object)"FacelessJooq conf jooqConfiguration ConverterProvider");
                JooqConverterDelegate dcp = new JooqConverterDelegate();
                dcp.add(configuration.converterProvider());
                providers.orderedStream().forEach(it -> {
                    dcp.add((ConverterProvider)it);
                    log.info((Object)("   add jooqConverterProvider, class=" + String.valueOf(it.getClass())));
                });
                converters.orderedStream().forEach(it -> {
                    dcp.add(it);
                    log.info((Object)("   add jooqConverter, class=" + String.valueOf(it.getClass())));
                });
                configuration.set((ConverterProvider)dcp);
            }
        };
    }
}

