/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Table;
import pro.fessional.wings.faceless.service.journal.JournalDiff;

public class JournalDiffHelper {
    public static final String Default = "default";
    private static final Map<String, Set<String>> DefaultIgnore = new HashMap<String, Set<String>>();

    public static void putDefaultIgnore(String ... field) {
        Set set = DefaultIgnore.computeIfAbsent(Default, k -> new HashSet());
        for (String f : field) {
            if (f == null) continue;
            set.add(f);
        }
    }

    public static void putDefaultIgnore(Map<String, Set<String>> map) {
        DefaultIgnore.putAll(map);
    }

    public static JournalDiff diffInsert(Table<?> table, ResultQuery<?> query, Runnable exec) {
        exec.run();
        Result rs2 = query.fetch();
        JournalDiff diff = new JournalDiff();
        diff.setTable(table.getName());
        diff.setTyped(true);
        JournalDiffHelper.helpInsert(diff, (Result<? extends Record>)rs2);
        return diff;
    }

    public static JournalDiff diffUpdate(Table<?> table, ResultQuery<?> query, Runnable exec) {
        Result rs1 = query.fetch();
        exec.run();
        Result rs2 = query.fetch();
        JournalDiff diff = new JournalDiff();
        diff.setTable(table.getName());
        diff.setTyped(true);
        JournalDiffHelper.helpUpdate(diff, (Result<? extends Record>)rs1, (Result<? extends Record>)rs2);
        return diff;
    }

    public static JournalDiff diffDelete(Table<?> table, ResultQuery<?> query, Runnable exec) {
        Result rs1 = query.fetch();
        exec.run();
        JournalDiff diff = new JournalDiff();
        diff.setTable(table.getName());
        diff.setTyped(true);
        JournalDiffHelper.helpDelete(diff, (Result<? extends Record>)rs1);
        return diff;
    }

    public static void tidy(@NotNull JournalDiff diff, Field<?> ... ignore) {
        JournalDiffHelper.tidy(true, diff, ignore);
    }

    public static void tidy(boolean withDefault, @NotNull JournalDiff diff, Field<?> ... ignore) {
        if (!diff.isValid()) {
            return;
        }
        boolean del = false;
        ArrayList col = JournalDiffHelper.arrayList(diff.getColumn());
        ArrayList<Object> vs1 = JournalDiffHelper.arrayList(diff.getValue1());
        ArrayList<Object> vs2 = JournalDiffHelper.arrayList(diff.getValue2());
        Object delFlag = new Object();
        if (diff.isUpdate()) {
            int len = col.size();
            for (int i = 0; i < len; ++i) {
                int sm = 1;
                int cnt = diff.getCount();
                for (int j = 0; j < cnt; j += len) {
                    int d = j + i;
                    if (!JournalDiffHelper.notEquals(vs1.get(d), vs2.get(d))) continue;
                    sm = 0;
                    break;
                }
                if (sm == 0) continue;
                col.set(i, null);
                JournalDiffHelper.markDelete(vs1, i, len, delFlag);
                JournalDiffHelper.markDelete(vs2, i, len, delFlag);
                del = true;
            }
        }
        HashSet<String> fds = new HashSet<String>();
        if (withDefault) {
            fds.addAll(DefaultIgnore.getOrDefault(Default, Collections.emptySet()));
            fds.addAll(DefaultIgnore.getOrDefault(diff.getTable(), Collections.emptySet()));
        }
        for (Field<?> f : ignore) {
            fds.add(f.getName());
        }
        if (!fds.isEmpty()) {
            int len = col.size();
            block3: for (int i = 0; i < len; ++i) {
                String c = (String)col.get(i);
                for (String f : fds) {
                    if (c == null || !c.equalsIgnoreCase(f)) continue;
                    col.set(i, null);
                    JournalDiffHelper.markDelete(vs1, i, len, delFlag);
                    JournalDiffHelper.markDelete(vs2, i, len, delFlag);
                    del = true;
                    continue block3;
                }
            }
        }
        if (del) {
            col.removeIf(Objects::isNull);
            vs1.removeIf(it -> it == delFlag);
            vs2.removeIf(it -> it == delFlag);
            diff.setColumn(col);
            diff.setValue1(vs1);
            diff.setValue2(vs2);
        }
    }

    public static void help(@NotNull JournalDiff diff, Result<? extends Record> before, Result<? extends Record> after) {
        ArrayList<Object> value2;
        ArrayList<Object> value1;
        int count;
        ArrayList<String> column;
        if (before == null) {
            if (after == null) {
                throw new IllegalArgumentException("before and after both null");
            }
            @NotNull Field[] fds = after.fields();
            column = JournalDiffHelper.fieldName(fds);
            count = after.size();
            value1 = new ArrayList(0);
            value2 = JournalDiffHelper.flatResult(after);
        } else if (after == null) {
            column = JournalDiffHelper.fieldName(before.fields());
            count = before.size();
            value1 = JournalDiffHelper.flatResult(before);
            value2 = new ArrayList(0);
        } else {
            column = JournalDiffHelper.fieldName(before.fields());
            count = before.size();
            if (!column.equals(JournalDiffHelper.fieldName(after.fields()))) {
                throw new IllegalArgumentException("before and after column mismatch");
            }
            if (count != after.size()) {
                throw new IllegalArgumentException("before and after record mismatch");
            }
            value1 = JournalDiffHelper.flatResult(before);
            value2 = JournalDiffHelper.flatResult(after);
        }
        diff.setCount(count);
        diff.setColumn(column);
        diff.setValue1(value1);
        diff.setValue2(value2);
    }

    public static void helpInsert(@NotNull JournalDiff diff, @NotNull Result<? extends Record> after) {
        JournalDiffHelper.help(diff, null, after);
    }

    public static void helpDelete(@NotNull JournalDiff diff, @NotNull Result<? extends Record> before) {
        JournalDiffHelper.help(diff, before, null);
    }

    public static void helpUpdate(@NotNull JournalDiff diff, @NotNull Result<? extends Record> before, @NotNull Result<? extends Record> after) {
        JournalDiffHelper.help(diff, before, after);
    }

    public static ArrayList<String> fieldName(Field<?> ... fields) {
        ArrayList<String> cols = new ArrayList<String>(fields.length);
        for (Field<?> fd : fields) {
            cols.add(fd.getName());
        }
        return cols;
    }

    public static ArrayList<Object> flatResult(Result<? extends Record> result) {
        ArrayList<Object> vs2 = new ArrayList<Object>();
        for (Record r : result) {
            vs2.addAll(Arrays.asList(r.intoArray()));
        }
        return vs2;
    }

    public static <T> ArrayList<T> arrayList(List<T> os) {
        return os instanceof ArrayList ? (ArrayList<Object>)os : new ArrayList<T>(os);
    }

    private static void markDelete(ArrayList<Object> arr, int idx, int st, Object flg) {
        int len = arr.size();
        for (int i = idx; i < len; i += st) {
            arr.set(i, flg);
        }
    }

    private static boolean notEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return false;
        }
        if (v1 != null && v2 != null) {
            return !v1.equals(v2);
        }
        return true;
    }

    @Generated
    public static Map<String, Set<String>> getDefaultIgnore() {
        return DefaultIgnore;
    }
}

