/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.listener;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.conf.ParamType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.faceless.database.jooq.helper.JournalJooqHelper;

public class JournalDeleteListener
implements ExecuteListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalDeleteListener.class);
    private final Pattern ptnCommitId = Pattern.compile("\\band\\s+([`'\"]?commit_id[`'\"]?\\s*=\\s*([^()=\\s]+))|([`'\"]?commit_id[`'\"]?\\s*=\\s*([^()=\\s]+))\\s+and\\b", 10);

    public void renderEnd(ExecuteContext ctx) {
        String updateSql;
        Query query = ctx.query();
        if (!(query instanceof Delete)) {
            return;
        }
        String sql = ctx.sql();
        if (sql == null) {
            return;
        }
        if (this.notJournalDelete(sql)) {
            return;
        }
        String table = this.parseTable(sql);
        if (table == null) {
            return;
        }
        LinkedHashMap params = query.getParams();
        if (!params.isEmpty()) {
            for (Param value : params.values()) {
                ParamType type = value.getParamType();
                if (type == ParamType.INDEXED || type == ParamType.FORCE_INDEXED) continue;
                return;
            }
            params = new LinkedHashMap(params);
        }
        if ((updateSql = this.buildUpdateSql(ctx.dsl(), sql, table, params)) == null) {
            return;
        }
        log.debug("Wings journal-delete, sql={}", (Object)updateSql);
        try {
            if (params.isEmpty()) {
                ctx.dsl().execute(updateSql);
            } else {
                Object[] pms = new Object[params.size()];
                int i = 0;
                for (Param pm : params.values()) {
                    pms[i++] = pm.getValue();
                }
                ctx.dsl().execute(updateSql, pms);
            }
        }
        catch (Exception e) {
            log.error(updateSql, (Throwable)e);
        }
    }

    private String parseTable(String sql) {
        int fi = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"from");
        if (fi < 0) {
            return null;
        }
        int wi = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"where", (int)(fi + 5));
        char quote = '\u0000';
        int bgn = -1;
        for (int i = fi + 4; i < wi; ++i) {
            char c = sql.charAt(i);
            if (c == '`' || c == '\"' || c == '\'') {
                if (quote == '\u0000') {
                    quote = c;
                    bgn = i;
                    continue;
                }
                if (quote == c) {
                    return sql.substring(bgn, i + 1);
                }
            }
            if (c > ' ') {
                if (bgn >= 0) continue;
                bgn = i;
                continue;
            }
            if (quote != '\u0000' || bgn <= 0) continue;
            return sql.substring(bgn, i);
        }
        return null;
    }

    private String buildUpdateSql(DSLContext dsl, String del, String table, Map<String, Param<?>> params) {
        Matcher matcher = this.ptnCommitId.matcher(del);
        if (!matcher.find()) {
            return null;
        }
        String cidWhere = matcher.group();
        int off = 0;
        String cidSql = matcher.group(1);
        if (cidSql == null) {
            off = 2;
            cidSql = matcher.group(3);
        }
        if (!params.isEmpty()) {
            Param<?> para;
            String cidVal = matcher.group(off + 2).trim();
            if ("?".equals(cidVal)) {
                int cn = 1;
                for (int i = 0; i < matcher.start(); ++i) {
                    char c = del.charAt(i);
                    if (c != '?') continue;
                    ++cn;
                }
                para = params.remove(String.valueOf(cn));
            } else {
                para = params.remove(cidVal);
            }
            if (para == null) {
                cidVal = cidVal.trim();
                for (int i = 0; i < cidVal.length(); ++i) {
                    char c = cidVal.charAt(i);
                    if (c == '-' || c >= '0' && c <= '9') continue;
                    return null;
                }
            } else {
                cidSql = cidSql.replace(cidVal, String.valueOf(para.getValue()));
            }
        }
        StringBuilder upd = new StringBuilder("UPDATE ");
        upd.append(table);
        upd.append(" SET ");
        upd.append(cidSql);
        upd.append(' ');
        String jf = JournalJooqHelper.getJournalDateColumn(dsl, table);
        if (!jf.isEmpty()) {
            upd.append(',').append(jf).append(" = NOW(3) ");
        }
        String where = del.substring(StringUtils.indexOfIgnoreCase((CharSequence)del, (CharSequence)"where"));
        upd.append(where.replace(cidWhere, ""));
        return upd.toString();
    }

    private boolean notJournalDelete(String sql) {
        int di = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"delete");
        if (di < 0) {
            return true;
        }
        int ci = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)"commit_id", (int)(di + 7));
        return ci < di;
    }
}

