/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Keyword;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.TableField;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.impl.QOM;
import org.jooq.impl.TableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.pain.DebugException;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;

public class TableCudListener
implements VisitListener,
WingsTableCudHandler.Auto {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableCudListener.class);
    public static boolean WarnVisit = false;
    private boolean create = true;
    private boolean update = true;
    private boolean delete = true;
    private List<WingsTableCudHandler> handlers = Collections.emptyList();
    private Map<String, Set<String>> tableField = new HashMap<String, Set<String>>();
    private static final String WHERE_EQ = "=";
    private static final String WHERE_IN = "in";

    public void clauseStart(VisitContext context) {
        WingsTableCudHandler.Cud cud;
        if (WarnVisit) {
            String clz = this.scn(context.queryPart());
            Clause clause = context.clause();
            if (clause == Clause.INSERT || clause == Clause.UPDATE || clause == Clause.DELETE) {
                log.warn(">>> clauseStart Clause=" + String.valueOf(clause) + ", Query=" + clz, (Throwable)new DebugException("debug for call stack"));
            } else {
                log.warn(">>> clauseStart Clause={}, Query={}", (Object)clause, (Object)clz);
            }
        }
        if (this.handlers.isEmpty() || this.tableField.isEmpty()) {
            return;
        }
        if (context.renderContext() == null) {
            return;
        }
        Clause clause = context.clause();
        if (this.create && clause == Clause.INSERT) {
            cud = WingsTableCudHandler.Cud.Create;
        } else if (this.update && clause == Clause.UPDATE) {
            cud = WingsTableCudHandler.Cud.Update;
        } else if (this.delete && clause == Clause.DELETE) {
            cud = WingsTableCudHandler.Cud.Delete;
        } else {
            return;
        }
        for (Map.Entry ent : context.data().entrySet()) {
            Enum em;
            Object key = ent.getKey();
            if (!(key instanceof Enum) || !"DATA_COUNT_BIND_VALUES".equals((em = (Enum)key).name())) continue;
            if (WarnVisit) {
                log.warn(">>> got DATA_COUNT_BIND_VALUES");
            }
            context.data((Object)ContextKey.EXECUTING_VISIT_CUD, (Object)cud);
            return;
        }
        context.data((Object)ContextKey.EXECUTING_VISIT_CUD, null);
    }

    public void clauseEnd(VisitContext context) {
        Clause clause;
        if (WarnVisit) {
            String clz = this.scn(context.queryPart());
            clause = context.clause();
            if (clause == Clause.INSERT || clause == Clause.UPDATE || clause == Clause.DELETE) {
                log.warn("<<< clauseEnd   Clause={}, Query={}\n\n", (Object)clause, (Object)clz);
            } else {
                log.warn(">>> clauseStart Clause={}, Query={}", (Object)clause, (Object)clz);
            }
        }
        if (this.handlers.isEmpty() || this.tableField.isEmpty()) {
            return;
        }
        WingsTableCudHandler.Cud cud = (WingsTableCudHandler.Cud)((Object)context.data((Object)ContextKey.EXECUTING_VISIT_CUD));
        if (cud == null) {
            return;
        }
        clause = context.clause();
        if (clause != Clause.INSERT && clause != Clause.UPDATE & clause != Clause.DELETE) {
            return;
        }
        if (context.renderContext() == null) {
            return;
        }
        String tbl = (String)context.data((Object)ContextKey.EXECUTING_TABLE_STR);
        if (tbl == null) {
            log.warn("find CUD without table, may be unsupported, sql={}", (Object)context.renderContext());
            return;
        }
        Map field = (Map)context.data((Object)ContextKey.EXECUTING_FIELD_MAP);
        Object upd = context.data((Object)ContextKey.EXECUTING_INSERT_UPD);
        if (upd == Boolean.TRUE) {
            log.debug("find INSERT_ON_DUPLICATE_KEY_UPDATE, set CUD to update");
            cud = WingsTableCudHandler.Cud.Update;
        }
        log.debug("handle CUD={}, table={}, filed={}", new Object[]{cud, tbl, field});
        Class<?> src = this.getClass();
        Supplier<Map<String, List<?>>> sup = field == null ? Collections::emptyMap : () -> field;
        for (WingsTableCudHandler hd : this.handlers) {
            try {
                hd.handle(src, cud, tbl, sup);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append("failed to handle cud=").append((Object)cud);
                msg.append(", table=").append(tbl);
                msg.append(", handle=").append(hd.getClass());
                if (field != null && !field.isEmpty()) {
                    msg.append(", field=");
                    for (Map.Entry en : field.entrySet()) {
                        msg.append(',').append((String)en.getKey()).append(':').append(en.getValue());
                    }
                }
                log.error(msg.toString(), (Throwable)e);
            }
        }
    }

    public void visitStart(VisitContext context) {
        if (WarnVisit) {
            Context ctx = context.context();
            Configuration cnf = ctx.configuration();
            log.warn("==> visitStart  Clause={}, Query={}, Context={}, Config={}", new Object[]{context.clause(), this.scn(context.queryPart()), ctx.getClass().getSimpleName() + "@" + System.identityHashCode(ctx), cnf.getClass().getSimpleName() + "@" + System.identityHashCode(cnf)});
        }
        if (this.handlers.isEmpty() || this.tableField.isEmpty()) {
            return;
        }
        if (context.renderContext() == null) {
            return;
        }
        WingsTableCudHandler.Cud cud = (WingsTableCudHandler.Cud)((Object)context.data((Object)ContextKey.EXECUTING_VISIT_CUD));
        if (cud == null) {
            return;
        }
        if (cud == WingsTableCudHandler.Cud.Create) {
            this.handleInsert(context);
        } else if (cud == WingsTableCudHandler.Cud.Update) {
            this.handleUpdate(context);
        } else if (cud == WingsTableCudHandler.Cud.Delete) {
            this.handleDelete(context);
        }
    }

    private void handleDelete(VisitContext context) {
        Clause clause = context.clause();
        QueryPart query = context.queryPart();
        if (clause == Clause.TABLE_REFERENCE && query instanceof TableImpl) {
            this.handleTable(context, (TableImpl)query);
        } else if (clause == Clause.DELETE_WHERE && query instanceof Keyword) {
            log.debug("handle delete-where");
            context.data((Object)ContextKey.EXECUTING_WHERE_CMP, (Object)"");
        } else {
            this.handleWhere(context, clause, query);
        }
    }

    private void handleUpdate(VisitContext context) {
        Clause clause = context.clause();
        QueryPart query = context.queryPart();
        if (clause == Clause.TABLE_REFERENCE && query instanceof TableImpl) {
            this.handleTable(context, (TableImpl)query);
        } else if (clause == Clause.UPDATE_SET && query instanceof Map) {
            Map updSet = (Map)query;
            Set fds = (Set)context.data((Object)ContextKey.EXECUTING_FIELD_KEY);
            if (fds == null) {
                log.warn("should not be here, update-table without key");
                return;
            }
            if (fds.isEmpty()) {
                log.debug("skip careless field in update");
                return;
            }
            Map field = (Map)context.data((Object)ContextKey.EXECUTING_FIELD_MAP);
            if (field == null) {
                log.warn("should not be here, update-table without field");
                return;
            }
            for (Map.Entry en : updSet.entrySet()) {
                Object ky = en.getKey();
                Object vl = en.getValue();
                if (!(ky instanceof TableField) || vl != null && !(vl instanceof Param)) continue;
                String fd = ((TableField)ky).getName();
                if (fds.contains(fd)) {
                    List lst = field.computeIfAbsent(fd, k -> new ArrayList());
                    lst.add(vl == null ? null : ((Param)vl).getValue());
                    log.debug("handle update-field, name={}", (Object)fd);
                    continue;
                }
                log.debug("skip careless update-field, name={}", (Object)fd);
            }
        } else if (clause == Clause.UPDATE_WHERE && query instanceof Keyword) {
            log.debug("handle update-where");
            context.data((Object)ContextKey.EXECUTING_WHERE_CMP, (Object)"");
        } else {
            this.handleWhere(context, clause, query);
        }
    }

    private void handleWhere(VisitContext context, Clause clause, QueryPart query) {
        if (clause == Clause.FIELD_REFERENCE && query instanceof TableField) {
            TableField field = (TableField)query;
            if (context.data((Object)ContextKey.EXECUTING_WHERE_CMP) == null) {
                log.debug("skip where without where-clause");
                return;
            }
            Set fds = (Set)context.data((Object)ContextKey.EXECUTING_FIELD_KEY);
            if (fds == null) {
                log.warn("should not be here, table without key");
                return;
            }
            String fd = field.getName();
            if (fds.contains(fd)) {
                log.debug("handle where-field={}", (Object)fd);
                context.data((Object)ContextKey.EXECUTING_WHERE_KEY, (Object)fd);
            } else {
                log.debug("skip careless where-field={}", (Object)fd);
                context.data((Object)ContextKey.EXECUTING_WHERE_KEY, null);
            }
        } else if (clause == Clause.CONDITION_COMPARISON || clause == Clause.CONDITION_IN) {
            if (query instanceof QOM.Eq || query instanceof QOM.Ge || query instanceof QOM.Le) {
                log.debug("handle comparison. key={}", (Object)query);
                context.data((Object)ContextKey.EXECUTING_WHERE_CMP, (Object)WHERE_EQ);
            } else if (query instanceof QOM.In || query instanceof QOM.InList) {
                log.debug("handle comparison. key=in");
                context.data((Object)ContextKey.EXECUTING_WHERE_CMP, (Object)WHERE_IN);
            }
        } else if (clause == Clause.FIELD_VALUE && query instanceof Param) {
            Param param = (Param)query;
            String fd = (String)context.data((Object)ContextKey.EXECUTING_WHERE_KEY);
            if (fd == null) {
                log.debug("skip where-field without where-key or careless");
                return;
            }
            Map map = (Map)context.data((Object)ContextKey.EXECUTING_FIELD_MAP);
            if (map == null) {
                log.debug("skip where-field without where-table or careless");
                return;
            }
            Object cmp = context.data((Object)ContextKey.EXECUTING_WHERE_CMP);
            if (cmp == WHERE_EQ || cmp == WHERE_IN) {
                log.debug("handle where-value key={}", cmp);
                List lst = map.computeIfAbsent(fd, k -> new ArrayList());
                lst.add(param.getValue());
            }
        }
    }

    private void handleTable(VisitContext context, TableImpl<?> query) {
        String tbl = query.getName();
        Set<String> fds = this.tableField.get(tbl);
        if (fds == null) {
            if (WarnVisit) {
                log.warn("skip careless table={}", (Object)tbl);
            } else {
                log.debug("skip careless table={}", (Object)tbl);
            }
            context.data((Object)ContextKey.EXECUTING_VISIT_CUD, null);
        } else {
            log.debug("handle table={}", (Object)tbl);
            context.data((Object)ContextKey.EXECUTING_TABLE_STR, (Object)tbl);
            context.data((Object)ContextKey.EXECUTING_FIELD_KEY, fds);
            context.data((Object)ContextKey.EXECUTING_FIELD_MAP, new LinkedHashMap());
        }
    }

    private void handleInsert(VisitContext context) {
        Clause clause = context.clause();
        QueryPart query = context.queryPart();
        if (clause == Clause.TABLE_REFERENCE && query instanceof TableImpl) {
            this.handleTable(context, (TableImpl)query);
        } else if (clause == Clause.INSERT_INSERT_INTO && query instanceof Collection) {
            Collection col = (Collection)query;
            Set fds = (Set)context.data((Object)ContextKey.EXECUTING_FIELD_KEY);
            if (fds == null) {
                log.warn("should not be here, insert-table without key");
                return;
            }
            if (fds.isEmpty()) {
                log.debug("skip careless field in insert");
                return;
            }
            int cnt = 0;
            HashMap<Integer, String> idx = new HashMap<Integer, String>();
            for (Object o : col) {
                if (!(o instanceof TableField)) continue;
                ++cnt;
                String name = ((TableField)o).getName();
                if (!fds.contains(name)) continue;
                log.debug("handle insert-field index={}, name={}", (Object)cnt, (Object)name);
                idx.put(cnt, name);
            }
            if (cnt > 0) {
                log.debug("handle insert-fields. count={}", (Object)cnt);
                context.data((Object)ContextKey.EXECUTING_INSERT_IDX, idx);
                context.data((Object)ContextKey.EXECUTING_INSERT_CNT, (Object)new AtomicInteger(0));
            }
        } else if (clause == Clause.FIELD_VALUE && query instanceof Param) {
            Param param = (Param)query;
            Map idx = (Map)context.data((Object)ContextKey.EXECUTING_INSERT_IDX);
            if (idx == null) {
                log.debug("skip careless insert-fields without index");
                return;
            }
            AtomicInteger cnt = (AtomicInteger)context.data((Object)ContextKey.EXECUTING_INSERT_CNT);
            if (cnt == null) {
                log.warn("should not be here, insert-fields without cnt");
                return;
            }
            String name = (String)idx.get(cnt.incrementAndGet());
            if (name == null) {
                log.debug("skip careless insert-field not in index");
            } else {
                Map field = (Map)context.data((Object)ContextKey.EXECUTING_FIELD_MAP);
                if (field == null) {
                    log.warn("should not be here, insert-field without field");
                } else {
                    List lst = field.computeIfAbsent(name, k -> new ArrayList());
                    lst.add(param.getValue());
                    log.debug("handle insert-field={} with value", (Object)name);
                }
            }
        } else if (clause == Clause.INSERT_ON_DUPLICATE_KEY_UPDATE && query instanceof Keyword) {
            context.data((Object)ContextKey.EXECUTING_INSERT_UPD, (Object)Boolean.TRUE);
        }
    }

    @Override
    public boolean accept(@NotNull Class<?> source, @NotNull WingsTableCudHandler.Cud cud, @NotNull String table) {
        if (source == this.getClass() || this.handlers.isEmpty()) {
            return false;
        }
        Set<String> fld = this.tableField.get(table);
        if (fld == null) {
            return false;
        }
        if (this.create && (cud == WingsTableCudHandler.Cud.Create || cud == WingsTableCudHandler.Cud.Unsure)) {
            return true;
        }
        if (this.update && (cud == WingsTableCudHandler.Cud.Update || cud == WingsTableCudHandler.Cud.Unsure)) {
            return true;
        }
        return this.delete && (cud == WingsTableCudHandler.Cud.Delete || cud == WingsTableCudHandler.Cud.Unsure);
    }

    @Nullable
    private String scn(QueryPart obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TableImpl) {
            TableImpl f = (TableImpl)obj;
            return obj.getClass().getSimpleName() + ":" + f.getName();
        }
        if (obj instanceof TableField) {
            TableField f = (TableField)obj;
            return obj.getClass().getSimpleName() + ":" + f.getName();
        }
        if (obj instanceof Param) {
            Param p = (Param)obj;
            return obj.getClass().getSimpleName() + ":name=" + p.getParamName() + ",value=" + String.valueOf(p.getValue());
        }
        if (obj instanceof Keyword) {
            Keyword k = (Keyword)obj;
            return obj.getClass().getSimpleName() + ":" + String.valueOf(k);
        }
        return obj.getClass().getSimpleName();
    }

    @Generated
    public void setCreate(boolean create) {
        this.create = create;
    }

    @Generated
    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Generated
    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Generated
    public void setHandlers(List<WingsTableCudHandler> handlers) {
        this.handlers = handlers;
    }

    @Generated
    public void setTableField(Map<String, Set<String>> tableField) {
        this.tableField = tableField;
    }

    @Generated
    public boolean isCreate() {
        return this.create;
    }

    @Generated
    public boolean isUpdate() {
        return this.update;
    }

    @Generated
    public boolean isDelete() {
        return this.delete;
    }

    @Generated
    public List<WingsTableCudHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    public Map<String, Set<String>> getTableField() {
        return this.tableField;
    }

    public static enum ContextKey {
        EXECUTING_VISIT_CUD,
        EXECUTING_TABLE_STR,
        EXECUTING_FIELD_KEY,
        EXECUTING_FIELD_MAP,
        EXECUTING_INSERT_IDX,
        EXECUTING_INSERT_CNT,
        EXECUTING_INSERT_UPD,
        EXECUTING_WHERE_KEY,
        EXECUTING_WHERE_CMP;

    }
}

